/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.core.rtsystem;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteProxyRuntimeClient;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteProxyRuntimeSystem;
import org.eclipse.ptp.rm.ibm.pe.core.rtsystem.PEProxyRuntimeClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PERuntimeSystem
extends AbstractRemoteProxyRuntimeSystem {
    public PERuntimeSystem(PEProxyRuntimeClient proxy) {
        super((AbstractRemoteProxyRuntimeClient)proxy);
    }

    public List<IAttribute<?, ?, ?>> getAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        List attrs = super.getAttributes(configuration, mode);
        if (configuration.getAttribute("PE_ADVANCED_MODE", "").equals("yes")) {
            this.addAttribute(configuration, attrs, "PE_ENV_SCRIPT");
        } else {
            for (Object key : configuration.getAttributes().keySet()) {
                String name;
                if (!(key instanceof String) || !(name = (String)key).startsWith("MP_") && (!name.startsWith("PE_") || name.equals("PE_ENV_SCRIPT"))) continue;
                this.addAttribute(configuration, attrs, name);
            }
        }
        return attrs;
    }

    private void addAttribute(ILaunchConfiguration config, List<IAttribute<?, ?, ?>> attrs, String attrName) {
        if (this.getAttributeDefinitionManager().getAttributeDefinition(attrName) != null) {
            String attrValue;
            try {
                attrValue = config.getAttribute(attrName, "");
            }
            catch (CoreException coreException) {
                attrValue = "";
            }
            String defaultValue = this.getAttrDefaultValue(attrName);
            if (attrValue.length() > 0 && !attrValue.equals(defaultValue)) {
                StringAttributeDefinition attrDef = new StringAttributeDefinition(attrName, "", "", false, "");
                StringAttribute attr = new StringAttribute(attrDef, attrValue);
                attrs.add((IAttribute<?, ?, ?>)attr);
            }
        }
    }

    private String getAttrDefaultValue(String attrName) {
        IAttributeDefinition attrDef = this.getAttributeDefinitionManager().getAttributeDefinition(attrName);
        if (attrDef != null) {
            try {
                return attrDef.create().getValueAsString();
            }
            catch (IllegalValueException illegalValueException) {
                return "";
            }
        }
        return "";
    }
}

