/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.RootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchRootVMNode
extends RootVMNode
implements IRootVMNode {
    public LaunchRootVMNode(AbstractVMProvider provider) {
        super(provider);
    }

    public String toString() {
        return "LaunchRootVMNode";
    }

    @Override
    public boolean isDeltaEvent(Object rootObject, Object e) {
        if (e instanceof DebugEvent) {
            DebugEvent de = (DebugEvent)e;
            if (de.getSource() instanceof IProcess && !((IProcess)de.getSource()).getLaunch().equals(rootObject)) {
                return false;
            }
            if (de.getSource() instanceof IDebugElement && !rootObject.equals(((IDebugElement)de.getSource()).getLaunch())) {
                return false;
            }
        } else if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            return true;
        }
        return super.isDeltaEvent(rootObject, e);
    }

    @Override
    public int getDeltaFlags(Object e) {
        int flags = 0;
        if (e instanceof LaunchesEvent) {
            LaunchesEvent le = (LaunchesEvent)e;
            if (le.fType == LaunchesEvent.Type.CHANGED || le.fType == LaunchesEvent.Type.TERMINATED) {
                flags = 3072;
            }
        } else if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            flags = 0x300000;
        }
        return flags;
    }

    @Override
    public void createRootDelta(Object rootObject, Object event, DataRequestMonitor<VMDelta> rm) {
        if (!(rootObject instanceof ILaunch)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10001, "Invalid root element configured with launch root node.", null));
            rm.done();
            return;
        }
        ILaunch rootLaunch = (ILaunch)rootObject;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        List<ILaunch> launchList = Arrays.asList(manager.getLaunches());
        VMDelta viewRootDelta = new VMDelta(manager, 0, 0, launchList.size());
        VMDelta rootDelta = viewRootDelta.addNode((Object)rootLaunch, launchList.indexOf(rootLaunch), 0);
        if (event instanceof LaunchesEvent) {
            LaunchesEvent le = (LaunchesEvent)event;
            ILaunch[] iLaunchArray = le.fLaunches;
            int n = le.fLaunches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (rootLaunch == launch) {
                    if (le.fType == LaunchesEvent.Type.CHANGED) {
                        rootDelta.setFlags(rootDelta.getFlags() | 0x800 | 0x400);
                    } else if (le.fType == LaunchesEvent.Type.TERMINATED) {
                        rootDelta.setFlags(rootDelta.getFlags() | 0x800 | 0x400);
                    }
                }
                ++n2;
            }
        } else if (event instanceof ModelProxyInstalledEvent || event instanceof DataModelInitializedEvent) {
            rootDelta.setFlags(rootDelta.getFlags() | 0x100000 | 0x200000);
        }
        rm.setData((Object)rootDelta);
        rm.done();
    }

    public static class LaunchesEvent {
        public final ILaunch[] fLaunches;
        public final Type fType;

        public LaunchesEvent(ILaunch[] launches, Type type) {
            this.fLaunches = launches;
            this.fType = type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ADDED,
            REMOVED,
            CHANGED,
            TERMINATED;

        }
    }
}

