/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.resources.ui.EditorInteractionMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceChangeMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceInteractionMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceInterestUpdater;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesUiBridgePlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.resources.ui";
    private static ResourcesUiBridgePlugin INSTANCE;
    private ResourceChangeMonitor resourceChangeMonitor;
    private ResourceInteractionMonitor resourceInteractionMonitor;
    private EditorInteractionMonitor interestEditorTracker;
    private ResourceInterestUpdater interestUpdater;
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ResourcesUiBridgePlugin.this.updateResourceMonitorEnablement();
        }
    };

    public ResourcesUiBridgePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.interestUpdater = new ResourceInterestUpdater();
    }

    protected void lazyStart() {
        this.resourceChangeMonitor = new ResourceChangeMonitor();
        this.updateResourceMonitorEnablement();
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        this.resourceInteractionMonitor = new ResourceInteractionMonitor();
        this.interestEditorTracker = new EditorInteractionMonitor();
        MonitorUi.getSelectionMonitors().add(this.resourceInteractionMonitor);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeMonitor, 1);
        this.interestEditorTracker.install(PlatformUI.getWorkbench());
    }

    protected void lazyStop() {
        this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        if (this.resourceChangeMonitor != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeMonitor);
        }
        if (this.resourceInteractionMonitor != null) {
            MonitorUi.getSelectionMonitors().remove((Object)this.resourceInteractionMonitor);
            this.resourceChangeMonitor.dispose();
        }
        if (this.interestEditorTracker != null) {
            this.interestEditorTracker.dispose(PlatformUI.getWorkbench());
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
    }

    public List<IResource> getInterestingResources(IInteractionContext context) {
        ArrayList<IResource> interestingResources = new ArrayList<IResource>();
        Set resourceElements = ContextCore.getContextManager().getActiveDocuments(context);
        for (IInteractionElement element : resourceElements) {
            IResource resource = this.getResourceForElement(element, false);
            if (resource == null) continue;
            interestingResources.add(resource);
        }
        return interestingResources;
    }

    public static ResourceInterestUpdater getInterestUpdater() {
        return ResourcesUiBridgePlugin.INSTANCE.interestUpdater;
    }

    public IResource getResourceForElement(IInteractionElement element, boolean findContainingResource) {
        Object adapted;
        if (element == null) {
            return null;
        }
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)element.getContentType());
        Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable && (adapted = ((IAdaptable)object).getAdapter(IResource.class)) instanceof IResource) {
            return (IResource)adapted;
        }
        if (findContainingResource) {
            String parentHandle = bridge.getParentHandle(element.getHandleIdentifier());
            if (element.getHandleIdentifier().equals(parentHandle)) {
                return null;
            }
            return this.getResourceForElement(ContextCore.getContextManager().getElement(parentHandle), true);
        }
        return null;
    }

    public void setResourceMonitoringEnabled(boolean enabled) {
        this.resourceChangeMonitor.setEnabled(enabled);
    }

    public static ResourcesUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    @Deprecated
    public ResourceBundle getResourceBundle() {
        return null;
    }

    private void updateResourceMonitorEnablement() {
        this.resourceChangeMonitor.setEnabled(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.resources.resource.monitor.enabled"));
    }

    public static class ResourcesUiBridgeStartup
    implements IContextUiStartup {
        public void lazyStartup() {
            ResourcesUiBridgePlugin.getDefault().lazyStart();
        }
    }
}

