/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import com.ibm.icu.text.MessageFormat;
import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;

public class CModule
extends CDebugElement
implements ICModule {
    private int fType = 0;
    private Binary fBinary;
    private ICDIObject fCDIObject;
    private IPath fImageName;
    private IPath fSymbolsFileName;

    public static CModule createExecutable(CDebugTarget target, IPath path) {
        return new CModule(1, target, path);
    }

    public static CModule createSharedLibrary(CDebugTarget target, ICDISharedLibrary lib) {
        return new CModule(2, target, lib);
    }

    private CModule(int type, CDebugTarget target, IPath path) {
        super(target);
        this.fType = type;
        this.fBinary = this.createBinary(path);
        this.fCDIObject = null;
        this.fImageName = path;
        this.fSymbolsFileName = path;
    }

    private CModule(int type, CDebugTarget target, ICDIObject cdiObject) {
        super(target);
        this.fType = type;
        if (cdiObject instanceof ICDISharedLibrary) {
            ICDISharedLibrary cdiSharedLib = (ICDISharedLibrary)cdiObject;
            this.fBinary = this.createBinary((IPath)new Path(cdiSharedLib.getFileName()));
        }
        this.fCDIObject = cdiObject;
        this.fSymbolsFileName = this.fImageName = cdiObject instanceof ICDISharedLibrary ? new Path(((ICDISharedLibrary)cdiObject).getFileName()) : new Path(CoreModelMessages.getString("CModule.0"));
    }

    private Binary createBinary(IPath path) {
        IFile[] files;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation(path);
        if (file != null && !file.exists()) {
            file = null;
        }
        if (file == null && (files = root.findFilesForLocation(path)).length > 0) {
            file = files[0];
        }
        if (file != null) {
            ICProject cproject = CoreModel.getDefault().create(file.getProject());
            IPath resourcePath = file.getParent().getFullPath();
            try {
                IBinaryParser.IBinaryFile bin;
                ICElement cfolder = cproject.findElement(resourcePath);
                ISourceRoot sourceRoot = cproject.findSourceRoot(resourcePath);
                if (sourceRoot != null) {
                    cfolder = sourceRoot;
                }
                if ((bin = CModelManager.getDefault().createBinaryFile(file)) != null) {
                    return new Binary(cfolder, file, (IBinaryParser.IBinaryObject)bin);
                }
            }
            catch (CModelException e) {
                CDebugCorePlugin.log(e);
            }
        }
        return null;
    }

    public int getType() {
        return this.fType;
    }

    public String getName() {
        return this.fImageName.lastSegment().toString();
    }

    public IPath getImageName() {
        return this.fImageName;
    }

    public IPath getSymbolsFileName() {
        return this.fSymbolsFileName;
    }

    public void setSymbolsFileName(IPath symbolsFile) throws DebugException {
        this.loadSymbolsFromFile(symbolsFile);
        this.fSymbolsFileName = symbolsFile;
    }

    public IAddress getBaseAddress() {
        return this.fCDIObject instanceof ICDISharedLibrary ? this.getAddressFactory().createAddress(((ICDISharedLibrary)this.fCDIObject).getStartAddress()) : this.getAddressFactory().getZero();
    }

    public long getSize() {
        long result = 0L;
        if (this.fCDIObject instanceof ICDISharedLibrary) {
            BigInteger start = ((ICDISharedLibrary)this.fCDIObject).getStartAddress();
            BigInteger end = ((ICDISharedLibrary)this.fCDIObject).getEndAddress();
            if (end.compareTo(start) > 0) {
                result = end.subtract(start).longValue();
            }
        }
        return result;
    }

    public boolean areSymbolsLoaded() {
        if (this.fCDIObject instanceof ICDISharedLibrary) {
            return ((ICDISharedLibrary)this.fCDIObject).areSymbolsLoaded();
        }
        if (this.fBinary != null) {
            return this.fBinary.hasDebug();
        }
        return false;
    }

    public boolean canLoadSymbols() {
        return this.getDebugTarget().isSuspended() && !this.areSymbolsLoaded();
    }

    public void loadSymbols() throws DebugException {
        this.loadSymbolsFromFile(this.getSymbolsFileName());
    }

    public String getPlatform() {
        return this.fBinary != null ? this.fBinary.getCPU() : CoreModelMessages.getString("CModule.1");
    }

    public boolean isLittleEndian() {
        return this.fBinary != null ? this.fBinary.isLittleEndian() : ((CDebugTarget)this.getDebugTarget()).isLittleEndian();
    }

    public IAddressFactory getAddressFactory() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
    }

    public String getCPU() {
        return this.fBinary != null ? this.fBinary.getCPU() : null;
    }

    public Object getAdapter(Class adapter) {
        if (ICElement.class.equals((Object)adapter)) {
            return this.getCElement();
        }
        if (IBinary.class.equals((Object)adapter) && this.getCElement() instanceof IBinary) {
            return this.getCElement();
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
    }

    public boolean equals(ICDIObject cdiObject) {
        return this.fCDIObject != null ? this.fCDIObject.equals(cdiObject) : false;
    }

    protected ICElement getCElement() {
        return this.fBinary;
    }

    private void loadSymbolsFromFile(IPath path) throws DebugException {
        if (this.fCDIObject instanceof ICDISharedLibrary) {
            if (path == null || path.isEmpty()) {
                CModule.requestFailed(CoreModelMessages.getString("CModule.2"), null);
            } else if (path.equals((Object)this.getSymbolsFileName())) {
                try {
                    ((ICDISharedLibrary)this.fCDIObject).loadSymbols();
                }
                catch (CDIException e) {
                    CModule.targetRequestFailed(e.getMessage(), null);
                }
            } else {
                String message = MessageFormat.format((String)CoreModelMessages.getString("CModule.5"), (Object[])new Object[]{path.toString()});
                CModule.targetRequestFailed(message, null);
            }
        }
    }
}

