/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.ui.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.mpi.mpich2.core.launch.MPICH2LaunchConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.launch.MPICH2LaunchConfigurationDefaults;
import org.eclipse.ptp.rm.mpi.mpich2.ui.MPICH2UIPlugin;
import org.eclipse.ptp.rm.mpi.mpich2.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.launch.BaseRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabDataSource;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabWidgetListener;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.utils.ui.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class BasicMPICH2RMLaunchConfigurationDynamicTab
extends BaseRMLaunchConfigurationDynamicTab {
    protected Composite control;
    protected Spinner numProcsSpinner;
    protected Button noLocalButton;
    protected Button usePrefixButton;
    protected Text prefixText;
    protected Text hostFileText;
    protected Button hostFileButton;
    protected Text hostListText;
    protected Button hostListButton;
    protected Button browseButton;

    public BasicMPICH2RMLaunchConfigurationDynamicTab(ILaunchConfigurationDialog dialog) {
        super(dialog);
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.control.setLayout((Layout)layout);
        Label label = new Label(this.control, 0);
        label.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Label_NumberProcesses);
        this.numProcsSpinner = new Spinner(this.control, 2048);
        this.numProcsSpinner.addModifyListener((ModifyListener)this.getListener());
        this.numProcsSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Group optionsGroup = new Group(this.control, 0);
        optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        optionsGroup.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Title_OptionsGroup);
        layout = new GridLayout();
        layout.numColumns = 3;
        optionsGroup.setLayout((Layout)layout);
        this.noLocalButton = new Button((Composite)optionsGroup, 32);
        this.noLocalButton.addSelectionListener((SelectionListener)this.getListener());
        this.noLocalButton.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Label_NoLocal);
        this.usePrefixButton = new Button((Composite)optionsGroup, 32);
        this.usePrefixButton.addSelectionListener((SelectionListener)this.getListener());
        this.usePrefixButton.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Label_Prefix);
        this.prefixText = new Text((Composite)optionsGroup, 2048);
        this.prefixText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.prefixText.addModifyListener((ModifyListener)this.getListener());
        Group hostGroup = new Group(this.control, 0);
        hostGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        hostGroup.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Title_HostGroup);
        layout = new GridLayout();
        layout.numColumns = 3;
        hostGroup.setLayout((Layout)layout);
        this.hostFileButton = new Button((Composite)hostGroup, 32);
        this.hostFileButton.addSelectionListener((SelectionListener)this.getListener());
        this.hostFileButton.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Label_HostFile);
        this.hostFileText = new Text((Composite)hostGroup, 2048);
        this.hostFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hostFileText.addModifyListener((ModifyListener)this.getListener());
        this.browseButton = new Button((Composite)hostGroup, 0);
        this.browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.browseButton.addSelectionListener((SelectionListener)this.getListener());
        PixelConverter pixelconverter = new PixelConverter((Control)this.control);
        GridData gd = new GridData(131072, 0x1000000, false, false);
        gd.widthHint = pixelconverter.convertHorizontalDLUsToPixels(61);
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Label_Browse);
        this.hostListButton = new Button((Composite)hostGroup, 32);
        this.hostListButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.hostListButton.addSelectionListener((SelectionListener)this.getListener());
        this.hostListButton.setText(Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Title_HostList);
        this.hostListText = new Text((Composite)hostGroup, 2560);
        gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = 20;
        this.hostListText.setLayoutData((Object)gd);
        this.hostListText.addModifyListener((ModifyListener)this.getListener());
    }

    public Control getControl() {
        return this.control;
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Title;
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_NUMPROCS, MPICH2LaunchConfigurationDefaults.ATTR_NUMPROCS);
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_NOLOCAL, MPICH2LaunchConfigurationDefaults.ATTR_NOLOCAL);
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_USEPREFIX, MPICH2LaunchConfigurationDefaults.ATTR_USEPREFIX);
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_PREFIX, MPICH2LaunchConfigurationDefaults.ATTR_PREFIX);
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_USEHOSTFILE, MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTFILE);
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_HOSTFILE, MPICH2LaunchConfigurationDefaults.ATTR_HOSTFILE);
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_USEHOSTLIST, MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTLIST);
        configuration.setAttribute(MPICH2LaunchConfiguration.ATTR_HOSTLIST, MPICH2LaunchConfigurationDefaults.ATTR_HOSTLIST);
        return new RMLaunchValidation(true, null);
    }

    public void updateControls() {
        this.prefixText.setEnabled(this.usePrefixButton.getSelection());
        this.browseButton.setEnabled(this.hostFileButton.getSelection());
        this.hostFileText.setEnabled(this.hostFileButton.getSelection());
        this.hostListText.setEnabled(this.hostListButton.getSelection());
    }

    protected RMLaunchConfigurationDynamicTabDataSource createDataSource() {
        return new DataSource(this);
    }

    protected RMLaunchConfigurationDynamicTabWidgetListener createListener() {
        return new WidgetListener(this);
    }

    private class DataSource
    extends RMLaunchConfigurationDynamicTabDataSource {
        private int numProcs;
        private boolean noLocal;
        private boolean usePrefix;
        private String prefix;
        private boolean useHostFile;
        private String hostFile;
        private boolean useHostList;
        private String hostList;

        protected DataSource(BaseRMLaunchConfigurationDynamicTab page) {
            super(page);
        }

        private String hostListToText(String list) {
            if (list == null) {
                return "";
            }
            String result = "";
            String[] values = list.split(",");
            int i = 0;
            while (i < values.length) {
                if (!values[i].equals("")) {
                    if (i > 0) {
                        result = String.valueOf(result) + "\n";
                    }
                    result = String.valueOf(result) + values[i];
                }
                ++i;
            }
            return result;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            this.numProcs = BasicMPICH2RMLaunchConfigurationDynamicTab.this.numProcsSpinner.getSelection();
            this.noLocal = BasicMPICH2RMLaunchConfigurationDynamicTab.this.noLocalButton.getSelection();
            this.usePrefix = BasicMPICH2RMLaunchConfigurationDynamicTab.this.usePrefixButton.getSelection();
            this.prefix = this.extractText(BasicMPICH2RMLaunchConfigurationDynamicTab.this.prefixText);
            this.useHostFile = BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostFileButton.getSelection();
            this.hostFile = this.extractText(BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostFileText);
            this.useHostList = BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostListButton.getSelection();
            this.hostList = this.extractText(BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostListText);
        }

        protected void copyToFields() {
            BasicMPICH2RMLaunchConfigurationDynamicTab.this.numProcsSpinner.setSelection(this.numProcs);
            BasicMPICH2RMLaunchConfigurationDynamicTab.this.noLocalButton.setSelection(this.noLocal);
            BasicMPICH2RMLaunchConfigurationDynamicTab.this.usePrefixButton.setSelection(this.usePrefix);
            this.applyText(BasicMPICH2RMLaunchConfigurationDynamicTab.this.prefixText, this.prefix);
            this.applyText(BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostFileText, this.hostFile);
            BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostFileButton.setSelection(this.useHostFile);
            this.applyText(BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostListText, this.hostListToText(this.hostList));
            BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostListButton.setSelection(this.useHostList);
        }

        protected void copyToStorage() {
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_NUMPROCS, this.numProcs);
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_NOLOCAL, this.noLocal);
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_USEPREFIX, this.usePrefix);
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_PREFIX, this.prefix);
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_USEHOSTFILE, this.useHostFile);
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_HOSTFILE, this.hostFile);
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_USEHOSTLIST, this.useHostList);
            this.getConfigurationWorkingCopy().setAttribute(MPICH2LaunchConfiguration.ATTR_HOSTLIST, this.hostList);
        }

        protected void loadDefault() {
            this.numProcs = MPICH2LaunchConfigurationDefaults.ATTR_NUMPROCS;
            this.noLocal = MPICH2LaunchConfigurationDefaults.ATTR_NOLOCAL;
            this.usePrefix = MPICH2LaunchConfigurationDefaults.ATTR_USEPREFIX;
            this.prefix = MPICH2LaunchConfigurationDefaults.ATTR_PREFIX;
            this.hostFile = MPICH2LaunchConfigurationDefaults.ATTR_HOSTFILE;
            this.useHostFile = MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTFILE;
            this.hostList = MPICH2LaunchConfigurationDefaults.ATTR_HOSTLIST;
            this.useHostList = MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTLIST;
        }

        protected void loadFromStorage() {
            try {
                this.numProcs = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_NUMPROCS, MPICH2LaunchConfigurationDefaults.ATTR_NUMPROCS);
                this.noLocal = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_NOLOCAL, MPICH2LaunchConfigurationDefaults.ATTR_NOLOCAL);
                this.usePrefix = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_USEPREFIX, MPICH2LaunchConfigurationDefaults.ATTR_USEPREFIX);
                this.prefix = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_PREFIX, MPICH2LaunchConfigurationDefaults.ATTR_PREFIX);
                this.hostFile = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_HOSTFILE, MPICH2LaunchConfigurationDefaults.ATTR_HOSTFILE);
                this.useHostFile = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_USEHOSTFILE, MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTFILE);
                this.hostList = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_HOSTLIST, MPICH2LaunchConfigurationDefaults.ATTR_HOSTLIST);
                this.useHostList = this.getConfiguration().getAttribute(MPICH2LaunchConfiguration.ATTR_USEHOSTLIST, MPICH2LaunchConfigurationDefaults.ATTR_USEHOSTLIST);
            }
            catch (CoreException e) {
                MPICH2UIPlugin.log(e);
            }
        }

        protected void validateLocal() throws DataSource.ValidationException {
            if (this.numProcs < 1) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Validation_NoProcess);
            }
            if (this.usePrefix && this.prefix == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Validation_EmptyPrefix);
            }
            if (this.useHostFile && this.hostFile == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Validation_EmptyHostfile);
            }
            if (this.useHostList && this.hostList == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.BasicMPICH2RMLaunchConfigurationDynamicTab_Validation_EmptyHostList);
            }
        }
    }

    private class WidgetListener
    extends RMLaunchConfigurationDynamicTabWidgetListener {
        public WidgetListener(BaseRMLaunchConfigurationDynamicTab dynamicTab) {
            super(dynamicTab);
        }

        protected void doModifyText(ModifyEvent e) {
            if (e.getSource() != BasicMPICH2RMLaunchConfigurationDynamicTab.this.numProcsSpinner && e.getSource() != BasicMPICH2RMLaunchConfigurationDynamicTab.this.prefixText && e.getSource() != BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostFileText && e.getSource() != BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostListText) {
                super.doModifyText(e);
            }
        }

        protected void doWidgetSelected(SelectionEvent e) {
            if (e.getSource() != BasicMPICH2RMLaunchConfigurationDynamicTab.this.noLocalButton && e.getSource() != BasicMPICH2RMLaunchConfigurationDynamicTab.this.usePrefixButton) {
                if (e.getSource() == BasicMPICH2RMLaunchConfigurationDynamicTab.this.usePrefixButton || e.getSource() == BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostFileButton || e.getSource() == BasicMPICH2RMLaunchConfigurationDynamicTab.this.hostListButton) {
                    BasicMPICH2RMLaunchConfigurationDynamicTab.this.updateControls();
                } else {
                    super.doWidgetSelected(e);
                }
            }
        }
    }
}

