/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.templates;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.photran.internal.cdtinterface.templates.PhotranBaseProcessRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAllBinaryParsersProcessRunner
extends PhotranBaseProcessRunner {
    private static final String BINARY_PARSERS_EXTENSION_POINT = "org.eclipse.cdt.core.BinaryParser";

    @Override
    protected void modify(IProject proj, IConfiguration cf) throws CoreException {
        this.setBinaryParsers(proj, this.collectAllBinaryParsers());
    }

    private ArrayList<String> collectAllBinaryParsers() {
        ArrayList<String> binaryParsers = new ArrayList<String>(16);
        IExtension[] iExtensionArray = this.binaryParsersExtPt().getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            String thisBinaryParser = String.valueOf(ext.getNamespaceIdentifier()) + "." + ext.getSimpleIdentifier();
            if (!this.contains(binaryParsers, thisBinaryParser)) {
                binaryParsers.add(thisBinaryParser);
            }
            ++n2;
        }
        return binaryParsers;
    }

    private IExtensionPoint binaryParsersExtPt() {
        return Platform.getExtensionRegistry().getExtensionPoint(BINARY_PARSERS_EXTENSION_POINT);
    }

    private boolean contains(ArrayList<String> binaryParsers, String thisBinaryParser) {
        for (String id : binaryParsers) {
            if (!id.equalsIgnoreCase(thisBinaryParser)) continue;
            return true;
        }
        return false;
    }

    private void setBinaryParsers(IProject proj, ArrayList<String> binaryParsers) throws CoreException {
        ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(proj);
        CoreModelUtil.setBinaryParserIds((ICConfigurationDescription[])desc.getConfigurations(), (String[])binaryParsers.toArray(new String[binaryParsers.size()]));
        CoreModel.getDefault().setProjectDescription(proj, desc);
    }
}

