/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.photran.internal.cdtinterface.CDTInterfacePlugin;
import org.eclipse.photran.internal.cdtinterface.ui.FortranView;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;

public class ProjectConversionAction
implements IViewActionDelegate {
    private IViewPart view = null;
    private ArrayList<IProject> projects = new ArrayList();

    public void init(IViewPart v) {
        this.view = v;
        this.projects = new ArrayList();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (element instanceof IProject) {
                    try {
                        IProject project = (IProject)element;
                        if (!project.hasNature("org.eclipse.cdt.core.cnature")) continue;
                        this.projects.add(project);
                    }
                    catch (CoreException ex) {
                        FortranCorePlugin.log((Throwable)ex);
                    }
                    continue;
                }
                if (!(element instanceof ICProject)) continue;
                this.projects.add(((ICProject)element).getProject());
            }
        }
    }

    public void run(IAction action) {
        if (!this.projects.isEmpty()) {
            this.addFortranNatureToSelectedProjects();
            this.refreshView();
            this.projects.clear();
        }
    }

    private void addFortranNatureToSelectedProjects() {
        for (IProject project : this.projects) {
            this.addFortranNatureTo(project);
        }
    }

    private void addFortranNatureTo(IProject project) {
        try {
            if (!project.hasNature("org.eclipse.photran.core.fnature")) {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 1, natures.length);
                newNatures[0] = "org.eclipse.photran.core.fnature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
        }
        catch (CoreException e) {
            CDTInterfacePlugin.log(e);
            e.printStackTrace();
        }
    }

    private void refreshView() {
        if (this.view instanceof FortranView) {
            ((FortranView)this.view).getViewer().refresh();
        } else if (this.view instanceof CommonNavigator) {
            ((CommonNavigator)this.view).getCommonViewer().refresh();
        }
    }
}

