/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.ui.IServiceContributor;
import org.eclipse.ptp.services.ui.IServiceProviderConfiguration;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.ptp.services.ui.ServicesUIPlugin;

public class ServiceModelUIManager {
    private static final String SERVICE_EXTENSION_ID = "serviceContributors";
    private static final String PROVIDER_EXTENSION_ID = "providerContributors";
    private static final String WIZARD_EXTENSION_ID = "wizardExtensions";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_UI_CLASS = "configurationUIClass";
    private static ServiceModelUIManager fInstance;

    public static synchronized ServiceModelUIManager getInstance() {
        if (fInstance == null) {
            fInstance = new ServiceModelUIManager();
        }
        return fInstance;
    }

    public IServiceContributor getServiceContributor(IService service) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.ui", SERVICE_EXTENSION_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getAttribute(ATTR_ID).equals(service.getId())) {
                        try {
                            return (IServiceContributor)element.createExecutableExtension(ATTR_CLASS);
                        }
                        catch (Exception e) {
                            ServicesUIPlugin.getDefault().log(e);
                            return null;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public IServiceProviderContributor getServiceProviderContributor(IServiceProviderDescriptor desc) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.ui", PROVIDER_EXTENSION_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getAttribute(ATTR_ID).equals(desc.getId()) && element.getAttribute(ATTR_CLASS) != null) {
                        try {
                            return (IServiceProviderContributor)element.createExecutableExtension(ATTR_CLASS);
                        }
                        catch (Exception e) {
                            ServicesUIPlugin.getDefault().log(e);
                            return null;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public IWizard getWizardExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.ui", WIZARD_EXTENSION_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                if (iConfigurationElementArray.length != 0) {
                    IConfigurationElement element = iConfigurationElementArray[0];
                    try {
                        return (IWizard)element.createExecutableExtension(ATTR_CLASS);
                    }
                    catch (Exception e) {
                        ServicesUIPlugin.getDefault().log(e);
                        return null;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public IServiceProviderConfiguration getServiceProviderConfigurationUI(IServiceProviderDescriptor desc) {
        IServiceProviderConfiguration config = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.ui", PROVIDER_EXTENSION_ID);
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getAttribute(ATTR_ID).equals(desc.getId())) {
                        try {
                            config = (IServiceProviderConfiguration)element.createExecutableExtension(ATTR_UI_CLASS);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return config;
    }
}

