/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.ptp.services.ui.widgets.ServiceConfigurationSelectionWidget;
import org.eclipse.ptp.services.ui.wizards.FilenameStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ServiceConfigurationExportWizard
extends Wizard
implements IImportWizard {
    private final MainExportWizardPage mainPage = new MainExportWizardPage("exportWizardPage", Messages.ServiceConfigurationExportWizard_11, null);

    public ServiceConfigurationExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ServiceConfigurationExportWizard_13);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        FilenameStore.setDefaultFromSelection(workbench);
    }

    public boolean performFinish() {
        boolean result;
        File f = new File(this.mainPage.getFileName());
        if (f.exists() && !(result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ServiceConfigurationExportWizard_14, (String)Messages.ServiceConfigurationExportWizard_15))) {
            return false;
        }
        try {
            ServiceModelManager.getInstance().exportConfigurations(this.mainPage.getFileName(), this.mainPage.getServiceConfigurations());
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return true;
    }

    private class MainExportWizardPage
    extends WizardPage {
        private String file;
        private Combo fileCombo;
        private Button browseButton;
        private int messageType;
        private ServiceConfigurationSelectionWidget serviceConfigWidget;

        public MainExportWizardPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
            this.file = "";
            this.messageType = 0;
            this.setDescription(Messages.ServiceConfigurationExportWizard_0);
        }

        public void createControl(Composite parent) {
            Composite workArea = new Composite(parent, 0);
            this.setControl((Control)workArea);
            workArea.setFont(parent.getFont());
            workArea.setLayout((Layout)new GridLayout());
            workArea.setLayoutData((Object)new GridData(1808));
            this.createFileSelectionArea(workArea);
            this.createConfigurationsSelectionArea(workArea);
            this.setControl((Control)workArea);
            Dialog.applyDialogFont((Control)parent);
            this.updateEnablement();
            this.messageType = 3;
        }

        public void createFileSelectionArea(Composite workArea) {
            Composite composite = new Composite(workArea, 0);
            composite.setFont(workArea.getFont());
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(Messages.ServiceConfigurationExportWizard_4);
            this.fileCombo = new Combo(composite, 4);
            GridData comboData = new GridData(768);
            comboData.verticalAlignment = 2;
            comboData.grabExcessVerticalSpace = false;
            comboData.widthHint = 200;
            this.fileCombo.setLayoutData((Object)comboData);
            this.file = FilenameStore.getSuggestedDefault();
            this.fileCombo.setItems(FilenameStore.getHistory());
            this.fileCombo.setText(this.file);
            this.fileCombo.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    MainExportWizardPage.this.file = MainExportWizardPage.this.fileCombo.getText();
                    MainExportWizardPage.this.updateEnablement();
                }
            });
            this.browseButton = new Button(composite, 8);
            this.browseButton.setText(Messages.ServiceConfigurationExportWizard_5);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.browseButton.setLayoutData((Object)data);
            this.browseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int separator;
                    FileDialog d = new FileDialog(MainExportWizardPage.this.getShell(), 8192);
                    d.setFilterExtensions(new String[]{"*.cfg"});
                    d.setFilterNames(new String[]{Messages.ServiceConfigurationExportWizard_6});
                    d.setFileName(Messages.ServiceConfigurationExportWizard_7);
                    String fileName = MainExportWizardPage.this.getFileName();
                    if (fileName != null && (separator = fileName.lastIndexOf(System.getProperty("file.separator").charAt(0))) != -1) {
                        fileName = fileName.substring(0, separator);
                    }
                    d.setFilterPath(fileName);
                    String f = d.open();
                    if (f != null) {
                        MainExportWizardPage.this.fileCombo.setText(f);
                        MainExportWizardPage.this.file = f;
                    }
                }
            });
        }

        public String getFileName() {
            return this.file;
        }

        public IServiceConfiguration[] getServiceConfigurations() {
            return this.serviceConfigWidget.getCheckedServiceConfigurations();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.fileCombo.setFocus();
            }
        }

        private void createConfigurationsSelectionArea(Composite workArea) {
            Composite composite = new Composite(workArea, 0);
            composite.setFont(workArea.getFont());
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(Messages.ServiceConfigurationExportWizard_1);
            this.serviceConfigWidget = new ServiceConfigurationSelectionWidget(composite, 32, null, null, true);
            GridData data = new GridData(1808);
            data.heightHint = 100;
            this.serviceConfigWidget.setLayoutData(data);
            this.serviceConfigWidget.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MainExportWizardPage.this.updateEnablement();
                }
            });
        }

        private void updateEnablement() {
            boolean complete = false;
            this.setMessage(null);
            this.setPageComplete(false);
            if (this.getServiceConfigurations().length == 0) {
                this.setPageComplete(false);
                return;
            }
            if (this.file.length() == 0) {
                this.setMessage(Messages.ServiceConfigurationExportWizard_8, this.messageType);
                this.setPageComplete(false);
                return;
            }
            File f = new File(this.file);
            if (f.isDirectory()) {
                this.setMessage(Messages.ServiceConfigurationExportWizard_9, this.messageType);
                this.setPageComplete(false);
                return;
            }
            complete = true;
            if (complete) {
                this.setErrorMessage(null);
                this.setDescription(Messages.ServiceConfigurationExportWizard_10);
            }
            this.setPageComplete(complete);
        }
    }
}

