/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIExitInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDISignalInfo;
import org.eclipse.ptp.debug.core.pdi.manager.AbstractEventManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.debug.core.pdi.request.IPDIBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDICommandRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIConditionBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDeleteBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDeleteVariableRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDisableBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEnableBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGoRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDISetCurrentStackFrameRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStartDebuggerRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepFinishRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepIntoInstructionRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepIntoRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepOverInstructionRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepOverRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDITerminateRequest;
import org.eclipse.ptp.debug.sdm.core.messages.Messages;
import org.eclipse.ptp.debug.sdm.core.proxy.ProxyDebugClient;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugLocator;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugArgsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugDataEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugErrorEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEventListener;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugExitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugInfoThreadsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugMemoryInfoEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugOKEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugOutputEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSetThreadSelectEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalExitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStackInfoDepthEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStackframeEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStepEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSuspendEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugTypeEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugVarsEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDMEventManager
extends AbstractEventManager
implements IProxyDebugEventListener {
    public SDMEventManager(IPDISession session) {
        super(session);
    }

    public void handleProxyDebugArgsEvent(IProxyDebugArgsEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugBreakpointHitEvent(IProxyDebugBreakpointHitEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ArrayList<Object> eventList = new ArrayList<Object>();
        IPDIBreakpoint bpt = this.session.getBreakpointManager().getBreakpoint(e.getBreakpointId());
        if (bpt == null) {
            eventList.add(this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, 0, Messages.SDMEventManager_5, Messages.SDMEventManager_1)));
        } else {
            eventList.add(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newBreakpointInfo(this.session, eTasks, bpt), e.getThreadId(), 0, e.getDepth(), e.getChangedVars()));
        }
        this.fireEvents(eventList.toArray(new IPDIEvent[0]));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugBreakpointSetEvent(IProxyDebugBreakpointSetEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ArrayList<Object> eventList = new ArrayList<Object>();
        if (!(request instanceof IPDIBreakpointRequest) || !((IPDIBreakpointRequest)request).isAllowUpdate()) {
            IPDIBreakpoint bpt = this.session.getBreakpointManager().getBreakpoint(e.getBreakpointId());
            if (bpt == null) {
                eventList.add(this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, 0, Messages.SDMEventManager_2, Messages.SDMEventManager_1)));
            } else {
                eventList.add(this.session.getEventFactory().newCreatedEvent((IPDISessionObject)this.session.getEventFactory().newBreakpointInfo(this.session, eTasks, bpt)));
            }
        }
        this.fireEvents(eventList.toArray(new IPDIEvent[0]));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugDataEvent(IProxyDebugDataEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugErrorEvent(IProxyDebugErrorEvent e) {
        int actionType;
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        if (request != null) {
            request.error(e.getErrorMessage());
        }
        if ((actionType = this.session.getDebugger().getErrorAction(e.getErrorCode())) == 2) {
            this.session.getTaskManager().setPendingTasks(false, eTasks);
            this.session.getTaskManager().setTerminateTasks(true, eTasks);
        }
        this.fireEvent((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, actionType, Messages.SDMEventManager_4, e.getErrorMessage())));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugExitEvent(IProxyDebugExitEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ArrayList<IPDIEvent> eventList = new ArrayList<IPDIEvent>();
        IPDIExitInfo reason = this.session.getEventFactory().newExitInfo(this.session, eTasks, e.getExitStatus());
        this.checkTasksExited(eTasks, (IPDISessionObject)reason, eventList);
        this.fireEvents(eventList.toArray(new IPDIEvent[0]));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugInfoThreadsEvent(IProxyDebugInfoThreadsEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugMemoryInfoEvent(IProxyDebugMemoryInfoEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugOKEvent(IProxyDebugOKEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ArrayList<Object> eventList = new ArrayList<Object>();
        if (request != null) {
            if (request instanceof IPDIGoRequest) {
                this.session.getTaskManager().setSuspendTasks(false, eTasks);
                this.session.processRunningEvent(eTasks.copy());
                eventList.add(this.session.getEventFactory().newResumedEvent((IPDISessionObject)this.session, eTasks, 0));
            } else if (request instanceof IPDIStepRequest) {
                int details = request instanceof IPDIStepIntoRequest ? 2 : (request instanceof IPDIStepOverRequest ? 1 : (request instanceof IPDIStepFinishRequest ? 5 : (request instanceof IPDIStepIntoInstructionRequest ? 4 : (request instanceof IPDIStepOverInstructionRequest ? 3 : 0))));
                this.session.getTaskManager().setSuspendTasks(false, eTasks);
                this.session.processRunningEvent(eTasks.copy());
                eventList.add(this.session.getEventFactory().newResumedEvent((IPDISessionObject)this.session, eTasks, details));
            } else if (!(request instanceof IPDIEnableBreakpointRequest || request instanceof IPDIDisableBreakpointRequest || request instanceof IPDIConditionBreakpointRequest)) {
                if (request instanceof IPDIDeleteBreakpointRequest) {
                    if (((IPDIBreakpointRequest)request).isAllowUpdate()) {
                        IPDIBreakpoint bpt = ((IPDIDeleteBreakpointRequest)request).getBreakpoint();
                        if (bpt == null) {
                            eventList.add(this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, 0, Messages.SDMEventManager_0, Messages.SDMEventManager_1)));
                        } else {
                            eventList.add(this.session.getEventFactory().newDestroyedEvent((IPDISessionObject)this.session.getEventFactory().newBreakpointInfo(this.session, eTasks, bpt)));
                        }
                    }
                } else if (request instanceof IPDITerminateRequest) {
                    this.session.getTaskManager().setPendingTasks(false, eTasks);
                    this.session.getTaskManager().setTerminateTasks(true, eTasks);
                    eventList.add(this.session.getEventFactory().newDestroyedEvent((IPDISessionObject)this.session.getEventFactory().newExitInfo(this.session, eTasks, 1)));
                    if (this.session.getTaskManager().isAllTerminated(this.session.getTasks())) {
                        eventList.add(this.session.getEventFactory().newDisconnectedEvent((IPDISessionObject)this.session, this.session.getTasks()));
                    }
                } else if (request instanceof IPDIStartDebuggerRequest) {
                    eventList.add(this.session.getEventFactory().newConnectedEvent((IPDISessionObject)this.session, eTasks));
                } else if (!(request instanceof IPDISetCurrentStackFrameRequest) && !(request instanceof IPDIDeleteVariableRequest)) {
                    boolean cfr_ignored_0 = request instanceof IPDICommandRequest;
                }
            }
        }
        this.fireEvents(eventList.toArray(new IPDIEvent[0]));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugOutputEvent(IProxyDebugOutputEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        this.fireEvent((IPDIEvent)this.session.getEventFactory().newOutputEvent((IPDISessionObject)this.session, eTasks, e.getOutput()));
    }

    public void handleProxyDebugSetThreadSelectEvent(IProxyDebugSetThreadSelectEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugSignalEvent(IProxyDebugSignalEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ProxyDebugLocator loc = e.getFrame().getLocator();
        IPDILocator locator = PDILocationFactory.newLocator((String)loc.getFile(), (String)loc.getFunction(), (int)loc.getLineNumber(), (BigInteger)loc.getAddress());
        this.fireEvent(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newSignalInfo(this.session, eTasks, e.getSignalName(), e.getSignalMeaning(), null, locator), e.getThreadId(), e.getFrame().getLevel(), e.getDepth(), e.getChangedVars()));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugSignalExitEvent(IProxyDebugSignalExitEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ArrayList<IPDIEvent> eventList = new ArrayList<IPDIEvent>();
        IPDISignalInfo reason = this.session.getEventFactory().newSignalInfo(this.session, eTasks, e.getSignalName(), e.getSignalMeaning(), null, null);
        this.checkTasksExited(eTasks, (IPDISessionObject)reason, eventList);
        this.fireEvents(eventList.toArray(new IPDIEvent[0]));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugSignalsEvent(IProxyDebugSignalsEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugStackframeEvent(IProxyDebugStackframeEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugStackInfoDepthEvent(IProxyDebugStackInfoDepthEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugStepEvent(IProxyDebugStepEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ProxyDebugLocator loc = e.getFrame().getLocator();
        IPDILocator locator = PDILocationFactory.newLocator((String)loc.getFile(), (String)loc.getFunction(), (int)loc.getLineNumber(), (BigInteger)loc.getAddress());
        this.fireEvent(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newEndSteppingRangeInfo(this.session, eTasks, locator), e.getThreadId(), e.getFrame().getLevel(), e.getDepth(), e.getChangedVars()));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugSuspendEvent(IProxyDebugSuspendEvent e) {
        TaskSet eTasks = ProxyDebugClient.decodeTaskSet(e.getBitSet());
        IPDIEventRequest request = this.getCurrentRequest();
        ProxyDebugLocator loc = e.getFrame().getLocator();
        IPDILocator locator = PDILocationFactory.newLocator((String)loc.getFile(), (String)loc.getFunction(), (int)loc.getLineNumber(), (BigInteger)loc.getAddress());
        this.fireEvent(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newLocationReachedInfo(this.session, eTasks, locator), e.getThreadId(), e.getFrame().getLevel(), e.getDepth(), e.getChangedVars()));
        this.verifyEvent(request, (IProxyDebugEvent)e);
    }

    public void handleProxyDebugTypeEvent(IProxyDebugTypeEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    public void handleProxyDebugVarsEvent(IProxyDebugVarsEvent e) {
        this.verifyEvent(this.getCurrentRequest(), (IProxyDebugEvent)e);
    }

    private void checkTasksExited(TaskSet tasks, IPDISessionObject reason, List<IPDIEvent> eventList) {
        this.session.getTaskManager().setPendingTasks(false, tasks);
        this.session.getTaskManager().setTerminateTasks(true, tasks);
        eventList.add((IPDIEvent)this.session.getEventFactory().newDestroyedEvent(reason));
        if (this.session.getTaskManager().isAllTerminated(this.session.getTasks())) {
            try {
                this.session.exit();
                eventList.add((IPDIEvent)this.session.getEventFactory().newDisconnectedEvent((IPDISessionObject)this.session, this.session.getTasks()));
            }
            catch (PDIException ex) {
                eventList.add((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, ex.getTasks(), 2, Messages.SDMEventManager_3, ex.getMessage())));
            }
        }
    }

    private IPDIEvent createSuspendedEvent(IPDISessionObject reason, int thread_id, int level, int depth, String[] vars) {
        if (depth > 1) {
            this.session.getTaskManager().setCanStepReturnTasks(true, reason.getTasks());
        }
        this.session.getTaskManager().setSuspendTasks(true, reason.getTasks());
        this.session.processSupsendedEvent(reason.getTasks().copy(), thread_id, vars);
        return this.session.getEventFactory().newSuspendedEvent(reason, vars, thread_id, level, depth);
    }

    private void verifyEvent(IPDIEventRequest request, IProxyDebugEvent result) {
        TaskSet eTasks;
        if (request != null && request.completed(eTasks = ProxyDebugClient.decodeTaskSet(result.getBitSet()), (Object)result)) {
            request.done();
            this.notifyEventRequest(request);
        }
    }
}

