/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core.pdi.request;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignalDescriptor;
import org.eclipse.ptp.debug.core.pdi.request.AbstractListSignalsRequest;
import org.eclipse.ptp.debug.sdm.core.messages.Messages;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugSignal;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalsEvent;

public class SDMListSignalsRequest
extends AbstractListSignalsRequest {
    private IPDISession session;

    public SDMListSignalsRequest(IPDISession session, TaskSet tasks, String name) {
        super(tasks, name);
        this.session = session;
    }

    public IPDISignalDescriptor[] getSignals(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof ProxyDebugSignal[]) {
            ProxyDebugSignal[] proxySigs = (ProxyDebugSignal[])obj;
            IPDISignalDescriptor[] signals = new IPDISignalDescriptor[proxySigs.length];
            int i = 0;
            while (i < signals.length) {
                signals[i] = this.session.getModelFactory().newSignalDescriptor(proxySigs[i].getName(), proxySigs[i].isStop(), proxySigs[i].isPass(), proxySigs[i].isPrint(), proxySigs[i].getDescription());
                ++i;
            }
            return signals;
        }
        throw new PDIException(qTasks, Messages.SDMListSignalsRequest_0);
    }

    protected void storeResult(TaskSet rTasks, Object result) {
        if (result instanceof IProxyDebugSignalsEvent) {
            this.results.put(rTasks, ((IProxyDebugSignalsEvent)result).getSignals());
        } else {
            this.storeUnknownResult(rTasks, result);
        }
    }
}

