/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.actions.AnalysisDropdownHandler;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseHandler;
import org.eclipse.ptp.pldt.common.messages.Messages;
import org.eclipse.ptp.pldt.common.util.AnalysisUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RunAnalyseHandlerBase
extends RunAnalyseHandler {
    protected static boolean traceOn = false;
    private static final int INDENT_INCR = 2;
    protected boolean forceEcho = false;
    protected IWorkbenchWindow window;
    protected boolean cancelledByUser = false;
    protected int cumulativeArtifacts = 0;
    protected String name;
    protected ArtifactMarkingVisitor visitor;
    protected String markerID;
    private boolean err = false;
    protected Shell shell;
    private static final String SPACES = "                                                                                            ";

    public RunAnalyseHandlerBase(String name, ArtifactMarkingVisitor visitor, String markerID) {
        this.name = name;
        this.visitor = visitor;
        this.markerID = markerID;
        traceOn = CommonPlugin.getTraceOn();
        if (traceOn) {
            System.out.println("RunAnalyseBase.ctor: traceOn=" + traceOn);
        }
    }

    public ScanReturn analyse(IProgressMonitor monitor, ITranslationUnit tu, List<String> includes) {
        if (traceOn) {
            this.println("RunAnalyseBase.analyse()...");
        }
        String errMsg = null;
        monitor.subTask(Messages.RunAnalyseHandlerBase_42);
        String rawPath = tu.getLocationURI().toString();
        if (traceOn) {
            this.println("RunAnalyseBase:              file = " + rawPath);
        }
        monitor.subTask(String.valueOf(Messages.RunAnalyseHandlerBase_on) + rawPath);
        ScanReturn scanReturn = this.doArtifactAnalysis(tu, includes);
        monitor.worked(1);
        if (traceOn) {
            this.println("Artifact analysis complete...");
        }
        int numArtifacts = scanReturn.getArtifactList().size();
        this.cumulativeArtifacts += numArtifacts;
        if (traceOn) {
            System.out.println("Artifacts found for " + tu.getResource().getProjectRelativePath() + ": " + numArtifacts);
        }
        if (traceOn) {
            System.out.println("   Total # found: " + this.cumulativeArtifacts);
        }
        if (scanReturn == null) {
            System.out.println("ScanReturn result is NULL.  No results for " + tu.getResource().getProjectRelativePath());
            errMsg = "Error: No results were returned from analysis of " + tu.getResource().getProjectRelativePath();
            MessageDialog.openError((Shell)this.shell, (String)"Error in Analysis", (String)errMsg);
        } else if (traceOn) {
            System.out.println("RunAnalyzeBase: ScanReturn received for " + tu.getElementName());
        }
        if (scanReturn != null) {
            boolean wasError = scanReturn.wasError();
            if (traceOn) {
                System.out.println("error occurred =" + wasError);
            }
            if (wasError) {
                System.out.println("RunAnalyseBase.analyse...Error...");
            }
        }
        return scanReturn;
    }

    public boolean areIncludePathsNeeded() {
        return true;
    }

    public void dispose() {
    }

    public abstract ScanReturn doArtifactAnalysis(ITranslationUnit var1, List<String> var2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (traceOn) {
            System.out.println("RunAnalyseHandlerBase.execute()...");
        }
        this.getSelection(event);
        if (traceOn) {
            System.out.println("selection: " + this.selection);
        }
        this.run();
        AnalysisDropdownHandler.setLastHandledAnalysis(this, this.selection);
        return null;
    }

    public String getPrefacedName(Object obj) {
        String preface = "";
        if (obj instanceof IFolder) {
            preface = Messages.RunAnalyseHandlerBase_60;
        } else if (obj instanceof IProject) {
            preface = Messages.RunAnalyseHandlerBase_61;
        } else if (obj instanceof IFile) {
            preface = Messages.RunAnalyseHandlerBase_62;
        }
        String res = String.valueOf(preface) + ((IResource)obj).getName();
        return res;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run() {
        if (traceOn) {
            System.out.println("RunAnalyseHandlerBase.run()...");
        }
        this.cancelledByUser = false;
        this.err = false;
        this.cumulativeArtifacts = 0;
        this.readPreferences();
        if (this.selection == null || this.selection.isEmpty()) {
            MessageDialog.openWarning(null, (String)Messages.RunAnalyseHandlerBase_no_files_selected, (String)Messages.RunAnalyseHandlerBase_please_select);
            return;
        }
        final List<String> includes = this.getIncludePath();
        if (this.areIncludePathsNeeded() && includes.isEmpty()) {
            MessageDialog.openWarning((Shell)this.shell, (String)(String.valueOf(this.name) + Messages.RunAnalyseHandlerBase_include_paths_not_found), (String)(String.valueOf(Messages.RunAnalyseHandlerBase_please_first_specify) + this.name + Messages.RunAnalyseHandlerBase_incl_paths_in_pref_page));
        } else {
            WorkspaceModifyOperation wmo = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    RunAnalyseHandlerBase.this.err = RunAnalyseHandlerBase.this.runResources(monitor, 0, includes);
                }
            };
            ProgressMonitorDialog pmdialog = new ProgressMonitorDialog(this.shell);
            try {
                pmdialog.run(true, true, (IRunnableWithProgress)wmo);
            }
            catch (InvocationTargetException e) {
                this.err = true;
                Throwable cause = e.getCause();
                System.out.println("Error running analysis: ITE: " + e.getMessage());
                System.out.println("  cause: " + cause + " - " + cause.getMessage());
                cause.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                this.cancelledByUser = true;
            }
        }
        if (traceOn) {
            System.out.println("RunAnalyseBase: retd from run iterator, err=" + this.err);
        }
        String artsFound = "\nNumber of " + this.name + " Artifacts found: " + this.cumulativeArtifacts;
        if (this.cancelledByUser) {
            MessageDialog.openInformation(null, (String)Messages.RunAnalyseHandlerBase_partial_analysis_complete, (String)(String.valueOf(Messages.RunAnalyseHandlerBase_15) + artsFound));
        } else {
            String msg = Messages.RunAnalyseHandlerBase_cancelled_by_user;
            if (!this.err) {
                String key = "showAnalysisConfirmation";
                IPreferenceStore pf = CommonPlugin.getDefault().getPreferenceStore();
                boolean showDialog = pf.getBoolean("showAnalysisConfirmation");
                if (showDialog) {
                    String title = Messages.RunAnalyseHandlerBase_analysis_complete;
                    StringBuffer sMsg = new StringBuffer(String.valueOf(this.cumulativeArtifacts) + " " + this.name + Messages.RunAnalyseHandlerBase_artifacts_found);
                    if (this.cumulativeArtifacts == 0) {
                        sMsg.append(Messages.RunAnalyseHandlerBase_notfound_0).append(this.name).append(Messages.RunAnalyseHandlerBase_notfound_1);
                        sMsg.append(this.name).append(Messages.RunAnalyseHandlerBase_notfound_2);
                        sMsg.append(Messages.RunAnalyseHandlerBase_notfound_3);
                    }
                    String togMsg = Messages.RunAnalyseHandlerBase_dont_show_this_again;
                    MessageDialogWithToggle.openInformation((Shell)this.shell, (String)title, (String)sMsg.toString(), (String)togMsg, (boolean)false, (IPreferenceStore)pf, (String)key);
                    this.showStatusMessage(sMsg.toString(), "RunAnalyseBase.run()");
                }
                this.activateProblemsView();
                this.activateArtifactView();
            } else {
                this.showStatusMessage(msg, "RunAnalyseBase.run() error");
                msg = Messages.RunAnalyseHandlerBase_27;
                MessageDialog.openError(null, (String)Messages.RunAnalyseHandlerBase_28, (String)(String.valueOf(msg) + artsFound));
            }
        }
    }

    public boolean runResource(IProgressMonitor monitor, ICElement ce, int indent, List<String> includes) throws InterruptedException {
        indent += 2;
        boolean foundError = false;
        if (!monitor.isCanceled()) {
            if (ce instanceof ITranslationUnit) {
                IResource res = ce.getResource();
                if (res instanceof IFile) {
                    boolean cpp;
                    IFile file = (IFile)res;
                    String filename = file.getName();
                    if (this.validForAnalysis(filename, cpp = this.isCPPproject(ce))) {
                        if (traceOn) {
                            this.println(String.valueOf(this.getSpaces(indent)) + "file: " + filename);
                        }
                        ScanReturn results = this.analyse(monitor, (ITranslationUnit)ce, includes);
                        boolean bl = foundError = foundError || results == null || results.wasError();
                        if (foundError) {
                            int stopHere = 0;
                            System.out.println("found error on " + file.getName() + " " + stopHere);
                        }
                        if (traceOn) {
                            this.println("******** RunAnalyseBase, analysis complete; ScanReturn=" + results);
                        }
                        if (results != null) {
                            this.processResults(results, (IResource)file);
                        }
                    } else if (traceOn) {
                        this.println(String.valueOf(this.getSpaces(indent)) + "---omit: not valid file: " + filename);
                    }
                    return foundError;
                }
            } else if (ce instanceof ICContainer) {
                ICContainer container = (ICContainer)ce;
                try {
                    ICElement[] mems = container.getChildren();
                    int i = 0;
                    while (i < mems.length) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        boolean err = this.runResource(monitor, mems[i], indent, includes);
                        foundError = foundError || err;
                        ++i;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else if (ce instanceof ICProject) {
                ICProject proj = (ICProject)ce;
                try {
                    ICElement[] mems = proj.getChildren();
                    int i = 0;
                    while (i < mems.length) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        boolean err = this.runResource(monitor, mems[i], indent, includes);
                        foundError = foundError || err;
                        ++i;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else {
            String name = "";
            name = ce.getElementName();
            System.out.println("Cancelled by User, aborting analysis on subsequent files... " + name);
            throw new InterruptedException();
        }
        return foundError;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (traceOn) {
            System.out.println("RunAnalyseBase.setActivePart()...");
        }
        this.shell = targetPart.getSite().getShell();
    }

    void println(String str) {
        System.out.println(str);
    }

    protected abstract void activateArtifactView();

    protected void activateProblemsView() {
    }

    protected IASTTranslationUnit getAST(ITranslationUnit tu) {
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(tu.getCProject());
            IASTTranslationUnit ast = tu.getAST(index, 6);
            if (traceOn) {
                System.out.println("    getAST(index,AST_SKIP_ALL_HEADERS)");
            }
            return ast;
        }
        catch (Exception e) {
            String msg = "RunAnalyseHandlerBase.getAST(): Error getting AST (from index) for project " + tu.getCProject() + " " + e.getMessage();
            CommonPlugin.log(4, msg);
            return null;
        }
    }

    protected abstract List<String> getIncludePath();

    protected boolean isCPPproject(ICElement ce) {
        IProject p = ce.getCProject().getProject();
        try {
            IProjectNature nature = p.getNature("org.eclipse.cdt.core.ccnature");
            if (nature != null) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void processResults(ScanReturn results, IResource resource) {
        List<Artifact> artifacts = results.getArtifactList();
        this.visitor.visitFile(resource, artifacts);
    }

    protected void readPreferences() {
        Preferences pref = CommonPlugin.getDefault().getPluginPreferences();
        this.forceEcho = pref.getBoolean("forceEcho");
    }

    protected boolean runResources(IProgressMonitor monitor, int indent, List<String> includes) throws InterruptedException {
        boolean foundError = false;
        int count = this.countFilesSelected();
        monitor.beginTask(Messages.RunAnalyseHandlerBase_29, count);
        if (traceOn) {
            System.out.println("RAHB.runResources(): using selection: " + this.selection);
        }
        IStructuredSelection lastSel = AnalysisDropdownHandler.getInstance().getLastSelection();
        Iterator iter = lastSel.iterator();
        while (iter.hasNext()) {
            ICElement ce;
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            Object obj = iter.next();
            if (!(obj instanceof IAdaptable) || (ce = (ICElement)((IAdaptable)obj).getAdapter(ICElement.class)) == null) continue;
            boolean err = this.runResource(monitor, ce, indent, includes);
            if (!traceOn) continue;
            System.out.println("Error (err=" + err + ")running analysis on " + ce.getResource().getName());
        }
        monitor.done();
        return foundError;
    }

    protected boolean validForAnalysis(String filename, boolean isCPP) {
        return AnalysisUtil.validForAnalysis(filename, isCPP);
    }

    private String getSpaces(int indent) {
        String indentSpace = "";
        try {
            indentSpace = SPACES.substring(0, indent);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.println("RunAnalyseBase: Nesting level " + indent + " exceeds print indent; INCR at each level is " + 2);
        }
        return indentSpace;
    }

    private void showStatusMessage(String message, String debugMessage) {
        IWorkbenchWindow ww = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = ww.getActivePage();
        IViewReference[] viewRefs = page.getViewReferences();
        int j = 0;
        while (j < viewRefs.length) {
            IViewReference reference = viewRefs[j];
            IViewPart vp = reference.getView(false);
            if (vp != null) {
                vp.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
            }
            ++j;
        }
    }
}

