/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.ui.extension;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.remotetools.environment.extension.INode;
import org.eclipse.ptp.remotetools.environment.ui.extension.IDoubleClickHandler;

public class DoubleClickHandlerManager {
    private static final String EXT_HANDLER_ID = "org.eclipse.ptp.remotetools.environment.ui.doubleClickHandler";
    private List<IDoubleClickHandler> handlers;

    public DoubleClickHandlerManager() {
        this.processDoubleClickHandlers();
    }

    public boolean doubleClickExecute(INode node) {
        for (IDoubleClickHandler handler : this.handlers) {
            if (!handler.handle(node)) continue;
            return true;
        }
        return false;
    }

    private void processDoubleClickHandlers() {
        this.handlers = new ArrayList<IDoubleClickHandler>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXT_HANDLER_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        try {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                IConfigurationElement element = elements[0];
                if ("doubleClickHandler".equals(element.getName())) {
                    this.handlers.add((IDoubleClickHandler)element.createExecutableExtension("class"));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

