/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.ui.views;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEnvironmentEventListener;
import org.eclipse.ptp.remotetools.environment.core.ITargetEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.extension.INode;
import org.eclipse.ptp.remotetools.environment.ui.UIEnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.ui.messages.Messages;
import org.eclipse.ptp.remotetools.environment.wizard.EnvironmentWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsEnvironmentView
extends ViewPart
implements ISelectionChangedListener,
ITargetEventListener {
    private TreeViewer viewer;
    private Action startAction;
    private Action stopAction;
    private Action resumeAction;
    private Action pauseAction;
    private Action createAction;
    private Action editAction;
    private Action removeAction;
    private Action doubleClickAction;
    private List<Action> workloadControllers = new ArrayList<Action>();
    private final String ENVIRONMENT_CONTROL_NAME = Messages.RemoteToolsEnvironmentView_0;
    private final String ENVIRONMENT_CONTROL_STATUS = Messages.RemoteToolsEnvironmentView_1;
    private final String[] columnNames = new String[]{this.ENVIRONMENT_CONTROL_NAME, this.ENVIRONMENT_CONTROL_STATUS};
    private final TargetEnvironmentManager model = EnvironmentPlugin.getDefault().getTargetsManager();
    private ITargetElement currentElement = null;
    private final ITargetEnvironmentEventListener eventListener = new ITargetEnvironmentEventListener(){

        public void elementAdded(TargetElement element) {
            RemoteToolsEnvironmentView.this.refresh();
        }

        public void elementRemoved(ITargetElement element) {
            RemoteToolsEnvironmentView.this.refresh();
        }
    };

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.defineTable(this.viewer);
        this.viewer.setColumnProperties(this.columnNames);
        this.viewer.setInput((Object)this.model.getTypeElements().toArray());
        this.viewer.refresh();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.workloadControllers = this.getWorkloadControllers();
        for (Action controller : this.workloadControllers) {
            if (!(controller instanceof ISelectionChangedListener)) continue;
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)controller);
        }
        this.model.addModelEventListener((ITargetEventListener)this);
        this.model.addModelChangedListener(this.eventListener);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        parent.pack();
        this.viewer.reveal((Object)this.viewer.getTree().getItem(0));
    }

    private void defineTable(TreeViewer viewer) {
        Tree t = viewer.getTree();
        t.setHeaderVisible(true);
        TreeColumn column = new TreeColumn(t, 16384, 0);
        column.setText(this.ENVIRONMENT_CONTROL_NAME);
        column.setWidth(650);
        column = new TreeColumn(t, 131072, 1);
        column.setText(this.ENVIRONMENT_CONTROL_STATUS);
        column.setWidth(50);
        viewer.expandAll();
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                        RemoteToolsEnvironmentView.this.createAction.setEnabled(false);
                        ITargetElement temp = (ITargetElement)obj;
                        if (temp.getStatus() == 1) {
                            RemoteToolsEnvironmentView.this.editAction.setEnabled(true);
                            RemoteToolsEnvironmentView.this.removeAction.setEnabled(true);
                        } else {
                            RemoteToolsEnvironmentView.this.editAction.setEnabled(false);
                            RemoteToolsEnvironmentView.this.removeAction.setEnabled(false);
                        }
                        RemoteToolsEnvironmentView.this.fillContextMenu(manager);
                    } else if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                        RemoteToolsEnvironmentView.this.createAction.setEnabled(true);
                        RemoteToolsEnvironmentView.this.editAction.setEnabled(false);
                        RemoteToolsEnvironmentView.this.removeAction.setEnabled(false);
                        RemoteToolsEnvironmentView.this.fillContextMenu(manager);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.createAction);
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.removeAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        for (Action controller : this.workloadControllers) {
            manager.add((IAction)controller);
        }
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.stopAction);
        manager.add((IAction)this.resumeAction);
        manager.add((IAction)this.pauseAction);
    }

    private List<Action> getWorkloadControllers() {
        ArrayList<Action> actions = new ArrayList<Action>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.remotetools.environment.ui.workloadController");
        IExtension[] extensions = extensionPoint.getExtensions();
        try {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if ("controllerDelegate".equals(element.getName())) {
                        actions.add((Action)element.createExecutableExtension("class"));
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actions.isEmpty() ? Collections.EMPTY_LIST : actions;
    }

    public void refresh() {
        Display display = this.viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (!RemoteToolsEnvironmentView.this.viewer.getControl().isDisposed()) {
                    RemoteToolsEnvironmentView.this.viewer.refresh(true);
                }
            }
        });
    }

    private void makeActions() {
        URL url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/run_exc.gif");
        ImageDescriptor imageRun = ImageDescriptor.createFromURL((URL)url);
        url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/terminatedlaunch.gif");
        ImageDescriptor imageStop = ImageDescriptor.createFromURL((URL)url);
        url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/suspend.gif");
        ImageDescriptor imageSuspend = ImageDescriptor.createFromURL((URL)url);
        url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/resume.gif");
        ImageDescriptor imageResume = ImageDescriptor.createFromURL((URL)url);
        IWorkbenchPartSite site = this.getSite();
        final Shell shell = site.getShell();
        final IJobChangeListener ijob = new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                RemoteToolsEnvironmentView.this.refresh();
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        };
        this.startAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job(Messages.RemoteToolsEnvironmentView_17){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.startAction.setEnabled(false);
                            IStatus status = null;
                            ITargetElement element = null;
                            ITargetControl control = null;
                            try {
                                element = (ITargetElement)obj;
                                control = element.getControl();
                                if (control.create(monitor)) {
                                    status = Status.OK_STATUS;
                                }
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.startAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage(Messages.RemoteToolsEnvironmentView_18, RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.startAction.setText(Messages.RemoteToolsEnvironmentView_19);
        this.startAction.setToolTipText(Messages.RemoteToolsEnvironmentView_20);
        this.startAction.setImageDescriptor(imageRun);
        this.stopAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job(Messages.RemoteToolsEnvironmentView_21){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.stopAction.setEnabled(false);
                            IStatus status = null;
                            try {
                                ((ITargetElement)obj).getControl().kill();
                                status = Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.stopAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage(Messages.RemoteToolsEnvironmentView_22, RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.stopAction.setText(Messages.RemoteToolsEnvironmentView_23);
        this.stopAction.setToolTipText(Messages.RemoteToolsEnvironmentView_24);
        this.stopAction.setImageDescriptor(imageStop);
        this.resumeAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job(Messages.RemoteToolsEnvironmentView_25){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.resumeAction.setEnabled(false);
                            IStatus status = null;
                            try {
                                if (((ITargetElement)obj).getControl().resume(monitor)) {
                                    status = Status.OK_STATUS;
                                    RemoteToolsEnvironmentView.this.pauseAction.setEnabled(true);
                                }
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.resumeAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage(Messages.RemoteToolsEnvironmentView_26, RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.resumeAction.setText(Messages.RemoteToolsEnvironmentView_27);
        this.resumeAction.setToolTipText(Messages.RemoteToolsEnvironmentView_28);
        this.resumeAction.setImageDescriptor(imageResume);
        this.pauseAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job(Messages.RemoteToolsEnvironmentView_29){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.pauseAction.setEnabled(false);
                            IStatus status = null;
                            try {
                                if (((ITargetElement)obj).getControl().stop(monitor)) {
                                    status = Status.OK_STATUS;
                                    RemoteToolsEnvironmentView.this.resumeAction.setEnabled(true);
                                }
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.pauseAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage(Messages.RemoteToolsEnvironmentView_30, RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.pauseAction.setText(Messages.RemoteToolsEnvironmentView_31);
        this.pauseAction.setToolTipText(Messages.RemoteToolsEnvironmentView_32);
        this.pauseAction.setImageDescriptor(imageSuspend);
        this.createAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                    EnvironmentWizard wizard = new EnvironmentWizard((TargetTypeElement)obj);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.create();
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
            }
        };
        this.createAction.setText(Messages.RemoteToolsEnvironmentView_33);
        this.createAction.setToolTipText(Messages.RemoteToolsEnvironmentView_34);
        this.editAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                    EnvironmentWizard wizard = new EnvironmentWizard((ITargetElement)obj);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.create();
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    RemoteToolsEnvironmentView.this.refresh();
                }
            }
        };
        this.editAction.setText(Messages.RemoteToolsEnvironmentView_35);
        this.editAction.setToolTipText(Messages.RemoteToolsEnvironmentView_36);
        this.removeAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                    ITargetElement confElement = (ITargetElement)obj;
                    if (confElement.getStatus() != 0) {
                        if (RemoteToolsEnvironmentView.this.showConfirm(Messages.RemoteToolsEnvironmentView_37, RemoteToolsEnvironmentView.this.viewer)) {
                            confElement.getType().removeElement(confElement);
                        }
                    } else {
                        RemoteToolsEnvironmentView.this.showMessage(Messages.RemoteToolsEnvironmentView_38, RemoteToolsEnvironmentView.this.viewer);
                    }
                }
            }
        };
        this.removeAction.setText(Messages.RemoteToolsEnvironmentView_39);
        this.removeAction.setToolTipText(Messages.RemoteToolsEnvironmentView_40);
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                    if (RemoteToolsEnvironmentView.this.viewer.getExpandedState(obj)) {
                        RemoteToolsEnvironmentView.this.viewer.setExpandedState(obj, false);
                    } else {
                        RemoteToolsEnvironmentView.this.viewer.setExpandedState(obj, true);
                    }
                }
                if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                    ITargetElement ele = (ITargetElement)obj;
                    try {
                        ITargetControl control = ele.getControl();
                        if (control.query() == 1) {
                            RemoteToolsEnvironmentView.this.editAction.run();
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                if (INode.class.isAssignableFrom(obj.getClass())) {
                    INode node = (INode)obj;
                    UIEnvironmentPlugin.getDefault().getDoubleClickHandlerManager().doubleClickExecute(node);
                }
            }
        };
        this.stopAction.setEnabled(false);
        this.resumeAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.createAction.setEnabled(false);
        this.editAction.setEnabled(false);
        this.removeAction.setEnabled(false);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RemoteToolsEnvironmentView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message, TreeViewer viewer) {
        MessageDialog.openInformation((Shell)viewer.getControl().getShell(), (String)Messages.RemoteToolsEnvironmentView_41, (String)message);
    }

    private boolean showConfirm(String message, TreeViewer viewer) {
        return MessageDialog.openConfirm((Shell)viewer.getControl().getShell(), (String)Messages.RemoteToolsEnvironmentView_42, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj != null) {
            if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                this.currentElement = (ITargetElement)obj;
                switch (this.currentElement.getStatus()) {
                    case 0: {
                        this.targetStarted(this.currentElement);
                        break;
                    }
                    case 1: {
                        this.targetStopped(this.currentElement);
                        break;
                    }
                    case 2: {
                        this.targetResumed(this.currentElement);
                        break;
                    }
                    case 3: {
                        this.targetPaused(this.currentElement);
                    }
                }
            } else {
                this.currentElement = null;
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                this.resumeAction.setEnabled(false);
                this.pauseAction.setEnabled(false);
            }
        }
    }

    public void targetStarted(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.resumeAction.setEnabled(true);
            this.pauseAction.setEnabled(false);
            this.editAction.setEnabled(false);
            this.removeAction.setEnabled(false);
        }
        this.refresh();
    }

    public void targetStopped(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(true);
            this.stopAction.setEnabled(false);
            this.resumeAction.setEnabled(false);
            this.pauseAction.setEnabled(false);
            this.editAction.setEnabled(true);
            this.removeAction.setEnabled(true);
        }
        this.refresh();
    }

    public void targetPaused(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.resumeAction.setEnabled(true);
            this.pauseAction.setEnabled(false);
        }
        this.refresh();
    }

    public void targetResumed(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.resumeAction.setEnabled(false);
            this.pauseAction.setEnabled(true);
        }
        this.refresh();
    }

    public void handleStateChangeEvent(int event, ITargetElement from) {
        switch (event) {
            case 0: {
                this.targetStarted(from);
                break;
            }
            case 1: {
                this.targetStopped(from);
                break;
            }
            case 2: {
                this.targetResumed(from);
                break;
            }
            case 3: {
                this.targetPaused(from);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.model.removeModelEventListener((ITargetEventListener)this);
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private class ViewContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY = new Object[0];

        private ViewContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof TargetTypeElement) {
                return ((TargetTypeElement)element).getElements().toArray();
            }
            if (element instanceof ITargetElement) {
                return EnvironmentPlugin.getDefault().getChildrenProviderManager().getChildren((ITargetElement)element);
            }
            if (element instanceof INode) {
                return ((INode)element).getChildren();
            }
            return this.EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof ITargetElement) {
                return ((ITargetElement)element).getType();
            }
            if (element instanceof INode) {
                return ((INode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object element) {
            if (element instanceof Object[]) {
                return (Object[])element;
            }
            return this.getChildren(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image viewIcon;

        private ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String result = "";
            block0 : switch (index) {
                case 0: {
                    if (obj instanceof INode) {
                        result = ((INode)obj).getDisplayText();
                        break;
                    }
                    result = obj.toString();
                    break;
                }
                case 1: {
                    if (!TargetElement.class.isAssignableFrom(obj.getClass())) break;
                    int status = ((ITargetElement)obj).getStatus();
                    switch (status) {
                        case 0: {
                            result = Messages.RemoteToolsEnvironmentView_3;
                            break block0;
                        }
                        case 1: {
                            result = Messages.RemoteToolsEnvironmentView_4;
                            break block0;
                        }
                        case 2: {
                            result = Messages.RemoteToolsEnvironmentView_5;
                            break block0;
                        }
                        case 3: {
                            result = Messages.RemoteToolsEnvironmentView_6;
                        }
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                if (obj instanceof INode) {
                    return ((INode)obj).getIcon();
                }
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                URL url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/connect_create.gif");
                ImageDescriptor imageMonitorDescriptor = ImageDescriptor.createFromURL((URL)url);
                this.viewIcon = imageMonitorDescriptor.createImage();
            } else if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                URL url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/monitor_obj.gif");
                ImageDescriptor imageMonitorDescriptor = ImageDescriptor.createFromURL((URL)url);
                this.viewIcon = imageMonitorDescriptor.createImage();
            }
            return this.viewIcon;
        }

        public void dispose() {
            super.dispose();
            if (this.viewIcon != null) {
                this.viewIcon.dispose();
                this.viewIcon = null;
            }
        }
    }
}

