/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.messages.Messages;
import org.eclipse.ptp.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.widgets.Shell;

public class RemoteUIServicesUtils {
    public static URI browse(Shell shell, URI current, RemoteServicesDelegate delegate, boolean remote, boolean readOnly, boolean dir) throws URISyntaxException {
        int type;
        IRemoteUIServices uIServices = null;
        IRemoteUIFileManager uiFileManager = null;
        IRemoteConnection conn = null;
        IRemoteFileManager manager = null;
        URI home = null;
        String path = null;
        int n = type = readOnly ? 2 : 4;
        if (!remote) {
            uIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(delegate.getLocalServices());
            uiFileManager = uIServices.getUIFileManager();
            manager = delegate.getLocalFileManager();
            conn = delegate.getLocalConnection();
            home = delegate.getLocalHome();
        } else {
            uIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(delegate.getRemoteServices());
            uiFileManager = uIServices.getUIFileManager();
            manager = delegate.getRemoteFileManager();
            conn = delegate.getRemoteConnection();
            home = delegate.getRemoteHome();
        }
        path = current == null ? home.getPath() : current.getPath();
        String title = dir ? Messages.RemoteResourceBrowser_directoryTitle : Messages.RemoteResourceBrowser_fileTitle;
        try {
            uiFileManager.setConnection(conn);
            uiFileManager.showConnections(remote);
            path = dir ? uiFileManager.browseDirectory(shell, title, path, type) : uiFileManager.browseFile(shell, title, path, type);
        }
        catch (Throwable t) {
            PTPRemoteUIPlugin.log(t);
        }
        if (path == null) {
            return null;
        }
        return manager.toURI(path);
    }

    public static void setConnectionHints(RemoteConnectionWidget connectionWidget, IRemoteConnection connection) throws URISyntaxException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("CONNECTION_ADDRESS_HINT", connection.getAddress());
        result.put("LOGIN_USERNAME_HINT", connection.getUsername());
        result.put("CONNECTION_PORT_HINT", String.valueOf(connection.getPort()));
        String[] hints = new String[result.size()];
        String[] defaults = new String[hints.length];
        int i = 0;
        Iterator iterator = result.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            hints[i] = s = (String)iterator.next();
            defaults[i++] = (String)result.get(s);
        }
        connectionWidget.setHints(hints, defaults);
    }
}

