/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.selinst.popup.actions;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.etfw.tau.selinst.Selector;
import org.eclipse.ptp.etfw.tau.selinst.messages.Messages;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SelectiveInstrument
implements IObjectActionDelegate {
    public static final int INCLUDE = 0;
    public static final int EXCLUDE = 1;
    protected static final String[] instTypes = new String[]{"loops", "io", "memory", "dynamic timer", "static timer", "dynamic phase", "static phase"};
    protected static final String[] instIDs = new String[]{"org.eclipse.ptp.etfw.tau.selinst.instloops", "org.eclipse.ptp.etfw.tau.selinst.instio", "org.eclipse.ptp.etfw.tau.selinst.instmemory", "org.eclipse.ptp.etfw.tau.selinst.dyntime", "org.eclipse.ptp.etfw.tau.selinst.stattime", "org.eclipse.ptp.etfw.tau.selinst.dynphase", "org.eclipse.ptp.etfw.tau.selinst.statphase"};
    IStructuredSelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selection == null) {
            System.out.println(Messages.SelectiveInstrument_NoSelection);
            return;
        }
        ICElement cbit = null;
        Iterator selit = this.selection.iterator();
        HashSet<String> selfiles = new HashSet<String>();
        HashSet<String> selrouts = new HashSet<String>();
        String selType = "";
        int incex = -1;
        int idDex = -1;
        String selID = action.getId();
        if (selID.equals("org.eclipse.ptp.etfw.tau.selinst.excludeselect")) {
            incex = 1;
        } else if (selID.equals("org.eclipse.ptp.etfw.tau.selinst.includeselect")) {
            incex = 0;
        } else {
            idDex = 0;
            while (idDex < instIDs.length) {
                if (selID.equals(instIDs[idDex])) {
                    selType = instTypes[idDex];
                    break;
                }
                ++idDex;
            }
        }
        if (!selType.equals("") || incex >= 0) {
            while (selit.hasNext()) {
                String fortclass;
                cbit = (ICElement)selit.next();
                int type = cbit.getElementType();
                if (type == 74) {
                    String fullsig = Selector.getFullSigniture((IFunctionDeclaration)cbit);
                    if (incex >= 0) {
                        selrouts.add(fullsig);
                        continue;
                    }
                    if (selType.equals("")) continue;
                    if (idDex <= 2) {
                        selrouts.add(String.valueOf(selType) + " file=\"" + cbit.getUnderlyingResource().getName() + "\" routine=\"" + fullsig + "\"");
                        continue;
                    }
                    selrouts.add(String.valueOf(selType) + " routine=\"" + fullsig + "\"");
                    continue;
                }
                if (type == 60) {
                    if (incex >= 0) {
                        selfiles.add(cbit.getElementName());
                        continue;
                    }
                    if (selType.equals("")) continue;
                    if (idDex <= 2) {
                        selfiles.add(String.valueOf(selType) + " file=\"" + cbit.getElementName() + "\" routine=\"#\"");
                        continue;
                    }
                    selfiles.add(String.valueOf(selType) + " routine=\"#\"");
                    continue;
                }
                if (type != -1 || !(fortclass = cbit.getClass().getName()).equals("org.eclipse.photran.internal.core.model.FortranElement$Subroutine") && !fortclass.equals("org.eclipse.photran.internal.core.model.FortranElement$MainProgram")) continue;
                if (incex >= 0) {
                    selrouts.add("#" + cbit.getElementName().toUpperCase());
                    continue;
                }
                if (selType.equals("")) continue;
                if (idDex <= 2) {
                    selrouts.add(String.valueOf(selType) + " file=\"" + cbit.getUnderlyingResource().getName() + "\" routine=\"" + "#" + cbit.getElementName().toUpperCase() + "\"");
                    continue;
                }
                selrouts.add(String.valueOf(selType) + " routine=\"" + "#" + cbit.getElementName().toUpperCase() + "\"");
            }
        }
        if (selfiles.size() > 0 || selrouts.size() > 0) {
            Selector selinst = new Selector(cbit.getCProject().getResource().getLocation().toOSString());
            if (selfiles.size() > 0) {
                if (incex == 0) {
                    selinst.includeFile(selfiles);
                } else if (incex == 1) {
                    selinst.excludeFile(selfiles);
                } else if (!selType.equals("")) {
                    selinst.addInst(selfiles);
                }
            }
            if (selrouts.size() > 0) {
                if (incex == 0) {
                    selinst.includeRout(selrouts);
                } else if (incex == 1) {
                    selinst.excludeRout(selrouts);
                } else if (!selType.equals("")) {
                    selinst.addInst(selrouts);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        } else {
            this.selection = null;
            System.out.println(Messages.SelectiveInstrument_InvalidSelection);
        }
    }
}

