/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CalledByResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.index.DummyName;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexFileLocation;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;
import org.eclipse.ptp.internal.rdt.core.miners.URICreatorManager;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.RemoteCProjectFactory;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCHQueries {
    public static final String LOG_TAG = "RemoteCHQueries";

    public static CalledByResult findCalledBy(ICElement callee, String path, IIndex project_index, IIndex serach_scope_index, String scheme, String hostName, CalledByResult result, DataStore _dataStore, IIndexLocationConverter converter) throws CoreException, URISyntaxException, InterruptedException {
        ICProject project = callee.getCProject();
        IIndexBinding calleeBinding = null;
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for project_index", (DataStore)_dataStore);
        project_index.acquireReadLock();
        try {
            calleeBinding = IndexQueries.elementToBinding(project_index, callee, path);
        }
        finally {
            UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Releasing read lock for project_index", (DataStore)_dataStore);
            project_index.releaseReadLock();
        }
        if (calleeBinding != null) {
            UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for serach_scope_index", (DataStore)_dataStore);
            serach_scope_index.acquireReadLock();
            try {
                RemoteCHQueries.findCalledBy1(serach_scope_index, (IBinding)calleeBinding, true, project, scheme, hostName, result, _dataStore, converter);
                if (calleeBinding instanceof ICPPMethod) {
                    ICPPMethod[] overriddenBindings;
                    ICPPMethod[] iCPPMethodArray = overriddenBindings = ClassTypeHelper.findOverridden((ICPPMethod)((ICPPMethod)calleeBinding));
                    int n = overriddenBindings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPMethod overriddenBinding = iCPPMethodArray[n2];
                        RemoteCHQueries.findCalledBy1(serach_scope_index, (IBinding)overriddenBinding, false, project, scheme, hostName, result, _dataStore, converter);
                        ++n2;
                    }
                }
            }
            finally {
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Releasing read lock for serach_scope_index", (DataStore)_dataStore);
                serach_scope_index.releaseReadLock();
            }
        }
        return result;
    }

    private static void findCalledBy1(IIndex index, IBinding callee, boolean includeOrdinaryCalls, ICProject project, String scheme, String hostName, CalledByResult result, DataStore _dataStore, IIndexLocationConverter converter) throws CoreException, URISyntaxException {
        RemoteCHQueries.findCalledBy2(index, callee, includeOrdinaryCalls, project, scheme, hostName, result, _dataStore, converter);
        List<? extends IBinding> specializations = IndexQueries.findSpecializations(callee);
        for (IBinding iBinding : specializations) {
            RemoteCHQueries.findCalledBy2(index, iBinding, includeOrdinaryCalls, project, scheme, hostName, result, _dataStore, converter);
        }
    }

    private static void findCalledBy2(IIndex index, IBinding callee, boolean includeOrdinaryCalls, ICProject project, String scheme, String hostName, CalledByResult result, DataStore _dataStore, IIndexLocationConverter converter) throws CoreException, URISyntaxException {
        IIndexName[] names;
        IIndexName[] iIndexNameArray = names = index.findNames(callee, 12);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement elem;
            IIndexName caller;
            IIndexName rname = iIndexNameArray[n2];
            if ((includeOrdinaryCalls || rname.couldBePolymorphicMethodCall()) && (caller = rname.getEnclosingDefinition()) != null && (elem = IndexQueries.getCElementForName(project, index, caller, converter, (ICProjectFactory)new RemoteCProjectFactory())) != null) {
                IIndexFileLocation indexLocation = RemoteCHQueries.createLocation(scheme, hostName, rname.getFile().getLocation(), _dataStore);
                DummyName reference = new DummyName(rname, rname.getFileLocation(), indexLocation);
                result.add(elem, reference);
            }
            ++n2;
        }
    }

    public static CallsToResult findCalls(ICElement caller, String path, IIndex project_index, IIndex workspace_scope_index, String scheme, String hostName, DataStore _dataStore, IIndexLocationConverter converter) throws CoreException, InterruptedException, URISyntaxException {
        CallsToResult result = new CallsToResult();
        IIndexName callerName = null;
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for project_index", (DataStore)_dataStore);
        project_index.acquireReadLock();
        try {
            callerName = IndexQueries.remoteElementToName(project_index, caller, path);
        }
        finally {
            UniversalServerUtilities.logDebugMessage((String)"CDTMiner", (String)"Releasing read lock for project_index", (DataStore)_dataStore);
            project_index.releaseReadLock();
        }
        if (callerName != null) {
            UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for workspace_scope_index", (DataStore)_dataStore);
            workspace_scope_index.acquireReadLock();
            try {
                IIndexName[] refs = callerName.getEnclosedNames();
                ICProject project = caller.getCProject();
                RemoteCProjectFactory projectFactory = new RemoteCProjectFactory();
                IIndexName[] iIndexNameArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexName name = iIndexNameArray[n2];
                    IIndexBinding binding = workspace_scope_index.findBinding((IName)name);
                    if (RemoteCHQueries.isRelevantForCallHierarchy((IBinding)binding)) {
                        do {
                            ICElement[] defs = null;
                            if (binding instanceof ICPPMethod) {
                                defs = RemoteCHQueries.findOverriders(workspace_scope_index, (ICPPMethod)binding, converter, project, projectFactory);
                            }
                            if (defs == null) {
                                defs = IndexQueries.findRepresentative(workspace_scope_index, (IBinding)binding, converter, project, projectFactory);
                            }
                            if (defs == null || defs.length <= 0) continue;
                            IIndexFileLocation indexLocation = RemoteCHQueries.createLocation(scheme, hostName, name.getFile().getLocation(), _dataStore);
                            DummyName reference = new DummyName(name, name.getFileLocation(), indexLocation);
                            UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Found a callee: " + defs[0].getElementName() + "\n"), (DataStore)_dataStore);
                            result.add(defs, reference);
                            break;
                        } while (binding instanceof ICPPSpecialization && (binding = ((ICPPSpecialization)binding).getSpecializedBinding()) != null);
                    }
                    ++n2;
                }
            }
            finally {
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Releasing read lock for workspace_scope_index", (DataStore)_dataStore);
                workspace_scope_index.releaseReadLock();
            }
        }
        return result;
    }

    private static ICElement[] findOverriders(IIndex index, ICPPMethod binding, IIndexLocationConverter converter, ICProject project, ICProjectFactory projectFactory) throws CoreException {
        ICPPMethod[] virtualOverriders = ClassTypeHelper.findOverriders((IIndex)index, (ICPPMethod)binding);
        if (virtualOverriders.length > 0) {
            ArrayList<ICElement> list = new ArrayList<ICElement>();
            list.addAll(Arrays.asList(IndexQueries.findRepresentative(index, (IBinding)binding, converter, project, projectFactory)));
            ICPPMethod[] iCPPMethodArray = virtualOverriders;
            int n = virtualOverriders.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod overrider = iCPPMethodArray[n2];
                list.addAll(Arrays.asList(IndexQueries.findRepresentative(index, (IBinding)overrider, converter, project, projectFactory)));
                ++n2;
            }
            return list.toArray(new ICElement[list.size()]);
        }
        return null;
    }

    public static boolean isRelevantForCallHierarchy(IBinding binding) {
        return binding instanceof ICExternalBinding || binding instanceof IEnumerator || binding instanceof IFunction || binding instanceof IVariable;
    }

    private static IIndexFileLocation createLocation(String scheme, String hostName, IIndexFileLocation location, DataStore _dataStore) throws URISyntaxException {
        URI uri = location.getURI();
        String path = uri.getPath();
        URI newURI = null;
        if (scheme == null || scheme.equals("")) {
            scheme = ScopeManager.getInstance().getSchemeForFile(path);
        }
        newURI = URICreatorManager.getDefault(_dataStore).createURI(scheme, hostName, path);
        return new RemoteIndexFileLocation(null, newURI);
    }

    public static Map<String, ICElement[]> handleGetOverriders(IIndex project_index, ICElement subject, String path, DataStore _dataStore, IIndexLocationConverter converter) throws InterruptedException, CoreException {
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock", (DataStore)_dataStore);
        project_index.acquireReadLock();
        HashMap<String, ICElement[]> result = new HashMap<String, ICElement[]>();
        try {
            RemoteCProjectFactory projectFactory;
            ICProject project;
            ICElement[] defs;
            IIndexBinding methodBinding;
            IIndexName methodName;
            if (subject instanceof IMethod && (methodName = IndexQueries.remoteElementToName(project_index, subject, path)) != null && (methodBinding = project_index.findBinding((IName)methodName)) instanceof ICPPMethod && (defs = RemoteCHQueries.findOverriders(project_index, (ICPPMethod)methodBinding, converter, project = subject.getCProject(), projectFactory = new RemoteCProjectFactory())) != null && defs.length > 0) {
                result.put(String.valueOf(methodBinding.getLinkage().getLinkageID()), defs);
            }
        }
        finally {
            project_index.releaseReadLock();
        }
        return result;
    }
}

