/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.IOException;
import org.eclipse.cdt.internal.core.indexer.StandaloneFastIndexer;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.Serializer;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerProgress;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

public class RemoteIndexProgressMonitor
implements IProgressMonitor {
    private String fTaskName;
    private String fSubTaskName;
    private int fTotalWork;
    private int fCurrentWorked;
    private boolean fIsCanceled;
    private DataElement fStatus;
    private StandaloneFastIndexer fIndexer;
    private DataStore _dataStore;
    private static final String CLASS_NAME = "CDTMiner-RemoteIndexProgressMonitor";

    public RemoteIndexProgressMonitor(StandaloneFastIndexer indexer, DataElement status, DataStore _dataStore) {
        this.fStatus = status;
        this.fIndexer = indexer;
        this._dataStore = _dataStore;
    }

    public void beginTask(String name, int totalWork) {
        this.fTaskName = name;
        this.fTotalWork = totalWork;
        this.serializeProgress("Starting task " + name);
    }

    public void done() {
        this.serializeProgress("Done task " + this.fTaskName);
    }

    public void internalWorked(double work) {
        this.fCurrentWorked = (int)((double)this.fCurrentWorked + work);
        this.printProgress();
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public void setCanceled(boolean value) {
        this.fIsCanceled = value;
        if (value) {
            this.serializeProgress("Task " + this.fTaskName + " has been cancelled");
        }
    }

    public void setTaskName(String name) {
        this.fTaskName = name;
    }

    public void subTask(String name) {
        this.fSubTaskName = name;
        this.printProgress();
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    private void serializeProgress(String attribute) {
        try {
            IndexerProgress info = this.fIndexer.getProgressInformation();
            RemoteIndexerProgress remoteInfo = new RemoteIndexerProgress(info);
            remoteInfo.status = attribute;
            String sInfo = Serializer.serialize(remoteInfo);
            this.fStatus.setAttribute(2, attribute);
            this.fStatus.getDataStore().createObject(this.fStatus, "Type.Indexer.ProgressInfo", sInfo);
            this.fStatus.getDataStore().refresh(this.fStatus);
        }
        catch (IOException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
        }
    }

    private void printProgress() {
        this.serializeProgress("Working... Task: " + this.fTaskName + " SubTask: " + this.fSubTaskName + " Progress: " + this.fCurrentWorked + " of " + this.fTotalWork);
    }
}

