/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IInputOrder;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;

public class InputOrder
implements IInputOrder {
    private IInputType fParent;
    private String fPath;
    private String fOrder;
    private Boolean fExcluded;
    private boolean fIsExtensionInputOrder = false;
    private boolean fIsDirty = false;
    private boolean fResolved = true;
    private boolean fRebuildState;

    public InputOrder(IInputType parent, IManagedConfigElement element) {
        this.fParent = parent;
        this.fIsExtensionInputOrder = true;
        this.fResolved = false;
        this.loadFromManifest(element);
    }

    public InputOrder(InputType parent, boolean isExtensionElement) {
        this.fParent = parent;
        this.fIsExtensionInputOrder = isExtensionElement;
        if (!isExtensionElement) {
            this.setDirty(true);
        }
    }

    public InputOrder(IInputType parent, ICStorageElement element) {
        this.fParent = parent;
        this.fIsExtensionInputOrder = false;
        this.loadFromProject(element);
    }

    public InputOrder(IInputType parent, InputOrder inputOrder) {
        this.fParent = parent;
        this.fIsExtensionInputOrder = false;
        if (inputOrder.fPath != null) {
            this.fPath = new String(inputOrder.fPath);
        }
        if (inputOrder.fOrder != null) {
            this.fOrder = new String(inputOrder.fOrder);
        }
        if (inputOrder.fExcluded != null) {
            this.fExcluded = new Boolean(inputOrder.fExcluded);
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        this.fPath = SafeStringInterner.safeIntern((String)element.getAttribute("path"));
        this.fOrder = SafeStringInterner.safeIntern((String)element.getAttribute("order"));
        String isEx = element.getAttribute("excluded");
        if (isEx != null) {
            this.fExcluded = new Boolean("true".equals(isEx));
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        String isEx;
        if (element.getAttribute("path") != null) {
            this.fPath = SafeStringInterner.safeIntern((String)element.getAttribute("path"));
        }
        if (element.getAttribute("order") != null) {
            this.fOrder = SafeStringInterner.safeIntern((String)element.getAttribute("order"));
        }
        if (element.getAttribute("excluded") != null && (isEx = element.getAttribute("excluded")) != null) {
            this.fExcluded = new Boolean("true".equals(isEx));
        }
    }

    public void serialize(ICStorageElement element) {
        if (this.fPath != null) {
            element.setAttribute("path", this.fPath);
        }
        if (this.fOrder != null) {
            element.setAttribute("order", this.fOrder);
        }
        if (this.fExcluded != null) {
            element.setAttribute("excluded", this.fExcluded.toString());
        }
        this.fIsDirty = false;
    }

    public IInputType getParent() {
        return this.fParent;
    }

    public String getPath() {
        return this.fPath;
    }

    public void setPath(String newPath) {
        if (this.fPath == null && newPath == null) {
            return;
        }
        if (this.fPath == null || newPath == null || !this.fPath.equals(newPath)) {
            this.fPath = newPath;
            this.fIsDirty = true;
            this.setRebuildState(true);
        }
    }

    public String getOrder() {
        return this.fOrder;
    }

    public void setOrder(String newOrder) {
        if (this.fOrder == null && newOrder == null) {
            return;
        }
        if (this.fOrder == null || newOrder == null || !this.fOrder.equals(newOrder)) {
            this.fOrder = newOrder;
            this.fIsDirty = true;
            this.setRebuildState(true);
        }
    }

    public boolean getExcluded() {
        return this.fExcluded;
    }

    public void setExcluded(boolean b) {
        if (this.fExcluded == null || b != this.fExcluded) {
            this.fExcluded = new Boolean(b);
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public boolean isExtensionElement() {
        return this.fIsExtensionInputOrder;
    }

    public boolean isDirty() {
        if (this.fIsExtensionInputOrder) {
            return false;
        }
        return this.fIsDirty;
    }

    public void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.fResolved) {
            this.fResolved = true;
        }
    }

    public boolean needsRebuild() {
        return this.fRebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.fRebuildState = rebuild;
    }
}

