/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.DbgTcmUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectTypeBasedStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PathComparator;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcModificationUtil {
    private static void processFolderInfoChildren(FolderInfo foInfo, PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, IToolChain rtc, Map<IRealBuildObjectAssociation, Set<IPath>> tcMap, Map<IRealBuildObjectAssociation, Set<IPath>> toolMap, boolean addSkipInfo) {
        IResourceInfo[] rcInfos = foInfo.getDirectChildResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            IResourceInfo rc = rcInfos[i];
            if (rc instanceof ResourceConfiguration) {
                ResourceConfiguration fi = (ResourceConfiguration)rc;
                IPath p = fi.getPath();
                ITool[] tools = fi.getTools();
                TcModificationUtil.processTools(storage.getMap(8, true), p, tools, toolMap, addSkipInfo);
            } else {
                FolderInfo childFoInfo = (FolderInfo)rc;
                IToolChain tc = foInfo.getToolChain();
                if ((tc = ManagedBuildManager.getRealToolChain(tc)) == rtc) {
                    if (addSkipInfo && tcMap != null) {
                        Set<IPath> set = TcModificationUtil.getPathTreeSet(tcMap, (ToolChain)tc);
                        set.add(childFoInfo.getPath());
                    }
                    TcModificationUtil.processFolderInfoChildren(childFoInfo, storage, tc, tcMap, toolMap, addSkipInfo);
                } else {
                    TcModificationUtil.processFolderInfo(storage, childFoInfo, null, false);
                }
            }
            ++i;
        }
    }

    public static PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> createChildObjectsRealToolToPathSet(FolderInfo foInfo, Map<IRealBuildObjectAssociation, Set<IPath>> toolChainMap, Map<IRealBuildObjectAssociation, Set<IPath>> toolsMap, boolean addSkipPaths) {
        PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = new PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>>();
        IToolChain tc = foInfo.getToolChain();
        IToolChain rTc = ManagedBuildManager.getRealToolChain(tc);
        ITool[] tools = rTc.getTools();
        toolsMap.clear();
        if (toolChainMap != null) {
            toolChainMap.clear();
        }
        int i = 0;
        while (i < tools.length) {
            toolsMap.put((Tool)ManagedBuildManager.getRealTool(tools[i]), null);
            ++i;
        }
        TcModificationUtil.processFolderInfoChildren(foInfo, storage, rTc, toolChainMap, toolsMap, addSkipPaths);
        return storage;
    }

    public static PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> createParentObjectsRealToolToPathSet(FolderInfo foInfo) {
        PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = new PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>>();
        IConfiguration cfg = foInfo.getParent();
        FolderInfo rf = (FolderInfo)cfg.getRootFolderInfo();
        IPath p = rf.getPath();
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(cfg.getBuilder());
        Map<IRealBuildObjectAssociation, TreeSet<IPath>> map = storage.getMap(4, true);
        TreeSet<IPath> pathSet = new TreeSet<IPath>(PathComparator.INSTANCE);
        pathSet.add(p);
        map.put((Builder)realBuilder, pathSet);
        IRealBuildObjectAssociation realCfg = ((Configuration)cfg).getRealBuildObject();
        map = storage.getMap(32, true);
        pathSet = new TreeSet<IPath>(PathComparator.INSTANCE);
        pathSet.add(p);
        map.put(realCfg, pathSet);
        if (!foInfo.isRoot()) {
            HashSet<IResourceInfo> allRcInfos = new HashSet<IResourceInfo>(Arrays.asList(cfg.getResourceInfos()));
            allRcInfos.removeAll(foInfo.getChildResourceInfoList(true));
            for (IResourceInfo rc : allRcInfos) {
                if (rc instanceof ResourceConfiguration) {
                    TcModificationUtil.processFileInfo(storage, (ResourceConfiguration)rc, null, false);
                    continue;
                }
                TcModificationUtil.processFolderInfo(storage, (FolderInfo)rc, null, false);
            }
        }
        return storage;
    }

    public static PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> cloneRealToolToPathSet(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage) {
        PerTypeMapStorage cloneStorage;
        storage = cloneStorage = (PerTypeMapStorage)storage.clone();
        int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
        int i = 0;
        while (i < types.length) {
            Map map = storage.getMap(types[i], false);
            if (map != null) {
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    Set clone = (Set)((TreeSet)entry.getValue()).clone();
                    entry.setValue(clone);
                }
            }
            ++i;
        }
        return storage;
    }

    public static PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> createRealToolToPathSet(IConfiguration cfg, PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> skipMapStorage, boolean addSkipPaths) {
        PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = new PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>>();
        FolderInfo rf = (FolderInfo)cfg.getRootFolderInfo();
        IPath p = rf.getPath();
        Map<IRealBuildObjectAssociation, Set<IPath>> skipMap = skipMapStorage != null ? skipMapStorage.getMap(4, false) : null;
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(cfg.getBuilder());
        if (skipMap != null && skipMap.containsKey(realBuilder)) {
            if (addSkipPaths) {
                Set<IPath> set = TcModificationUtil.getPathTreeSet(skipMap, (Builder)realBuilder);
                set.add(p);
            }
        } else {
            Map<Builder, TreeSet<IPath>> map = storage.getMap(4, true);
            TreeSet<IPath> pathSet = new TreeSet<IPath>(PathComparator.INSTANCE);
            pathSet.add(p);
            map.put((Builder)realBuilder, pathSet);
        }
        skipMap = skipMapStorage != null ? skipMapStorage.getMap(32, false) : null;
        IRealBuildObjectAssociation realCfg = ((Configuration)cfg).getRealBuildObject();
        if (skipMap != null && skipMap.containsKey(realCfg)) {
            if (addSkipPaths) {
                Set<IPath> set = TcModificationUtil.getPathTreeSet(skipMap, realCfg);
                set.add(p);
            }
        } else {
            Map<IRealBuildObjectAssociation, TreeSet<IPath>> map = storage.getMap(32, true);
            TreeSet<IPath> pathSet = new TreeSet<IPath>(PathComparator.INSTANCE);
            pathSet.add(p);
            map.put(realCfg, pathSet);
        }
        TcModificationUtil.processFolderInfo(storage, rf, skipMapStorage, addSkipPaths);
        IResourceInfo[] rcInfos = rf.getChildResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            IResourceInfo rc = rcInfos[i];
            if (rc instanceof ResourceConfiguration) {
                TcModificationUtil.processFileInfo(storage, (ResourceConfiguration)rc, skipMapStorage, addSkipPaths);
            } else {
                TcModificationUtil.processFolderInfo(storage, (FolderInfo)rc, skipMapStorage, addSkipPaths);
            }
            ++i;
        }
        return storage;
    }

    public static TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> createResultingChangesMap(TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> resultingMap, TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> initialMap) {
        Set set;
        PerTypeSetStorage storage;
        PerTypeSetStorage initStorage;
        TreeMap clone;
        int[] types = new int[]{1, 4, 2};
        TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> result = new TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>>(PathComparator.INSTANCE);
        initialMap = clone = (TreeMap)initialMap.clone();
        for (Map.Entry<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> entry : resultingMap.entrySet()) {
            IPath oPath = entry.getKey();
            PerTypeSetStorage<IRealBuildObjectAssociation> resStorage = entry.getValue();
            initStorage = (PerTypeSetStorage)initialMap.remove(oPath);
            if (initStorage == null || initStorage.isEmpty(true)) {
                PerTypeSetStorage clone2;
                storage = resStorage != null && !resStorage.isEmpty(true) ? (clone2 = (PerTypeSetStorage)resStorage.clone()) : new PerTypeSetStorage();
            } else if (resStorage == null || resStorage.isEmpty(true)) {
                storage = new PerTypeSetStorage();
                int i = 0;
                while (i < types.length) {
                    set = initStorage.getSet(types[i], false);
                    if (set != null && set.size() != 0) {
                        storage.getSet(types[i], true);
                    }
                    ++i;
                }
            } else {
                Set<IRealBuildObjectAssociation> bInitSet = null;
                LinkedHashSet<IRealBuildObjectAssociation> tInitSet = null;
                storage = new PerTypeSetStorage();
                Set<IRealBuildObjectAssociation> tcInitSet = initStorage.getSet(1, false);
                Set<IRealBuildObjectAssociation> resSet = resStorage.getSet(1, false);
                Set<IRealBuildObjectAssociation> setToStore = TcModificationUtil.compareSets(resSet, tcInitSet);
                if (setToStore != null) {
                    storage.getSet(1, true).addAll(setToStore);
                    ToolChain tc = setToStore.size() != 0 ? (ToolChain)setToStore.iterator().next() : null;
                    IPath path = oPath;
                    if (tc != null) {
                        tInitSet = new LinkedHashSet();
                        TcModificationUtil.getRealObjectsSet((Tool[])tc.getTools(), tInitSet);
                        if (path.segmentCount() == 0) {
                            bInitSet = new LinkedHashSet<IRealBuildObjectAssociation>();
                            IBuilder builder = tc.getBuilder();
                            if (builder != null) {
                                bInitSet.add((Builder)ManagedBuildManager.getRealBuilder(builder));
                            }
                        }
                    } else {
                        tcInitSet = Collections.emptySet();
                        if (path.segmentCount() == 0) {
                            bInitSet = Collections.emptySet();
                        }
                    }
                }
                if (bInitSet == null) {
                    bInitSet = initStorage.getSet(4, false);
                }
                if ((setToStore = TcModificationUtil.compareSets(resSet = resStorage.getSet(4, false), bInitSet)) != null) {
                    storage.getSet(4, true).addAll(setToStore);
                }
                if (tInitSet == null) {
                    tInitSet = initStorage.getSet(2, false);
                }
                if ((setToStore = TcModificationUtil.compareSets(resSet = resStorage.getSet(2, false), tInitSet)) != null) {
                    storage.getSet(2, true).addAll(setToStore);
                }
            }
            if (storage.isEmpty(false)) continue;
            result.put(oPath, storage);
        }
        if (initialMap.size() != 0) {
            Set entrySet = initialMap.entrySet();
            for (Map.Entry entry : entrySet) {
                IPath oPath = (IPath)entry.getKey();
                initStorage = (PerTypeSetStorage)entry.getValue();
                if (initStorage.isEmpty(true)) continue;
                storage = new PerTypeSetStorage();
                int i = 0;
                while (i < types.length) {
                    set = initStorage.getSet(types[i], false);
                    if (set != null && set.size() != 0) {
                        storage.getSet(types[i], true).addAll(set);
                    }
                    ++i;
                }
                if (storage.isEmpty(false)) continue;
                result.put(oPath, storage);
            }
        }
        return result;
    }

    private static Set<IRealBuildObjectAssociation> compareSets(Set<IRealBuildObjectAssociation> resSet, Set<IRealBuildObjectAssociation> initSet) {
        Set<Object> result = null;
        if (initSet == null || initSet.isEmpty()) {
            if (resSet != null && !resSet.isEmpty()) {
                result = resSet;
            }
        } else if (resSet == null || resSet.isEmpty()) {
            result = Collections.emptySet();
        } else if (!initSet.equals(resSet)) {
            result = resSet;
        }
        return result;
    }

    private static void processFolderInfo(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, FolderInfo info, PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> skipMapStorage, boolean addSkipPaths) {
        Map<IRealBuildObjectAssociation, Set<IPath>> skipMap;
        IPath p = info.getPath();
        IToolChain rtc = ManagedBuildManager.getRealToolChain(info.getToolChain());
        Map<IRealBuildObjectAssociation, Set<IPath>> map = skipMap = skipMapStorage != null ? skipMapStorage.getMap(1, false) : null;
        if (skipMap != null && skipMap.containsKey(rtc)) {
            if (addSkipPaths) {
                Set<IPath> set = TcModificationUtil.getPathTreeSet(skipMap, (ToolChain)rtc);
                set.add(p);
            }
        } else {
            Map<IRealBuildObjectAssociation, Set<IPath>> map2 = storage.getMap(1, true);
            Set<IPath> set = TcModificationUtil.getPathTreeSet(map2, (ToolChain)rtc);
            set.add(p);
        }
        ITool[] tools = info.getTools();
        TcModificationUtil.processTools(storage, p, tools, skipMapStorage, addSkipPaths);
    }

    public static Set<IRealBuildObjectAssociation> getRealObjectsSet(IRealBuildObjectAssociation[] objs, Set<IRealBuildObjectAssociation> set) {
        if (set == null) {
            set = new LinkedHashSet<IRealBuildObjectAssociation>();
        }
        int i = 0;
        while (i < objs.length) {
            set.add(objs[i].getRealBuildObject());
            ++i;
        }
        return set;
    }

    public static Map<? extends IRealBuildObjectAssociation, ? extends IRealBuildObjectAssociation> getRealToObjectsMap(IRealBuildObjectAssociation[] objs, Map<IRealBuildObjectAssociation, IRealBuildObjectAssociation> map) {
        if (map == null) {
            map = new LinkedHashMap<IRealBuildObjectAssociation, IRealBuildObjectAssociation>();
        }
        int i = 0;
        while (i < objs.length) {
            map.put(objs[i].getRealBuildObject(), objs[i]);
            ++i;
        }
        return map;
    }

    private static void processFileInfo(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, ResourceConfiguration info, PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> skipMapStorage, boolean addSkipPaths) {
        IPath p = info.getPath();
        ITool[] tools = info.getTools();
        TcModificationUtil.processTools(storage, p, tools, skipMapStorage, addSkipPaths);
    }

    private static void processTools(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, IPath path, ITool[] tools, PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> skipMapStorage, boolean addSkipPaths) {
        Map<IRealBuildObjectAssociation, Set<IPath>> map = storage.getMap(2, true);
        Map<IRealBuildObjectAssociation, Set<IPath>> skipMap = skipMapStorage != null ? skipMapStorage.getMap(2, false) : null;
        TcModificationUtil.processTools(map, path, tools, skipMap, addSkipPaths);
    }

    private static void processTools(Map<IRealBuildObjectAssociation, Set<IPath>> storageMap, IPath path, ITool[] tools, Map<IRealBuildObjectAssociation, Set<IPath>> skipMap, boolean addSkipPaths) {
        int i = 0;
        while (i < tools.length) {
            Set<IPath> set;
            ITool rt = ManagedBuildManager.getRealTool(tools[i]);
            if (skipMap != null && skipMap.containsKey(rt)) {
                if (addSkipPaths) {
                    set = TcModificationUtil.getPathTreeSet(skipMap, (Tool)rt);
                    set.add(path);
                }
            } else {
                set = TcModificationUtil.getPathTreeSet(storageMap, (Tool)rt);
                set.add(path);
            }
            ++i;
        }
    }

    public static Set<IPath> getPathTreeSet(Map<IRealBuildObjectAssociation, Set<IPath>> map, IRealBuildObjectAssociation bo) {
        Set<IPath> set = map.get(bo);
        if (set == null) {
            set = new TreeSet<IPath>(PathComparator.INSTANCE);
            map.put(bo, set);
        }
        return set;
    }

    public static <K, V> List<V> getArrayList(Map<K, List<V>> map, K obj) {
        List<V> list = map.get(obj);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(obj, list);
        }
        return list;
    }

    public static Set<IPath> removeBuilderInfo(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, IBuilder builder) {
        return storage.getMap(4, true).remove(builder);
    }

    public static void restoreBuilderInfo(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, IBuilder builder, Set<IPath> obj) {
        storage.getMap(4, true).put((Builder)builder, obj);
    }

    public static <T extends IRealBuildObjectAssociation> void removePaths(Map<T, Set<IPath>> map, T bo, Set<IPath> paths) {
        Set<IPath> objPaths = map.get(bo);
        if (objPaths == null) {
            return;
        }
        objPaths.removeAll(paths);
        if (objPaths.size() == 0) {
            map.remove(bo);
        }
    }

    public static <T extends IRealBuildObjectAssociation> void addPaths(Map<T, Set<IPath>> map, T bo, Set<IPath> paths) {
        if (paths.size() == 0) {
            return;
        }
        Set<IPath> objPaths = map.get(bo);
        if (objPaths == null) {
            objPaths = new TreeSet<IPath>(PathComparator.INSTANCE);
            map.put(bo, objPaths);
        }
        objPaths.addAll(paths);
    }

    public static <T extends IRealBuildObjectAssociation> void addPath(Map<T, Set<IPath>> map, T bo, IPath path) {
        Set<IPath> objPaths = map.get(bo);
        if (objPaths == null) {
            objPaths = new TreeSet<IPath>(PathComparator.INSTANCE);
            map.put(bo, objPaths);
        }
        objPaths.add(path);
    }

    public static void applyBuilder(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, IPath path, IBuilder builder) {
        Map<IRealBuildObjectAssociation, Set<IPath>> bMap = storage.getMap(4, true);
        bMap.clear();
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(builder);
        Set<IPath> set = TcModificationUtil.getPathTreeSet(bMap, (Builder)realBuilder);
        set.add(path);
    }

    public static TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> createPathMap(IConfiguration cfg) {
        PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = TcModificationUtil.createRealToolToPathSet(cfg, null, false);
        return TcModificationUtil.createPathMap(storage);
    }

    public static TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> createPathMap(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage) {
        int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
        TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> result = new TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>>(PathComparator.INSTANCE);
        int i = 0;
        while (i < types.length) {
            int type = types[i];
            Map<IRealBuildObjectAssociation, Set<IPath>> map = storage.getMap(type, false);
            if (map != null) {
                Set<Map.Entry<IRealBuildObjectAssociation, Set<IPath>>> entrySet = map.entrySet();
                for (Map.Entry<IRealBuildObjectAssociation, Set<IPath>> entry : entrySet) {
                    IRealBuildObjectAssociation pathKey = entry.getKey();
                    Set<IPath> pathSet = entry.getValue();
                    for (IPath path : pathSet) {
                        PerTypeSetStorage<IRealBuildObjectAssociation> oset = result.get(path);
                        if (oset == null) {
                            oset = new PerTypeSetStorage();
                            result.put(path, oset);
                        }
                        Set<IRealBuildObjectAssociation> set = oset.getSet(type, true);
                        set.add(pathKey);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static SortedSet<IPath> getDirectChildUsagePaths(PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage, IPath path, IRealBuildObjectAssociation obj, SortedSet<IPath> inclusionPaths) {
        Map<IRealBuildObjectAssociation, Set<IPath>> objMap = storage.getMap(obj.getType(), false);
        SortedSet objPaths = (SortedSet)objMap.get(obj);
        if (DbgTcmUtil.DEBUG && !objPaths.contains(path)) {
            DbgTcmUtil.fail();
        }
        SortedSet<IPath> objChildPaths = PathComparator.getChildPathSet(objPaths, path, false, true);
        if (inclusionPaths != null) {
            objChildPaths.retainAll(inclusionPaths);
        }
        Iterator<Map.Entry<IRealBuildObjectAssociation, Set<IPath>>> iter = objMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<IRealBuildObjectAssociation, Set<IPath>> entry = iter.next();
            IRealBuildObjectAssociation cur = entry.getKey();
            if (obj == cur) continue;
            SortedSet<IPath> curPaths = (SortedSet<IPath>)entry.getValue();
            curPaths = PathComparator.getChildPathSet(curPaths, path, false, false);
            for (IPath childPath : objChildPaths) {
                SortedSet<IPath> sub = curPaths.tailSet(childPath);
                if (sub.size() == 0) continue;
                iter.remove();
            }
        }
        objChildPaths.add(path);
        return objChildPaths;
    }

    public static boolean containCommonEntries(Set<String> set, String[] objs) {
        int i = 0;
        while (i < objs.length) {
            if (set.contains(objs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IRealBuildObjectAssociation[] getRealObjects(int type) {
        switch (type) {
            case 2: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getRealTools();
            }
            case 1: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getRealToolChains();
            }
            case 4: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getRealBuilders();
            }
            case 32: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionConfigurations();
            }
        }
        throw new IllegalArgumentException();
    }

    public static IRealBuildObjectAssociation[] getExtensionObjects(int type) {
        switch (type) {
            case 2: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionTools();
            }
            case 1: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionToolChains();
            }
            case 4: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionBuilders();
            }
            case 32: {
                return (IRealBuildObjectAssociation[])ManagedBuildManager.getExtensionConfigurations();
            }
        }
        throw new IllegalArgumentException();
    }

    public static IRealBuildObjectAssociation getObjectById(int type, String id) {
        switch (type) {
            case 2: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionTool(id));
            }
            case 1: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionToolChain(id));
            }
            case 4: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionBuilder(id));
            }
            case 32: {
                return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionConfiguration(id));
            }
        }
        throw new IllegalArgumentException();
    }
}

