/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.model.IPLocationSet;
import org.eclipse.ptp.debug.internal.ui.PDebugImage;
import org.eclipse.ptp.debug.internal.ui.views.locations.PLocationView;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ptp.debug.ui.views.ParallelDebugView;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class CreateLocationSetAction
extends Action {
    public static final String ID = "org.eclipse.ptp.debug.ui.CreateLocationSetAction";
    public static final String name = Messages.CreateLocationSetAction_0;
    protected PLocationView view;

    public CreateLocationSetAction(PLocationView view) {
        this.view = view;
        this.setText(name);
        this.setImageDescriptor(PDebugImage.getDescriptor("var_add_normal.gif"));
    }

    public void run() {
        if (this.view == null || this.view.getViewer() == null || !(this.view.getViewer().getInput() instanceof IPSession)) {
            this.setEnabled(false);
            return;
        }
        IPSession session = (IPSession)this.view.getViewer().getInput();
        if (session == null || !session.isReady()) {
            this.setEnabled(false);
            return;
        }
        if (!(this.view.getViewer().getSelection() instanceof IStructuredSelection)) {
            this.setEnabled(false);
            return;
        }
        ParallelDebugView parallelDebugView = null;
        try {
            IWorkbenchPage page = this.view.getViewSite().getPage();
            IViewPart part = page.showView(IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG);
            if (part instanceof ParallelDebugView) {
                parallelDebugView = (ParallelDebugView)part;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (PartInitException partInitException) {}
        if (parallelDebugView == null) {
            this.setEnabled(false);
            return;
        }
        String setID = null;
        IStructuredSelection selection = (IStructuredSelection)this.view.getViewer().getSelection();
        IPLocationSet[] locations = selection.toList().toArray(new IPLocationSet[0]);
        IElementHandler setManager = parallelDebugView.getCurrentElementHandler();
        IPLocationSet[] iPLocationSetArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            int[] tasks;
            IPLocationSet locationSet = iPLocationSetArray[n2];
            IElementSet rootSet = setManager.getSetRoot();
            ArrayList<IElement> elementsMatchingTasks = new ArrayList<IElement>();
            int[] nArray = tasks = locationSet.getTasks().toArray();
            int n3 = tasks.length;
            int n4 = 0;
            while (n4 < n3) {
                int taskID = nArray[n4];
                IElement element = rootSet.getElementByName(Integer.toString(taskID));
                elementsMatchingTasks.add(element);
                ++n4;
            }
            String name = String.valueOf(locationSet.getFunction()) + ":" + locationSet.getFile() + ":" + locationSet.getLineNumber();
            if (setManager.getElementByID(name) instanceof IElementSet) {
                parallelDebugView.getUIManager().removeSet(name, setManager);
            }
            setID = parallelDebugView.getUIManager().createSet(elementsMatchingTasks.toArray(new IElement[0]), name, name, setManager);
            ++n2;
        }
        if (setID != null) {
            parallelDebugView.selectSet((IElementSet)setManager.getElementByID(setID));
        }
        parallelDebugView.refresh(false);
    }
}

