/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.internal.ui.views.AbstractCTableCellEditor;
import org.eclipse.ptp.debug.internal.ui.views.ICTableCellResizeListener;
import org.eclipse.ptp.debug.internal.ui.views.ICTableCellSelectionListener;
import org.eclipse.ptp.debug.internal.ui.views.ICTableModel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

public class CTable
extends Canvas {
    protected GC m_GC;
    protected Display m_Display;
    protected List<Point> m_Selection;
    protected AbstractCTableCellEditor m_CellEditor;
    protected ICTableModel m_Model;
    protected int m_LeftColumn;
    protected int m_TopRow;
    protected int m_RowsVisible;
    protected int m_RowsFullyVisible;
    protected int m_ColumnsVisible;
    protected int m_ColumnsFullyVisible;
    protected boolean m_RowSelectionMode;
    protected boolean m_MultiSelectMode;
    protected int m_FocusRow;
    protected int m_FocusCol;
    protected int m_ClickColumnIndex;
    protected int m_ClickRowIndex;
    protected int m_ResizeColumnIndex;
    protected int m_ResizeColumnLeft;
    protected int m_ResizeRowIndex;
    protected int m_ResizeRowTop;
    protected int m_NewRowSize;
    protected List<ICTableCellSelectionListener> cellSelectionListeners;
    protected List<ICTableCellResizeListener> cellResizeListeners;

    public CTable(Composite parent, int style) {
        super(parent, 0x20140000 | style);
        this.init();
    }

    private void init() {
        this.m_GC = new GC((Drawable)this);
        this.m_Display = Display.getCurrent();
        this.m_Selection = new ArrayList<Point>();
        this.m_CellEditor = null;
        this.m_RowSelectionMode = false;
        this.m_MultiSelectMode = false;
        this.m_TopRow = 0;
        this.m_LeftColumn = 0;
        this.m_FocusRow = 0;
        this.m_FocusCol = 0;
        this.m_RowsVisible = 0;
        this.m_RowsFullyVisible = 0;
        this.m_ColumnsVisible = 0;
        this.m_ColumnsFullyVisible = 0;
        this.m_ResizeColumnIndex = -1;
        this.m_ResizeRowIndex = -1;
        this.m_ResizeRowTop = -1;
        this.m_NewRowSize = -1;
        this.m_ResizeColumnLeft = -1;
        this.m_ClickColumnIndex = -1;
        this.m_ClickRowIndex = -1;
        this.cellSelectionListeners = new ArrayList<ICTableCellSelectionListener>();
        this.cellResizeListeners = new ArrayList<ICTableCellResizeListener>();
        this.createListeners();
    }

    protected void createListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                CTable.this.onPaint(event);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CTable.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CTable.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                CTable.this.onMouseUp(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                CTable.this.onMouseDoubleClick(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                CTable.this.onMouseMove(e);
            }
        });
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTable.this.m_TopRow = CTable.this.getVerticalBar().getSelection();
                    CTable.this.redraw();
                }
            });
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTable.this.m_LeftColumn = CTable.this.getHorizontalBar().getSelection();
                    CTable.this.redraw();
                }
            });
        }
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CTable.this.onKeyDown(e);
            }
        });
    }

    public ICTableModel getModel() {
        return this.m_Model;
    }

    public void setModel(ICTableModel model) {
        this.m_Model = model;
        this.reset();
    }

    public Rectangle getVisibleArea() {
        this.doCalculations();
        return new Rectangle(this.m_LeftColumn, this.m_TopRow, this.m_ColumnsFullyVisible, this.m_RowsFullyVisible);
    }

    public void reset() {
        this.m_FocusCol = -1;
        this.m_FocusRow = -1;
        this.clearSelectionWithoutRedraw();
    }

    protected int getFixedWidth() {
        int width = 0;
        int i = 0;
        while (i < this.m_Model.getFixedColumnCount()) {
            width += this.m_Model.getColumnWidth(i);
            ++i;
        }
        return width;
    }

    protected int getColumnLeft(int index) {
        if (index < this.m_Model.getFixedColumnCount()) {
            int x = 0;
            int i = 0;
            while (i < index) {
                x += this.m_Model.getColumnWidth(i);
                ++i;
            }
            return x;
        }
        if (index < this.m_LeftColumn) {
            return -1;
        }
        int x = this.getFixedWidth();
        int i = this.m_LeftColumn;
        while (i < index) {
            x += this.m_Model.getColumnWidth(i);
            ++i;
        }
        return x;
    }

    protected int getColumnRight(int index) {
        if (index < 0) {
            return 0;
        }
        return this.getColumnLeft(index) + this.m_Model.getColumnWidth(index);
    }

    protected int getLastColumnRight() {
        return this.getColumnRight(this.m_Model.getColumnCount() - 1);
    }

    protected void doCalculations() {
        boolean visiable;
        ScrollBar sb;
        if (this.m_Model == null) {
            ScrollBar sb2 = this.getHorizontalBar();
            if (sb2 != null) {
                sb2.setVisible(false);
                sb2.setMinimum(0);
                sb2.setMaximum(1);
                sb2.setPageIncrement(1);
                sb2.setThumb(1);
                sb2.setSelection(1);
            }
            if ((sb2 = this.getVerticalBar()) != null) {
                sb2.setVisible(false);
                sb2.setMinimum(0);
                sb2.setMaximum(1);
                sb2.setPageIncrement(1);
                sb2.setThumb(1);
                sb2.setSelection(1);
            }
            return;
        }
        int m_RowHeight = this.m_Model.getRowHeight();
        Rectangle rect = this.getClientArea();
        if (this.m_LeftColumn < this.m_Model.getFixedColumnCount()) {
            this.m_LeftColumn = this.m_Model.getFixedColumnCount();
        }
        if (this.m_TopRow < this.m_Model.getFixedRowCount()) {
            this.m_TopRow = this.m_Model.getFixedRowCount();
        }
        int fixedHeight = m_RowHeight + (this.m_Model.getFixedRowCount() - 1) * this.m_Model.getRowHeight();
        this.m_ColumnsVisible = 0;
        this.m_ColumnsFullyVisible = 0;
        if (this.m_Model.getColumnCount() > this.m_Model.getFixedColumnCount()) {
            int runningWidth = this.getColumnLeft(this.m_LeftColumn);
            int col = this.m_LeftColumn;
            while (col < this.m_Model.getColumnCount()) {
                if (runningWidth < rect.width + rect.x) {
                    ++this.m_ColumnsVisible;
                }
                if ((runningWidth += this.m_Model.getColumnWidth(col)) >= rect.width + rect.x) break;
                ++this.m_ColumnsFullyVisible;
                ++col;
            }
        }
        if ((sb = this.getHorizontalBar()) != null) {
            visiable = this.m_Model.getColumnCount() * this.m_Model.getColumnWidth(0) + 5 >= rect.width || this.m_LeftColumn != this.m_Model.getFixedColumnCount();
            sb.setVisible(visiable);
            if (visiable) {
                if (this.m_Model.getColumnCount() <= this.m_Model.getFixedColumnCount()) {
                    sb.setMinimum(0);
                    sb.setMaximum(1);
                    sb.setPageIncrement(1);
                    sb.setThumb(1);
                    sb.setSelection(1);
                } else {
                    sb.setMinimum(this.m_Model.getFixedColumnCount());
                    sb.setMaximum(this.m_Model.getColumnCount());
                    sb.setIncrement(1);
                    sb.setPageIncrement(2);
                    sb.setThumb(this.m_ColumnsFullyVisible);
                    sb.setSelection(this.m_LeftColumn);
                }
            }
        }
        this.m_RowsFullyVisible = Math.max(0, (rect.height - fixedHeight) / m_RowHeight);
        this.m_RowsFullyVisible = Math.min(this.m_RowsFullyVisible, this.m_Model.getRowCount() - this.m_Model.getFixedRowCount());
        this.m_RowsFullyVisible = Math.max(0, this.m_RowsFullyVisible);
        this.m_RowsVisible = this.m_RowsFullyVisible + 1;
        if (this.m_TopRow + this.m_RowsFullyVisible > this.m_Model.getRowCount()) {
            this.m_TopRow = Math.max(this.m_Model.getFixedRowCount(), this.m_Model.getRowCount() - this.m_RowsFullyVisible);
        }
        if (this.m_TopRow + this.m_RowsFullyVisible >= this.m_Model.getRowCount()) {
            --this.m_RowsVisible;
        }
        if ((sb = this.getVerticalBar()) != null) {
            visiable = this.m_Model.getRowCount() * this.m_Model.getRowHeight() + 5 >= rect.height || this.m_TopRow != this.m_Model.getFixedRowCount();
            sb.setVisible(visiable);
            if (visiable) {
                if (this.m_Model.getRowCount() <= this.m_Model.getFixedRowCount()) {
                    sb.setMinimum(0);
                    sb.setMaximum(1);
                    sb.setPageIncrement(1);
                    sb.setThumb(1);
                    sb.setSelection(1);
                } else {
                    sb.setMinimum(this.m_Model.getFixedRowCount());
                    sb.setMaximum(this.m_Model.getRowCount());
                    sb.setPageIncrement(this.m_RowsVisible);
                    sb.setIncrement(1);
                    sb.setThumb(this.m_RowsFullyVisible);
                    sb.setSelection(this.m_TopRow);
                }
            }
        }
    }

    public Rectangle getCellRect(int col, int row) {
        int m_RowHeight = this.m_Model.getRowHeight();
        if (col < 0 || col >= this.m_Model.getColumnCount()) {
            return new Rectangle(-1, -1, 0, 0);
        }
        int x = this.getColumnLeft(col) + 1;
        int y = row == 0 ? 0 : (row < this.m_Model.getFixedRowCount() ? row * m_RowHeight : (this.m_Model.getFixedRowCount() + row - this.m_TopRow) * m_RowHeight);
        int width = this.m_Model.getColumnWidth(col) - 1;
        int height = m_RowHeight - 1;
        if (row == 0) {
            height = m_RowHeight - 1;
        }
        return new Rectangle(x, y, width, height);
    }

    protected boolean canDrawCell(int col, int row, Rectangle clipRect) {
        Rectangle r = this.getCellRect(col, row);
        return this.canDrawCell(r, clipRect);
    }

    protected boolean canDrawCell(Rectangle r, Rectangle clipRect) {
        if (r.y + r.height < clipRect.y) {
            return false;
        }
        if (r.y > clipRect.y + clipRect.height) {
            return false;
        }
        if (r.x + r.width < clipRect.x) {
            return false;
        }
        return r.x <= clipRect.x + clipRect.width;
    }

    public void redraw() {
        this.doCalculations();
        super.redraw();
    }

    protected void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        GC gc = event.gc;
        if (this.m_Model != null) {
            this.drawCells(gc, gc.getClipping(), 0, this.m_Model.getFixedColumnCount(), 0, this.m_Model.getFixedRowCount());
            this.drawCells(gc, gc.getClipping(), this.m_LeftColumn, this.m_Model.getColumnCount(), 0, this.m_Model.getFixedRowCount());
            this.drawCells(gc, gc.getClipping(), 0, this.m_Model.getFixedColumnCount(), this.m_TopRow, this.m_TopRow + this.m_RowsVisible);
            this.drawCells(gc, gc.getClipping(), this.m_LeftColumn, this.m_Model.getColumnCount(), this.m_TopRow, this.m_TopRow + this.m_RowsVisible);
            this.drawBottomSpace(gc);
        } else {
            gc.fillRectangle(rect);
        }
    }

    protected void drawBottomSpace(GC gc) {
        Rectangle r = this.getClientArea();
        if (this.m_Model.getRowCount() > 0) {
            r.y = (this.m_Model.getFixedRowCount() + this.m_RowsVisible) * this.m_Model.getRowHeight() + 1;
        }
        gc.setForeground(this.m_Display.getSystemColor(18));
        gc.drawLine(0, r.y - 2, this.getLastColumnRight(), r.y - 2);
        gc.drawLine(this.getLastColumnRight(), 0, this.getLastColumnRight(), r.y - 2);
    }

    public void redraw(Rectangle cellsToRedraw) {
        this.redraw(cellsToRedraw.x, cellsToRedraw.y, cellsToRedraw.width, cellsToRedraw.height);
    }

    public void redraw(int firstCol, int firstRow, int numOfCols, int numOfRows) {
        Rectangle clipRect = this.getClientArea();
        GC gc = new GC((Drawable)this);
        this.drawCells(gc, clipRect, firstCol, firstCol + numOfCols, firstRow, firstRow + numOfRows);
        gc.dispose();
    }

    protected void drawCells(GC gc, Rectangle clipRect, int fromCol, int toCol, int fromRow, int toRow) {
        if (this.m_CellEditor != null) {
            if (!this.isCellVisible(this.m_CellEditor.m_Col, this.m_CellEditor.m_Row)) {
                Rectangle hide = new Rectangle(-101, -101, 100, 100);
                this.m_CellEditor.setBounds(hide);
            } else {
                this.m_CellEditor.setBounds(this.getCellRect(this.m_CellEditor.m_Col, this.m_CellEditor.m_Row));
            }
        }
        int row = fromRow;
        while (row < toRow) {
            Rectangle r = this.getCellRect(0, row);
            if (r.y + r.height >= clipRect.y) {
                if (r.y > clipRect.y + clipRect.height) break;
                int col = fromCol;
                while (col < toCol) {
                    r = this.getCellRect(col, row);
                    if (r.x > clipRect.x + clipRect.width) break;
                    if (this.canDrawCell(col, row, clipRect)) {
                        this.drawCell(gc, col, row);
                    }
                    ++col;
                }
            }
            ++row;
        }
    }

    protected void drawCell(GC gc, int col, int row) {
        if (row < 0 || row >= this.m_Model.getRowCount()) {
            return;
        }
        Rectangle rect = this.getCellRect(col, row);
        this.m_Model.getCellRenderer(col, row).drawCell(gc, rect, col, row, this.m_Model.getContentAt(col, row), this.showAsSelected(col, row), col < this.m_Model.getFixedColumnCount() || row < this.m_Model.getFixedRowCount(), col == this.m_ClickColumnIndex && row == this.m_ClickRowIndex);
    }

    protected boolean showAsSelected(int col, int row) {
        if (this.m_CellEditor != null && col == this.m_CellEditor.m_Col && row == this.m_CellEditor.m_Row) {
            return false;
        }
        return this.isCellSelected(col, row);
    }

    protected void drawRow(GC gc, int row) {
        Rectangle clipRect = this.getClientArea();
        this.drawCells(gc, clipRect, 0, this.m_Model.getFixedColumnCount(), row, row + 1);
        this.drawCells(gc, clipRect, this.m_LeftColumn, this.m_Model.getColumnCount(), row, row + 1);
    }

    protected void drawCol(GC gc, int col) {
        Rectangle clipRect = this.getClientArea();
        this.drawCells(gc, clipRect, col, col + 1, 0, this.m_Model.getFixedRowCount());
        this.drawCells(gc, clipRect, col, col + 1, this.m_TopRow, this.m_TopRow + this.m_RowsVisible);
    }

    protected int getColumnForResize(int x, int y) {
        int i;
        if (this.m_Model == null) {
            return -1;
        }
        if (y <= 0 || y >= this.m_Model.getFixedRowCount() * this.m_Model.getRowHeight()) {
            return -1;
        }
        if (x < this.getFixedWidth() + 3) {
            i = 0;
            while (i < this.m_Model.getFixedColumnCount()) {
                if (Math.abs(x - this.getColumnRight(i)) < 3) {
                    if (this.m_Model.isColumnResizable(i)) {
                        return i;
                    }
                    return -1;
                }
                ++i;
            }
        }
        i = this.m_LeftColumn;
        while (i < this.m_Model.getColumnCount()) {
            int left = this.getColumnLeft(i);
            int right = left + this.m_Model.getColumnWidth(i);
            if (Math.abs(x - right) < 3) {
                if (this.m_Model.isColumnResizable(i)) {
                    return i;
                }
                return -1;
            }
            if (x >= left + 3 && x <= right - 3) break;
            ++i;
        }
        return -1;
    }

    protected int getRowForResize(int x, int y) {
        if (this.m_Model == null || !this.m_Model.isRowResizable()) {
            return -1;
        }
        if (x <= 0 || x >= this.getFixedWidth()) {
            return -1;
        }
        if (y < this.m_Model.getRowHeight()) {
            return -1;
        }
        int row = y / this.m_Model.getRowHeight();
        int rowY = (row + 1) * this.m_Model.getRowHeight();
        if (Math.abs(rowY - y) < 3) {
            return row;
        }
        return -1;
    }

    public int calcRowNum(int y) {
        if (this.m_Model == null) {
            return -1;
        }
        if (y < this.m_Model.getRowHeight()) {
            return this.m_Model.getFixedRowCount() == 0 ? this.m_TopRow : 0;
        }
        int row = 1 + (y -= this.m_Model.getRowHeight()) / this.m_Model.getRowHeight();
        if (row < 0 || row >= this.m_Model.getRowCount()) {
            return -1;
        }
        if (row >= this.m_Model.getFixedRowCount()) {
            return this.m_TopRow + row - this.m_Model.getFixedRowCount();
        }
        return row;
    }

    public int calcColumnNum(int x) {
        if (this.m_Model == null) {
            return -1;
        }
        int col = 0;
        int z = 0;
        int i = 0;
        while (i < this.m_Model.getFixedColumnCount()) {
            if (x >= z && x <= z + this.m_Model.getColumnWidth(i)) {
                return i;
            }
            z += this.m_Model.getColumnWidth(i);
            ++i;
        }
        col = -1;
        z = this.getFixedWidth();
        i = this.m_LeftColumn;
        while (i < this.m_Model.getColumnCount()) {
            if (x >= z && x <= z + this.m_Model.getColumnWidth(i)) {
                col = i;
                break;
            }
            z += this.m_Model.getColumnWidth(i);
            ++i;
        }
        return col;
    }

    public boolean isCellVisible(int col, int row) {
        if (this.m_Model == null) {
            return false;
        }
        return col >= this.m_LeftColumn && col < this.m_LeftColumn + this.m_ColumnsVisible && row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsVisible || col < this.m_Model.getFixedColumnCount() && row < this.m_Model.getFixedRowCount();
    }

    public boolean isCellFullyVisible(int col, int row) {
        if (this.m_Model == null) {
            return false;
        }
        return col >= this.m_LeftColumn && col < this.m_LeftColumn + this.m_ColumnsFullyVisible && row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsFullyVisible || col < this.m_Model.getFixedColumnCount() && row < this.m_Model.getFixedRowCount();
    }

    public boolean isRowVisible(int row) {
        if (this.m_Model == null) {
            return false;
        }
        return row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsVisible || row < this.m_Model.getFixedRowCount();
    }

    public boolean isRowFullyVisible(int row) {
        if (this.m_Model == null) {
            return false;
        }
        return row >= this.m_TopRow && row < this.m_TopRow + this.m_RowsFullyVisible || row < this.m_Model.getFixedRowCount();
    }

    /*
     * Unable to fully structure code
     */
    protected void focusCell(int col, int row, int stateMask) {
        block24: {
            block18: {
                block20: {
                    block23: {
                        block22: {
                            block21: {
                                block19: {
                                    gc = new GC((Drawable)this);
                                    if (this.m_CellEditor != null) {
                                        this.m_CellEditor.close(true);
                                    }
                                    if (row < this.m_Model.getFixedRowCount() || col < this.m_Model.getFixedColumnCount() && !this.m_RowSelectionMode) break block18;
                                    if ((stateMask & 262144) != 0 || (stateMask & 131072) != 0) break block19;
                                    redrawAll = this.m_Selection.size() > 1;
                                    oldFocusRow = this.m_FocusRow;
                                    oldFocusCol = this.m_FocusCol;
                                    this.clearSelectionWithoutRedraw();
                                    this.addToSelection(col, row);
                                    this.m_FocusRow = row;
                                    this.m_FocusCol = col;
                                    if (redrawAll) {
                                        this.redraw();
                                    } else if (this.m_RowSelectionMode) {
                                        if (this.isRowVisible(oldFocusRow)) {
                                            this.drawRow(gc, oldFocusRow);
                                        }
                                        if (this.isRowVisible(this.m_FocusRow)) {
                                            this.drawRow(gc, this.m_FocusRow);
                                        }
                                        this.drawBottomSpace(gc);
                                    } else {
                                        if (this.isCellVisible(oldFocusCol, oldFocusRow)) {
                                            this.drawCell(gc, oldFocusCol, oldFocusRow);
                                        }
                                        if (this.isCellVisible(this.m_FocusCol, this.m_FocusRow)) {
                                            this.drawCell(gc, this.m_FocusCol, this.m_FocusRow);
                                        }
                                        this.drawBottomSpace(gc);
                                    }
                                    break block20;
                                }
                                if ((stateMask & 262144) == 0) break block21;
                                if (this.toggleSelection(col, row)) {
                                    this.m_FocusCol = col;
                                    this.m_FocusRow = row;
                                }
                                if (this.m_RowSelectionMode) {
                                    this.drawRow(gc, row);
                                } else {
                                    this.drawCell(gc, col, row);
                                }
                                break block20;
                            }
                            if ((stateMask & 131072) == 0) break block20;
                            if (!this.m_RowSelectionMode) break block22;
                            if (row >= this.m_FocusRow) ** GOTO lbl48
                            while (row != this.m_FocusRow) {
                                this.addToSelection(0, --this.m_FocusRow);
                            }
                            break block23;
lbl-1000:
                            // 1 sources

                            {
                                this.addToSelection(0, ++this.m_FocusRow);
lbl48:
                                // 2 sources

                                ** while (row != this.m_FocusRow)
                            }
lbl49:
                            // 1 sources

                            break block23;
                        }
                        if (row >= this.m_FocusRow && (row != this.m_FocusRow || col >= this.m_FocusCol)) ** GOTO lbl65
                        while (row != this.m_FocusRow || col != this.m_FocusCol) {
                            --this.m_FocusCol;
                            if (this.m_FocusCol < this.m_Model.getFixedColumnCount()) {
                                this.m_FocusCol = this.m_Model.getColumnCount();
                                --this.m_FocusRow;
                            }
                            this.addToSelection(this.m_FocusCol, this.m_FocusRow);
                        }
                        break block23;
lbl-1000:
                        // 1 sources

                        {
                            ++this.m_FocusCol;
                            if (this.m_FocusCol == this.m_Model.getColumnCount()) {
                                this.m_FocusCol = this.m_Model.getFixedColumnCount();
                                ++this.m_FocusRow;
                            }
                            this.addToSelection(this.m_FocusCol, this.m_FocusRow);
lbl65:
                            // 2 sources

                            ** while (row != this.m_FocusRow || col != this.m_FocusCol)
                        }
                    }
                    this.redraw();
                }
                this.fireCellSelection(col, row, stateMask);
                break block24;
            }
            this.drawCell(gc, col, row);
            this.fireFixedCellSelection(col, row, stateMask);
        }
        gc.dispose();
    }

    protected void onMouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.setCapture(true);
            int columnIndex = this.getColumnForResize(e.x, e.y);
            if (columnIndex >= 0) {
                this.m_ResizeColumnIndex = columnIndex;
                this.m_ResizeColumnLeft = this.getColumnLeft(columnIndex);
                return;
            }
            int rowIndex = this.getRowForResize(e.x, e.y);
            if (rowIndex >= 0) {
                this.m_ResizeRowIndex = rowIndex;
                this.m_ResizeRowTop = rowIndex * this.m_Model.getRowHeight();
                this.m_NewRowSize = this.m_Model.getRowHeight();
                return;
            }
        }
        int col = this.calcColumnNum(e.x);
        int row = this.calcRowNum(e.y);
        if (col == -1 || row == -1) {
            return;
        }
        this.m_ClickColumnIndex = col;
        this.m_ClickRowIndex = row;
        this.focusCell(col, row, e.stateMask);
    }

    protected void onMouseMove(MouseEvent e) {
        if (this.m_Model == null) {
            return;
        }
        if (this.m_ResizeColumnIndex != -1 || this.getColumnForResize(e.x, e.y) >= 0) {
            this.setCursor(new Cursor((Device)this.m_Display, 9));
        } else if (this.m_ResizeRowIndex != -1 || this.getRowForResize(e.x, e.y) >= 0) {
            this.setCursor(new Cursor((Device)this.m_Display, 7));
        } else {
            this.setCursor(null);
        }
        if (e.button == 1 && this.m_ClickColumnIndex != -1 && this.m_MultiSelectMode) {
            int row = this.calcRowNum(e.y);
            int col = this.calcColumnNum(e.x);
            if (row >= this.m_Model.getFixedRowCount() && col >= this.m_Model.getFixedColumnCount()) {
                this.m_ClickColumnIndex = col;
                this.m_ClickRowIndex = row;
                this.focusCell(col, row, e.stateMask | 0x20000);
            }
        }
        if (this.m_ResizeColumnIndex != -1) {
            int newSize;
            Rectangle rect = this.getClientArea();
            int oldSize = this.m_Model.getColumnWidth(this.m_ResizeColumnIndex);
            if (e.x > rect.x + rect.width - 1) {
                e.x = rect.x + rect.width - 1;
            }
            if ((newSize = e.x - this.m_ResizeColumnLeft) < this.m_Model.getColumnWidthMinimum()) {
                newSize = this.m_Model.getColumnWidthMinimum();
            }
            int leftX = this.getColumnLeft(this.m_ResizeColumnIndex);
            int rightX = this.getColumnRight(this.m_ResizeColumnIndex);
            this.m_Model.setColumnWidth(this.m_ResizeColumnIndex, newSize);
            newSize = this.m_Model.getColumnWidth(this.m_ResizeColumnIndex);
            GC gc = new GC((Drawable)this);
            gc.copyArea(rightX, 0, rect.width - rightX, rect.height, leftX + newSize, 0);
            this.drawCol(gc, this.m_ResizeColumnIndex);
            if (newSize < oldSize) {
                int delta = oldSize - newSize;
                this.redraw(rect.width - delta, 0, delta, rect.height, false);
            }
            gc.dispose();
        }
        if (this.m_ResizeRowIndex != -1) {
            Rectangle rect = this.getClientArea();
            GC gc = new GC((Drawable)this);
            if (e.y > rect.y + rect.height - 1) {
                e.y = rect.y + rect.height - 1;
            }
            this.m_NewRowSize = e.y - this.m_ResizeRowTop;
            if (this.m_NewRowSize < this.m_Model.getRowHeightMinimum()) {
                this.m_NewRowSize = this.m_Model.getRowHeightMinimum();
            }
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            int lineEnd = this.getColumnRight(this.m_LeftColumn + this.m_ColumnsVisible - 1);
            int m_LineX = rect.x + 1;
            int m_LineY = this.m_ResizeRowTop + this.m_NewRowSize - 1;
            gc.drawLine(m_LineX, m_LineY, rect.x + lineEnd, m_LineY);
            gc.dispose();
        }
    }

    protected void onMouseUp(MouseEvent e) {
        if (this.m_Model == null) {
            return;
        }
        this.setCapture(false);
        if (this.m_ResizeColumnIndex != -1) {
            this.fireColumnResize(this.m_ResizeColumnIndex, this.m_Model.getColumnWidth(this.m_ResizeColumnIndex));
            this.m_ResizeColumnIndex = -1;
            this.redraw();
        }
        if (this.m_ResizeRowIndex != -1) {
            this.m_ResizeRowIndex = -1;
            this.m_Model.setRowHeight(this.m_NewRowSize);
            this.fireRowResize(this.m_NewRowSize);
            this.redraw();
        }
        if (this.m_ClickColumnIndex != -1) {
            int col = this.m_ClickColumnIndex;
            int row = this.m_ClickRowIndex;
            this.m_ClickColumnIndex = -1;
            this.m_ClickRowIndex = -1;
            if (this.m_CellEditor == null) {
                this.drawCell(new GC((Drawable)this), col, row);
            }
        }
    }

    protected void onKeyDown(KeyEvent e) {
        boolean focusChanged = false;
        int newFocusRow = this.m_FocusRow;
        int newFocusCol = this.m_FocusCol;
        if (this.m_Model == null) {
            return;
        }
        if (e.character == ' ' || e.character == '\r') {
            this.openEditorInFocus();
            return;
        }
        if (e.keyCode == 0x1000007) {
            newFocusCol = this.m_Model.getFixedColumnCount();
            if (newFocusRow == -1) {
                newFocusRow = this.m_Model.getFixedRowCount();
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000008) {
            newFocusCol = this.m_Model.getColumnCount() - 1;
            if (newFocusRow == -1) {
                newFocusRow = this.m_Model.getFixedRowCount();
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000003) {
            if (!this.m_RowSelectionMode && newFocusCol > this.m_Model.getFixedColumnCount()) {
                --newFocusCol;
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000004) {
            if (!this.m_RowSelectionMode) {
                if (newFocusCol == -1) {
                    newFocusCol = this.m_Model.getFixedColumnCount();
                    newFocusRow = this.m_Model.getFixedRowCount();
                } else if (newFocusCol < this.m_Model.getColumnCount() - 1) {
                    ++newFocusCol;
                }
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000002) {
            if (newFocusRow == -1) {
                newFocusRow = this.m_Model.getFixedRowCount();
                newFocusCol = this.m_Model.getFixedColumnCount();
            } else if (newFocusRow < this.m_Model.getRowCount() - 1) {
                ++newFocusRow;
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000001) {
            if (newFocusRow > this.m_Model.getFixedRowCount()) {
                --newFocusRow;
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000006) {
            if ((newFocusRow += this.m_RowsVisible - 1) >= this.m_Model.getRowCount()) {
                newFocusRow = this.m_Model.getRowCount() - 1;
            }
            if (newFocusCol == -1) {
                newFocusCol = this.m_Model.getFixedColumnCount();
            }
            focusChanged = true;
        } else if (e.keyCode == 0x1000005) {
            if ((newFocusRow -= this.m_RowsVisible - 1) < this.m_Model.getFixedRowCount()) {
                newFocusRow = this.m_Model.getFixedRowCount();
            }
            if (newFocusCol == -1) {
                newFocusCol = this.m_Model.getFixedColumnCount();
            }
            focusChanged = true;
        }
        if (focusChanged) {
            this.focusCell(newFocusCol, newFocusRow, e.stateMask);
            if (!this.isCellFullyVisible(this.m_FocusCol, this.m_FocusRow)) {
                this.scrollToFocus();
            }
        }
    }

    protected void onMouseDoubleClick(MouseEvent e) {
        if (this.m_Model == null) {
            return;
        }
        if (e.button == 1) {
            if (e.y < this.m_Model.getFixedRowCount() * this.m_Model.getRowHeight()) {
                int columnIndex = this.getColumnForResize(e.x, e.y);
                this.resizeColumnOptimal(columnIndex);
                return;
            }
            if (e.x < this.m_Model.getColumnWidth(0) + (this.m_Model.getFixedColumnCount() - 1) * this.m_Model.getColumnWidth(0)) {
                return;
            }
            this.openEditorInFocus();
        }
    }

    public int resizeColumnOptimal(int column) {
        if (column >= 0 && column < this.m_Model.getColumnCount()) {
            int width;
            int optWidth = 5;
            int i = 0;
            while (i < this.m_Model.getFixedRowCount()) {
                width = this.m_Model.getCellRenderer(column, i).getOptimalWidth(this.m_GC, column, i, this.m_Model.getContentAt(column, i), true);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            i = this.m_TopRow;
            while (i < this.m_TopRow + this.m_RowsVisible) {
                width = this.m_Model.getCellRenderer(column, i).getOptimalWidth(this.m_GC, column, i, this.m_Model.getContentAt(column, i), true);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            this.m_Model.setColumnWidth(column, optWidth);
            this.redraw();
            return optWidth;
        }
        return -1;
    }

    public void openEditorInFocus() {
        this.m_CellEditor = this.m_Model.getCellEditor(this.m_FocusCol, this.m_FocusRow);
        if (this.m_CellEditor != null) {
            Rectangle r = this.getCellRect(this.m_FocusCol, this.m_FocusRow);
            this.m_CellEditor.open(this, this.m_FocusCol, this.m_FocusRow, r);
        }
    }

    protected void scrollToFocus() {
        boolean change = false;
        if (this.getVerticalBar() != null) {
            if (this.m_FocusRow < this.m_TopRow) {
                this.m_TopRow = this.m_FocusRow;
                change = true;
            }
            if (this.m_FocusRow >= this.m_TopRow + this.m_RowsFullyVisible) {
                this.m_TopRow = this.m_FocusRow - this.m_RowsFullyVisible + 1;
                change = true;
            }
        }
        if (this.getHorizontalBar() != null) {
            if (this.m_FocusCol < this.m_LeftColumn) {
                this.m_LeftColumn = this.m_FocusCol;
                change = true;
            }
            if (this.m_FocusCol >= this.m_LeftColumn + this.m_ColumnsFullyVisible) {
                int oldLeftCol = this.m_LeftColumn;
                Rectangle rect = this.getClientArea();
                while (this.m_LeftColumn < this.m_FocusCol && this.getColumnRight(this.m_FocusCol) > rect.width + rect.x) {
                    ++this.m_LeftColumn;
                }
                boolean bl = change = oldLeftCol != this.m_LeftColumn;
            }
        }
        if (change) {
            this.redraw();
        }
    }

    protected void fireCellSelection(int col, int row, int statemask) {
        int i = 0;
        while (i < this.cellSelectionListeners.size()) {
            this.cellSelectionListeners.get(i).cellSelected(col, row, statemask);
            ++i;
        }
    }

    protected void fireFixedCellSelection(int col, int row, int statemask) {
        int i = 0;
        while (i < this.cellSelectionListeners.size()) {
            this.cellSelectionListeners.get(i).fixedCellSelected(col, row, statemask);
            ++i;
        }
    }

    protected void fireColumnResize(int col, int newSize) {
        int i = 0;
        while (i < this.cellResizeListeners.size()) {
            this.cellResizeListeners.get(i).columnResized(col, newSize);
            ++i;
        }
    }

    protected void fireRowResize(int newSize) {
        int i = 0;
        while (i < this.cellResizeListeners.size()) {
            this.cellResizeListeners.get(i).rowResized(newSize);
            ++i;
        }
    }

    public void addCellSelectionListener(ICTableCellSelectionListener listener) {
        this.cellSelectionListeners.add(listener);
    }

    public boolean removeCellSelectionListener(ICTableCellSelectionListener listener) {
        return this.cellSelectionListeners.remove(listener);
    }

    public boolean removeCellResizeListener(ICTableCellResizeListener listener) {
        return this.cellResizeListeners.remove(listener);
    }

    public void setRowSelectionMode(boolean rowSelectMode) {
        this.m_RowSelectionMode = rowSelectMode;
        this.clearSelection();
    }

    public void setMultiSelectionMode(boolean multiSelectMode) {
        this.m_MultiSelectMode = multiSelectMode;
        this.clearSelection();
    }

    public boolean isRowSelectMode() {
        return this.m_RowSelectionMode;
    }

    public boolean isMultiSelectMode() {
        return this.m_MultiSelectMode;
    }

    protected void clearSelectionWithoutRedraw() {
        this.m_Selection.clear();
    }

    public void clearSelection() {
        this.clearSelectionWithoutRedraw();
        this.m_FocusCol = -1;
        this.m_FocusRow = -1;
        if (this.m_MultiSelectMode) {
            this.redraw();
        }
    }

    protected boolean toggleSelection(int col, int row) {
        if (this.m_MultiSelectMode) {
            Point pt = new Point(col, row);
            if (this.m_Selection.contains(pt)) {
                this.m_Selection.remove(pt);
                return false;
            }
            this.m_Selection.add(pt);
            return true;
        }
        return false;
    }

    protected void addToSelection(int col, int row) {
        if (this.m_MultiSelectMode) {
            Point pt;
            if (this.m_RowSelectionMode) {
                col = 0;
            }
            if (!this.m_Selection.contains(pt = new Point(col, row))) {
                this.m_Selection.add(pt);
            }
        }
    }

    public void setSelection(int col, int row, boolean scroll) {
        if (col < this.m_Model.getColumnCount() && col >= this.m_Model.getFixedColumnCount() && row < this.m_Model.getRowCount() && row >= this.m_Model.getFixedRowCount()) {
            this.focusCell(col, row, 0);
            if (scroll) {
                this.scrollToFocus();
            }
        }
    }

    public boolean isCellSelected(int col, int row) {
        if (!this.m_MultiSelectMode) {
            if (this.m_RowSelectionMode) {
                return row == this.m_FocusRow;
            }
            return col == this.m_FocusCol && row == this.m_FocusRow;
        }
        if (this.m_RowSelectionMode) {
            col = 0;
        }
        return this.m_Selection.contains(new Point(col, row));
    }

    public int[] getRowSelection() {
        if (!this.m_RowSelectionMode) {
            return null;
        }
        if (!this.m_MultiSelectMode) {
            if (this.m_FocusRow < 0) {
                return new int[0];
            }
            int[] tmp = new int[]{this.m_FocusRow};
            return tmp;
        }
        Point[] pts = this.m_Selection.toArray(new Point[0]);
        int[] erg = new int[pts.length];
        int i = 0;
        while (i < erg.length) {
            erg[i] = pts[i].y;
            ++i;
        }
        return erg;
    }

    public Point[] getCellSelection() {
        if (this.m_RowSelectionMode) {
            return null;
        }
        if (!this.m_MultiSelectMode) {
            if (this.m_FocusRow < 0 || this.m_FocusCol < 0) {
                return new Point[0];
            }
            Point[] tmp = new Point[]{new Point(this.m_FocusCol, this.m_FocusRow)};
            return tmp;
        }
        return this.m_Selection.toArray(new Point[0]);
    }
}

