/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.signals;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.ptp.debug.internal.ui.views.signals.SignalsViewContentProvider;
import org.eclipse.ptp.debug.internal.ui.views.signals.SignalsViewEventHandler;
import org.eclipse.ptp.debug.internal.ui.views.signals.SignalsViewer;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class SignalsView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
INullSelectionListener,
IEclipsePreferences.IPreferenceChangeListener,
IDebugExceptionHandler {
    protected Viewer createViewer(Composite parent) {
        Preferences.addPreferenceChangeListener((String)PTPDebugCorePlugin.getUniqueIdentifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
        SignalsViewer vv = new SignalsViewer(parent, 770);
        vv.setContentProvider(this.createContentProvider());
        vv.setLabelProvider((IBaseLabelProvider)new SignalsViewLabelProvider());
        vv.setUseHashlookup(true);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(new SignalsViewEventHandler(this));
        return vv;
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null) {
            this.setViewerInput((IStructuredSelection)new StructuredSelection());
        } else if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    private IContentProvider createContentProvider() {
        SignalsViewContentProvider cp = new SignalsViewContentProvider();
        cp.setExceptionHandler(this);
        return cp;
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object input;
        IPDebugTarget target = null;
        if (ssel != null && ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement && ((IDebugElement)input).getDebugTarget() instanceof IPDebugTarget) {
            target = (IPDebugTarget)((IDebugElement)input).getDebugTarget();
        }
        if (this.getViewer() == null) {
            return;
        }
        Object current = this.getViewer().getInput();
        if (current != null && current.equals(target)) {
            this.updateObjects();
            return;
        }
        this.showViewer();
        this.getViewer().setInput(target);
        this.updateObjects();
    }

    protected void becomesHidden() {
        this.setViewerInput((IStructuredSelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart part = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (part != null) {
            ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)part, selection);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        Preferences.removePreferenceChangeListener((String)PTPDebugCorePlugin.getUniqueIdentifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    public class SignalsViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getModelPresentation().getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IPSignal) {
                try {
                    switch (columnIndex) {
                        case 0: {
                            return ((IPSignal)element).getName();
                        }
                        case 1: {
                            return ((IPSignal)element).isPassEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                        }
                        case 2: {
                            return ((IPSignal)element).isStopEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                        }
                        case 3: {
                            return ((IPSignal)element).getDescription();
                        }
                    }
                }
                catch (DebugException debugException) {}
            }
            return null;
        }

        private IDebugModelPresentation getModelPresentation() {
            return PTPDebugUIPlugin.getDebugModelPresentation();
        }
    }
}

