/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ptp.debug.internal.ui.PDebugImage;
import org.eclipse.ptp.debug.internal.ui.PDebugModelPresentation;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ptp.debug.ui.sourcelookup.DefaultSourceLocator;
import org.eclipse.ptp.ui.IPTPUIConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.debug.ui";
    private static PTPDebugUIPlugin plugin;
    private static UIDebugManager uiDebugManager;
    public static final String PDEBUGGERCONFIGURATION_EXTENSION_POINT_ID = "debuggerConfigurations";
    public static final String DEBUGGERID_ELEMENT = "debuggerID";
    private ResourceBundle resourceBundle;
    protected Map<String, IConfigurationElement> fDebuggerPageMap;

    static {
        uiDebugManager = null;
    }

    public static IPersistableSourceLocator createDefaultSourceLocator() {
        return new DefaultSourceLocator();
    }

    public static void errorDialog(Shell shell, String title, IStatus s) {
        PTPDebugUIPlugin.errorDialog(shell, title, s.getMessage(), s);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
        } else {
            status = new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, Messages.PTPDebugUIPlugin_1, t);
            PTPDebugUIPlugin.log(status);
        }
        PTPDebugUIPlugin.errorDialog(shell, title, message, status);
    }

    public static void errorDialog(Shell shell, String title, Throwable t) {
        PTPDebugUIPlugin.errorDialog(shell, title, t.getMessage(), t);
    }

    public static void errorDialog(String title, IStatus s) {
        PTPDebugUIPlugin.errorDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), title, s.getMessage(), s);
    }

    public static void errorDialog(String title, Throwable t) {
        PTPDebugUIPlugin.errorDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), title, t.getMessage(), t);
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IDebugModelPresentation getDebugModelPresentation() {
        return PDebugModelPresentation.getDefault();
    }

    public static PTPDebugUIPlugin getDefault() {
        return plugin;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPDebugUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static Shell getShell() {
        if (PTPDebugUIPlugin.getActiveWorkbenchWindow() != null) {
            return PTPDebugUIPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static UIDebugManager getUIDebugManager() {
        return uiDebugManager;
    }

    public static String getUniqueIdentifier() {
        if (PTPDebugUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPDebugUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static boolean isPTPDebugPerspective() {
        return IPTPDebugUIConstants.ID_PERSPECTIVE_DEBUG.equals(PTPDebugUIPlugin.getCurrentPerspectiveID());
    }

    public static boolean isPTPPerspective() {
        String curID = PTPDebugUIPlugin.getCurrentPerspectiveID();
        if (curID == null) {
            return false;
        }
        return curID.equals(IPTPUIConstants.PERSPECTIVE_RUN) || curID.equals(IPTPDebugUIConstants.ID_PERSPECTIVE_DEBUG);
    }

    public static void log(IStatus status) {
        PTPDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        PTPDebugUIPlugin.log((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPDebugUIPlugin.log((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, Messages.PTPDebugUIPlugin_2, e));
    }

    private static String getCurrentPerspectiveID() {
        if (PTPDebugUIPlugin.getActiveWorkbenchWindow() != null) {
            return PTPDebugUIPlugin.getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
        }
        return null;
    }

    public PTPDebugUIPlugin() {
        plugin = this;
    }

    public ILaunchConfigurationTab getDebuggerPage(String debuggerID) throws CoreException {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement configElement = this.fDebuggerPageMap.get(debuggerID);
        ILaunchConfigurationTab tab = null;
        if (configElement != null) {
            tab = (ILaunchConfigurationTab)configElement.createExecutableExtension("class");
        }
        return tab;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.debug.ui.UiPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        uiDebugManager = new UIDebugManager();
    }

    public void stop(BundleContext context) throws Exception {
        uiDebugManager.shutdown();
        uiDebugManager = null;
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap<String, IConfigurationElement>(10);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, PDEBUGGERCONFIGURATION_EXTENSION_POINT_ID);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute(DEBUGGERID_ELEMENT);
            this.fDebuggerPageMap.put(id, infos[i]);
            ++i;
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        PDebugImage.initializeImageRegistry(reg);
    }
}

