/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.Messages;
import org.eclipse.cdt.codan.core.model.AbstractProblemReporter;
import org.eclipse.cdt.codan.core.model.ICodanProblemMarker;
import org.eclipse.cdt.codan.internal.core.CodanBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class CodanApplication
implements IApplication {
    private Collection<String> projects = new ArrayList<String>();
    private boolean verbose = false;
    private boolean all = false;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args == null || args.length == 0) {
            this.help();
            return EXIT_OK;
        }
        this.extractArguments(args);
        CodanBuilder codanBuilder = new CodanBuilder();
        CodanRuntime runtime = CodanRuntime.getInstance();
        runtime.setProblemReporter(new AbstractProblemReporter(){

            protected void reportProblem(ICodanProblemMarker pm) {
                IResource file = pm.getResource();
                System.out.println(file.getLocation() + ":" + pm.getLocation().getLineNumber() + ": " + pm.createMessage());
            }
        });
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (this.all) {
            this.log(Messages.CodanApplication_LogRunWorkspace);
            codanBuilder.processResource((IResource)root, (IProgressMonitor)new NullProgressMonitor());
        } else {
            for (String project : this.projects) {
                this.log(String.valueOf(Messages.CodanApplication_LogRunProject) + project);
                IProject wProject = root.getProject(project);
                if (!wProject.exists()) {
                    System.err.println(NLS.bind((String)Messages.CodanApplication_Error_ProjectDoesNotExists, (Object)project));
                    continue;
                }
                codanBuilder.processResource((IResource)wProject, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return EXIT_OK;
    }

    private void log(String string) {
        if (this.verbose) {
            System.err.println(string);
        }
    }

    private void extractArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            String string = args[i];
            if (string.equals("-verbose")) {
                this.verbose = true;
            } else if (string.equals("-all")) {
                this.all = true;
            } else {
                this.projects.add(string);
            }
            ++i;
        }
    }

    private void help() {
        System.out.println(Messages.CodanApplication_Usage);
        System.out.println(Messages.CodanApplication_Options);
        System.out.println(Messages.CodanApplication_all_option);
        System.out.println(Messages.CodanApplication_verbose_option);
    }

    public void stop() {
    }
}

