/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.rm.core.MPIJobAttributes;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.core.utils.IInputStreamListener;
import org.eclipse.ptp.rm.core.utils.InputStreamListenerToOutputStream;
import org.eclipse.ptp.rm.core.utils.InputStreamObserver;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2JobAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2LaunchAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICH2RuntimeSystemJob
extends AbstractToolRuntimeSystemJob {
    public Object lock1 = new Object();
    private InputStreamObserver stderrObserver;
    private InputStreamObserver stdoutObserver;

    public MPICH2RuntimeSystemJob(String jobID, String name, AbstractToolRuntimeSystem rtSystem, AttributeManager attrMgr) {
        super(jobID, name, rtSystem, attrMgr);
    }

    private void initializeProcesses() {
        MPICH2RuntimeSystem rtSystem = (MPICH2RuntimeSystem)this.getRtSystem();
        IPResourceManager rm = (IPResourceManager)rtSystem.getResourceManager().getAdapter(IPResourceManager.class);
        IPJob ipJob = rm.getJobById(this.getJobID());
        IntegerAttribute numProcsAttr = (IntegerAttribute)ipJob.getAttribute((IAttributeDefinition)JobAttributes.getNumberOfProcessesAttributeDefinition());
        this.getRtSystem().createProcesses(this.getJobID(), numProcsAttr.getValue().intValue());
        AttributeManager attrMrg = new AttributeManager();
        attrMrg.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.RUNNING));
        BitSet processes = ipJob.getProcessJobRanks();
        rtSystem.changeProcesses(ipJob.getID(), processes, attrMrg);
    }

    private void terminateProcesses() {
        MPICH2RuntimeSystem rtSystem = (MPICH2RuntimeSystem)this.getRtSystem();
        IPResourceManager rm = (IPResourceManager)rtSystem.getResourceManager().getAdapter(IPResourceManager.class);
        IPJob ipJob = rm.getJobById(this.getJobID());
        AttributeManager attrMrg = new AttributeManager();
        attrMrg.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.COMPLETED));
        rtSystem.changeProcesses(ipJob.getID(), ipJob.getProcessJobRanks(), attrMrg);
    }

    protected void doBeforeExecution(IProgressMonitor monitor, IRemoteProcessBuilder builder) throws CoreException {
    }

    protected void doExecutionCleanUp(IProgressMonitor monitor) {
        if (this.getProcess() != null) {
            this.getProcess().destroy();
        }
        if (this.stderrObserver != null) {
            this.stderrObserver.kill();
            this.stderrObserver = null;
        }
        if (this.stdoutObserver != null) {
            this.stdoutObserver.kill();
            this.stdoutObserver = null;
        }
        this.terminateProcesses();
    }

    protected void doExecutionFinished(IProgressMonitor monitor) throws CoreException {
        this.terminateProcesses();
        if (this.getProcess().exitValue() != 0) {
            if (!this.terminateJobFlag) {
                this.changeJobStatusMessage(NLS.bind((String)Messages.MPICH2RuntimeSystemJob_Exception_ExecutionFailedWithExitValue, (Object)new Integer(this.getProcess().exitValue())));
                this.changeJobStatus(MPIJobAttributes.Status.ERROR);
            }
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING, (String)"RTS job #{0}: ignoring exit value {1} because job was forced to terminate by user", (Object[])new Object[]{this.getJobID(), new Integer(this.getProcess().exitValue())});
        }
    }

    protected void doExecutionStarted(IProgressMonitor monitor) throws CoreException {
        PipedInputStream stderrInputStream;
        PipedOutputStream stderrOutputStream;
        Thread stdoutThread;
        InputStreamListenerToOutputStream stdoutPipedStreamListener;
        IPJob ipJob;
        block5: {
            PipedInputStream stdoutInputStream;
            PipedOutputStream stdoutOutputStream;
            block4: {
                IPResourceManager rm = (IPResourceManager)this.getRtSystem().getResourceManager().getAdapter(IPResourceManager.class);
                ipJob = rm.getJobById(this.getJobID());
                this.initializeProcesses();
                stdoutOutputStream = new PipedOutputStream();
                stdoutInputStream = new PipedInputStream();
                try {
                    stdoutInputStream.connect(stdoutOutputStream);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            stdoutPipedStreamListener = new InputStreamListenerToOutputStream((OutputStream)stdoutOutputStream);
            stdoutThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block13: {
                        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: started", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID()});
                        BufferedReader stdoutBufferedReader = new BufferedReader(new InputStreamReader(stdoutInputStream));
                        try {
                            try {
                                String line = stdoutBufferedReader.readLine();
                                while (line != null) {
                                    int index = 0;
                                    int pos = line.indexOf(": ");
                                    if (pos > 0) {
                                        try {
                                            index = Integer.parseInt(line.substring(0, pos));
                                            line = line.substring(pos + 1);
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    Object object = MPICH2RuntimeSystemJob.this.lock1;
                                    synchronized (object) {
                                        boolean hasProc = ipJob.hasProcessByJobRank(index);
                                        if (hasProc) {
                                            BitSet processIndices = new BitSet();
                                            processIndices.set(index);
                                            StringAttribute attr = ProcessAttributes.getStdoutAttributeDefinition().create(line);
                                            ipJob.addProcessAttributes(processIndices, new AttributeManager((IAttribute)attr));
                                        }
                                        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}:> {1}", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID(), line});
                                    }
                                    line = stdoutBufferedReader.readLine();
                                }
                            }
                            catch (IOException e) {
                                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: {0}", (Object[])new Object[]{e});
                                MPICH2Plugin.log(e);
                                stdoutPipedStreamListener.disable();
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            stdoutPipedStreamListener.disable();
                            throw throwable;
                        }
                        stdoutPipedStreamListener.disable();
                    }
                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout thread: finished", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID()});
                }
            };
            stderrOutputStream = new PipedOutputStream();
            stderrInputStream = new PipedInputStream();
            try {
                stderrInputStream.connect(stderrOutputStream);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        final InputStreamListenerToOutputStream stderrPipedStreamListener = new InputStreamListenerToOutputStream((OutputStream)stderrOutputStream);
        Thread stderrThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block13: {
                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: started", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID()});
                    BufferedReader stderrBufferedReader = new BufferedReader(new InputStreamReader(stderrInputStream));
                    try {
                        try {
                            String line = stderrBufferedReader.readLine();
                            while (line != null) {
                                int index = 0;
                                int pos = line.indexOf(": ");
                                if (pos > 0) {
                                    try {
                                        index = Integer.parseInt(line.substring(0, pos));
                                        line = line.substring(pos + 1);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                Object object = MPICH2RuntimeSystemJob.this.lock1;
                                synchronized (object) {
                                    boolean hasProc = ipJob.hasProcessByJobRank(index);
                                    if (hasProc) {
                                        BitSet processIndices = new BitSet();
                                        processIndices.set(index);
                                        AttributeManager attrManager = new AttributeManager((IAttribute)ProcessAttributes.getStderrAttributeDefinition().create(line));
                                        ipJob.addProcessAttributes(processIndices, attrManager);
                                    }
                                    DebugUtil.error((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}:> {1}", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID(), line});
                                }
                                line = stderrBufferedReader.readLine();
                            }
                        }
                        catch (IOException e) {
                            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: {1}", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID(), e});
                            MPICH2Plugin.log(e);
                            stderrPipedStreamListener.disable();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        stderrPipedStreamListener.disable();
                        throw throwable;
                    }
                    stderrPipedStreamListener.disable();
                }
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr thread: finished", (Object[])new Object[]{MPICH2RuntimeSystemJob.this.getJobID()});
            }
        };
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: starting all threads", (Object[])new Object[]{this.getJobID()});
        stdoutThread.start();
        stderrThread.start();
        this.stderrObserver = new InputStreamObserver(this.getProcess().getErrorStream());
        this.stdoutObserver = new InputStreamObserver(this.getProcess().getInputStream());
        this.stdoutObserver.addListener((IInputStreamListener)stdoutPipedStreamListener);
        this.stderrObserver.addListener((IInputStreamListener)stderrPipedStreamListener);
        this.stderrObserver.start();
        this.stdoutObserver.start();
    }

    protected void doPrepareExecution(IProgressMonitor monitor) throws CoreException {
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolBaseSubstitutionAttributes() throws CoreException {
        return null;
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolCommandSubstitutionAttributes(AttributeManager baseSubstitutionAttributeManager, String directory, Map<String, String> environment) {
        ArrayList<Object> newAttributes = new ArrayList<Object>();
        int p = 0;
        String[] keys = new String[environment.size()];
        for (String key : environment.keySet()) {
            keys[p++] = key;
        }
        newAttributes.add(MPICH2LaunchAttributes.getEnvironmentKeysAttributeDefinition().create((Comparable[])keys));
        newAttributes.add(MPICH2LaunchAttributes.getEnvironmentArgsAttributeDefinition().create());
        newAttributes.add(MPICH2JobAttributes.getJobIdAttributeDefinition().create(this.getJobID()));
        return newAttributes.toArray(new IAttribute[newAttributes.size()]);
    }

    protected HashMap<String, String> doRetrieveToolEnvironment() throws CoreException {
        return null;
    }

    protected void doTerminateJob() {
    }

    protected void doWaitExecution(IProgressMonitor monitor) throws CoreException {
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stderr thread to finish", (Object[])new Object[]{this.getJobID()});
        try {
            this.stderrObserver.join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stdout thread to finish", (Object[])new Object[]{this.getJobID()});
        try {
            this.stdoutObserver.join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting mpi process to finish completely", (Object[])new Object[]{this.getJobID()});
        try {
            this.getProcess().waitFor();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.getProcess().getErrorStream().close();
            this.getProcess().getInputStream().close();
        }
        catch (IOException iOException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: completely finished", (Object[])new Object[]{this.getJobID()});
    }
}

