/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rmsystem;

import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;

public class AbstractEffectiveToolRMConfiguration {
    private static final String EMPTY_STRING = "";
    private String launchCmd;
    private String debugCmd;
    private String discoverCmd;
    private String periodicMonitorCmd;
    private int periodicMonitorTime;
    private String continuousMonitorCmd;
    private String remoteInstallPath;
    int capabilities;
    private IToolRMConfiguration configuration;

    public AbstractEffectiveToolRMConfiguration(IToolRMConfiguration configuration) {
        this.configuration = configuration;
        this.capabilities = configuration.getCapabilities();
    }

    protected void applyValues(String launchCmd, String debugCmd, String discoverCmd, String periodicMonitorCmd, int periodicMonitorTime, String continuousMonitorCmd, String remoteInstallPath) {
        this.launchCmd = launchCmd;
        this.debugCmd = debugCmd;
        this.discoverCmd = discoverCmd;
        this.periodicMonitorCmd = periodicMonitorCmd;
        this.periodicMonitorTime = periodicMonitorTime;
        this.continuousMonitorCmd = continuousMonitorCmd;
        this.remoteInstallPath = remoteInstallPath;
    }

    protected String completeCommand(String command) {
        if (this.remoteInstallPath == null || this.remoteInstallPath.length() == 0) {
            return command;
        }
        return new Path(this.remoteInstallPath).append(command.trim()).toString();
    }

    public String getLaunchCmd() {
        return this.completeCommand(this.launchCmd);
    }

    public String getDebugCmd() {
        return this.completeCommand(this.debugCmd);
    }

    public String getDiscoverCmd() {
        return this.completeCommand(this.discoverCmd);
    }

    public String getPeriodicMonitorCmd() {
        return this.completeCommand(this.periodicMonitorCmd);
    }

    public int getPeriodicMonitorTime() {
        return this.periodicMonitorTime;
    }

    public String getContinuousMonitorCmd() {
        return this.completeCommand(this.continuousMonitorCmd);
    }

    public String getRemoteInstallPath() {
        return this.remoteInstallPath;
    }

    public boolean hasDiscoverCmd() {
        return (this.capabilities & 2) != 0 && this.discoverCmd != null && !this.discoverCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasLaunchCmd() {
        return (this.capabilities & 1) != 0 && this.launchCmd != null && !this.launchCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasDebugCmd() {
        return (this.capabilities & 1) != 0 && this.debugCmd != null && !this.debugCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasContinuousMonitorCmd() {
        return (this.capabilities & 8) != 0 && this.continuousMonitorCmd != null && !this.continuousMonitorCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasPeriodicMonitorCmd() {
        return (this.capabilities & 4) != 0 && this.periodicMonitorCmd != null && !this.periodicMonitorCmd.trim().equals(EMPTY_STRING);
    }

    protected IToolRMConfiguration getConfiguration() {
        return this.configuration;
    }

    protected int getCapabilities() {
        return this.capabilities;
    }
}

