/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.rm.jaxb.control.internal.IAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AbstractAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.TestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestImpl {
    private static final short sEQ = 0;
    private static final short sLT = 1;
    private static final short sGT = 2;
    private static final short sLE = 3;
    private static final short sGE = 4;
    private static final short sAND = 5;
    private static final short sOR = 6;
    private static final short sNOT = 7;
    private final IVariableMap rmVarMap;
    private final String uuid;
    private final short op;
    private final List<String> values;
    private List<TestImpl> children;
    private List<IAssign> ifcond;
    private List<IAssign> elsecond;
    private Object target;

    public TestImpl(String uuid, TestType test, IVariableMap rmVarMap) {
        TestType.Else listelse;
        List listif;
        this.rmVarMap = rmVarMap;
        this.uuid = uuid;
        this.op = this.getOp(test.getOp());
        this.values = test.getValue();
        List tests = test.getTest();
        if (!tests.isEmpty()) {
            this.children = new ArrayList<TestImpl>();
            for (TestType t : tests) {
                this.children.add(new TestImpl(uuid, t, rmVarMap));
            }
        }
        if (!(listif = test.getAddOrAppendOrPut()).isEmpty()) {
            this.ifcond = new ArrayList<IAssign>();
            for (Object o : listif) {
                AbstractAssign.add(uuid, o, this.ifcond, rmVarMap);
            }
        }
        if ((listelse = test.getElse()) != null) {
            this.elsecond = new ArrayList<IAssign>();
            for (Object o : listelse.getAddOrAppendOrPut()) {
                AbstractAssign.add(uuid, o, this.elsecond, rmVarMap);
            }
        }
    }

    public boolean doTest() throws Throwable {
        boolean result = false;
        this.validate(this.op);
        block0 : switch (this.op) {
            case 0: {
                result = this.evaluateEquals(this.values.get(0), this.values.get(1));
                break;
            }
            case 1: {
                result = this.evaluateLessThan(this.values.get(0), this.values.get(1));
                break;
            }
            case 2: {
                result = this.evaluateLessThan(this.values.get(1), this.values.get(0));
                break;
            }
            case 3: {
                result = this.evaluateLessThanOrEquals(this.values.get(0), this.values.get(1));
                break;
            }
            case 4: {
                result = this.evaluateLessThanOrEquals(this.values.get(1), this.values.get(0));
                break;
            }
            case 7: {
                return !this.children.get(0).doTest();
            }
            case 5: {
                result = true;
                for (TestImpl t : this.children) {
                    boolean bl = result = result && t.doTest();
                    if (!result) break block0;
                }
                break;
            }
            case 6: {
                result = false;
                for (TestImpl t : this.children) {
                    boolean bl = result = result || t.doTest();
                    if (result) break block0;
                }
                break;
            }
        }
        if (this.target != null) {
            if (result) {
                this.doAssign(this.ifcond);
            } else {
                this.doAssign(this.elsecond);
            }
        }
        return result;
    }

    public void setTarget(Object target) {
        this.target = target;
        if (this.children != null) {
            for (TestImpl t : this.children) {
                t.setTarget(target);
            }
        }
    }

    private void doAssign(List<IAssign> assign) throws Throwable {
        if (assign != null) {
            for (IAssign a : assign) {
                a.setTarget(this.target);
                a.assign(null);
            }
        }
    }

    private int evaluateComparable(String string1, String string2) throws Throwable {
        Object value1 = AbstractAssign.normalizedValue(this.target, this.uuid, string1, true, this.rmVarMap);
        Object value2 = AbstractAssign.normalizedValue(this.target, this.uuid, string2, true, this.rmVarMap);
        if (value1 == null || value2 == null) {
            return 1;
        }
        if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) {
            return 1;
        }
        Comparable c1 = (Comparable)value1;
        Comparable c2 = (Comparable)value2;
        return c1.compareTo(c2);
    }

    private boolean evaluateEquals(String string1, String string2) throws Throwable {
        Object value1 = AbstractAssign.normalizedValue(this.target, this.uuid, string1, true, this.rmVarMap);
        Object value2 = AbstractAssign.normalizedValue(this.target, this.uuid, string2, true, this.rmVarMap);
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    private boolean evaluateLessThan(String string1, String string2) throws Throwable {
        return this.evaluateComparable(string1, string2) < 0;
    }

    private boolean evaluateLessThanOrEquals(String string1, String string2) throws Throwable {
        return this.evaluateComparable(string1, string2) <= 0;
    }

    private String getOp(short op) {
        if (op == 0) {
            return "EQ";
        }
        if (1 == op) {
            return "LT";
        }
        if (2 == op) {
            return "GT";
        }
        if (3 == op) {
            return "LE";
        }
        if (4 == op) {
            return "GE";
        }
        if (5 == op) {
            return "and";
        }
        if (6 == op) {
            return "or";
        }
        if (7 == op) {
            return "not";
        }
        return "=";
    }

    private short getOp(String op) {
        if ("EQ".equalsIgnoreCase(op)) {
            return 0;
        }
        if ("LT".equalsIgnoreCase(op)) {
            return 1;
        }
        if ("GT".equalsIgnoreCase(op)) {
            return 2;
        }
        if ("LE".equalsIgnoreCase(op)) {
            return 3;
        }
        if ("GE".equalsIgnoreCase(op)) {
            return 4;
        }
        if ("and".equalsIgnoreCase(op)) {
            return 5;
        }
        if ("or".equalsIgnoreCase(op)) {
            return 6;
        }
        if ("not".equalsIgnoreCase(op)) {
            return 7;
        }
        return 0;
    }

    private void validate(short op) throws Throwable {
        switch (op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.values != null && this.values.size() == 2) break;
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.MalformedExpressionError) + this.getOp(op)), null);
            }
            case 7: {
                if (this.children != null && this.children.size() == 1) break;
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.MalformedExpressionError) + this.getOp(op)), null);
            }
            case 5: 
            case 6: {
                if (this.children != null && this.children.size() > 1) break;
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.MalformedExpressionError) + this.getOp(op)), null);
            }
        }
    }
}

