/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetControlEventListener;
import org.eclipse.ptp.remotetools.environment.control.ITargetControlEventProvider;
import org.eclipse.ptp.remotetools.environment.control.PoolingTargetControlEventProvider;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEnvironmentEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;

public class TargetEnvironmentEventManager
implements ITargetControlEventListener,
ITargetEnvironmentEventListener {
    private TargetEnvironmentManager model = null;
    private ITargetControlEventProvider defaultProvider = new PoolingTargetControlEventProvider();
    private Map controls = new HashMap();

    public TargetEnvironmentEventManager(TargetEnvironmentManager model) {
        this.model = model;
        model.addModelChangedListener(this);
    }

    public void handleStateChangeEvent(int event, ITargetControl from) {
        ControlInfo info = (ControlInfo)this.controls.get(from);
        this.model.fireElementEvent(event, info.getElement());
    }

    public void elementAdded(TargetElement element) {
        try {
            ITargetControl control = element.getControl();
            ITargetControlEventProvider provider = null;
            if (IAdaptable.class.isAssignableFrom(control.getClass())) {
                provider = (ITargetControlEventProvider)((IAdaptable)control).getAdapter(ITargetControlEventProvider.class);
            }
            if (provider == null) {
                provider = this.defaultProvider;
            }
            this.controls.put(control, new ControlInfo(element, provider));
            provider.registerControlAndListener(control, this);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void elementRemoved(ITargetElement element) {
        try {
            ITargetControl control = element.getControl();
            ControlInfo info = (ControlInfo)this.controls.get(control);
            ITargetControlEventProvider provider = info.getProvider();
            provider.unregisterControlAndListener(control, this);
            this.controls.remove(control);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    class ControlInfo {
        private TargetElement element;
        private ITargetControlEventProvider provider;

        public ControlInfo(TargetElement element, ITargetControlEventProvider provider) {
            this.element = element;
            this.provider = provider;
        }

        public TargetElement getElement() {
            return this.element;
        }

        public void setElement(TargetElement element) {
            this.element = element;
        }

        public ITargetControlEventProvider getProvider() {
            return this.provider;
        }

        public void setProvider(ITargetControlEventProvider provider) {
            this.provider = provider;
        }
    }
}

