/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.extension.ITargetTypeExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetTypeElement {
    private String name;
    private TargetEnvironmentManager manager;
    private ITargetTypeExtension extension;
    private List<ITargetElement> elements = new ArrayList<ITargetElement>();

    public TargetTypeElement(String name, ITargetTypeExtension env, TargetEnvironmentManager model) {
        this.name = name;
        this.extension = env;
        this.manager = model;
    }

    public List<ITargetElement> getElements() {
        return this.elements;
    }

    public void addElement(TargetElement element) {
        this.elements.add(element);
        this.manager.fireModelChanged(0, null, element);
    }

    public void removeElement(ITargetElement element) {
        this.elements.remove(element);
        this.manager.fireModelChanged(1, element, null);
    }

    public ITargetTypeExtension getExtension() {
        return this.extension;
    }

    public void setExtension(ITargetTypeExtension extension) {
        this.extension = extension;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }
}

