/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rdt.ui.search.actions.FindAction;
import org.eclipse.ptp.internal.rdt.ui.search.actions.FindDeclarationsAction;
import org.eclipse.ptp.internal.rdt.ui.search.actions.FindDeclarationsInWorkingSetAction;
import org.eclipse.ptp.internal.rdt.ui.search.actions.FindDeclarationsProjectAction;
import org.eclipse.ptp.internal.rdt.ui.search.actions.WorkingSetFindAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class DeclarationsSearchGroup
extends ActionGroup {
    private CEditor fEditor;
    private IWorkbenchSite fSite;
    private FindDeclarationsAction fFindDeclarationsAction;
    private FindDeclarationsProjectAction fFindDeclarationsProjectAction;
    private FindDeclarationsInWorkingSetAction fFindDeclarationsInWorkingSetAction;

    public DeclarationsSearchGroup(IWorkbenchSite site) {
        this.fFindDeclarationsAction = new FindDeclarationsAction(site);
        this.fFindDeclarationsProjectAction = new FindDeclarationsProjectAction(site);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(site, null);
        this.fSite = site;
    }

    public DeclarationsSearchGroup(CEditor editor) {
        this.fEditor = editor;
        this.fFindDeclarationsAction = new FindDeclarationsAction(editor);
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.cdt.ui.search.finddecl");
        if (editor != null) {
            editor.setAction("org.eclipse.cdt.ui.search.finddecl", (IAction)this.fFindDeclarationsAction);
        }
        this.fFindDeclarationsProjectAction = new FindDeclarationsProjectAction(editor);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(editor, null);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IMenuManager incomingMenu = menu;
        MenuManager declarationsMenu = new MenuManager(CSearchMessages.group_declarations, "group.search");
        if (this.fEditor != null) {
            menu.appendToGroup("group.find", (IContributionItem)declarationsMenu);
        } else {
            incomingMenu.appendToGroup("group.search", (IContributionItem)declarationsMenu);
        }
        incomingMenu = declarationsMenu;
        FindAction[] actions = this.getWorkingSetActions();
        incomingMenu.add((IAction)this.fFindDeclarationsAction);
        incomingMenu.add((IAction)this.fFindDeclarationsProjectAction);
        incomingMenu.add((IAction)this.fFindDeclarationsInWorkingSetAction);
        FindAction[] findActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            FindAction action = findActionArray[n2];
            incomingMenu.add((IAction)action);
            ++n2;
        }
    }

    private FindAction[] getWorkingSetActions() {
        ArrayList<WorkingSetFindAction> actions = new ArrayList<WorkingSetFindAction>(CSearchUtil.LRU_WORKINGSET_LIST_SIZE);
        for (IWorkingSet[] workingSets : CSearchUtil.getLRUWorkingSets()) {
            WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindDeclarationsInWorkingSetAction(this.fEditor, workingSets), CSearchUtil.toString((IWorkingSet[])workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindDeclarationsInWorkingSetAction(this.fSite, workingSets), CSearchUtil.toString((IWorkingSet[])workingSets));
            actions.add(action);
        }
        return actions.toArray(new FindAction[actions.size()]);
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() > 0;
        }
        return DeclarationsSearchGroup.getElement(selection) != null;
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    public void dispose() {
        this.fFindDeclarationsAction = null;
        this.fFindDeclarationsProjectAction = null;
        this.fFindDeclarationsInWorkingSetAction = null;
        super.dispose();
    }
}

