/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.PageLayout;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.cdt.ui.wizards.IWizardWithMemory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.ptp.rdt.ui.wizards.NewRemoteProjectCreationPage;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteMainWizardPage
extends NewRemoteProjectCreationPage
implements IWizardItemsListListener {
    private static final Image IMG_CATEGORY = CPluginImages.get((String)"org.eclipse.cdt.ui.fldr_obj.gif");
    private static final Image IMG_ITEM = CPluginImages.get((String)"org.eclipse.cdt.ui.variable_obj.gif");
    public static final String PAGE_ID = "org.eclipse.cdt.managedbuilder.ui.wizard.NewModelProjectWizardPage";
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.CDTWizard";
    private static final String ELEMENT_NAME = "wizard";
    private static final String CLASS_NAME = "class";
    public static final String DESC = "EntryDescriptor";
    private Tree tree;
    private Composite right;
    private Button show_sup;
    private Label right_label;
    public CWizardHandler h_selected = null;
    private Label categorySelectedLabel;
    private final IServiceConfiguration defaultConfig = null;

    public RemoteMainWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        CDTPrefUtil.setBool((String)"wizard.show.unsupported.disable", (boolean)true);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createDynamicGroup((Composite)this.getControl());
        this.switchTo(RemoteMainWizardPage.updateData(this.tree, this.right, this.show_sup, this, this.getWizard()), RemoteMainWizardPage.getDescriptor(this.tree));
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        Shell shell = this.getContainer().getShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ptp.rdt.ui.creating_a_remote_project_context");
    }

    private void createDynamicGroup(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        c.setLayout((Layout)new GridLayout(2, true));
        Label l1 = new Label(c, 0);
        l1.setText(UIMessages.getString((String)"CMainWizardPage.0"));
        l1.setFont(parent.getFont());
        l1.setLayoutData((Object)new GridData(1));
        this.right_label = new Label(c, 0);
        this.right_label.setFont(parent.getFont());
        this.right_label.setLayoutData((Object)new GridData(1));
        this.tree = new Tree(c, 2052);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] tis = RemoteMainWizardPage.this.tree.getSelection();
                if (tis == null || tis.length == 0) {
                    return;
                }
                RemoteMainWizardPage.this.switchTo((CWizardHandler)tis[0].getData(), (EntryDescriptor)tis[0].getData(RemoteMainWizardPage.DESC));
                RemoteMainWizardPage.this.setPageComplete(RemoteMainWizardPage.this.validatePage());
            }
        });
        this.tree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                int i = 0;
                while (i < RemoteMainWizardPage.this.tree.getItemCount()) {
                    if (RemoteMainWizardPage.this.tree.getItem(i).getText().compareTo(e.result) == 0) {
                        return;
                    }
                    ++i;
                }
                e.result = UIMessages.getString((String)"CMainWizardPage.0");
            }
        });
        this.right = new Composite(c, 0);
        this.right.setLayoutData((Object)new GridData(1808));
        this.right.setLayout((Layout)new PageLayout());
        this.show_sup = new Button(c, 32);
        this.show_sup.setText(UIMessages.getString((String)"CMainWizardPage.1"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.show_sup.setLayoutData((Object)gd);
        this.show_sup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RemoteMainWizardPage.this.h_selected != null) {
                    RemoteMainWizardPage.this.h_selected.setSupportedOnly(RemoteMainWizardPage.this.show_sup.getSelection());
                }
                RemoteMainWizardPage.this.switchTo(RemoteMainWizardPage.updateData(RemoteMainWizardPage.this.tree, RemoteMainWizardPage.this.right, RemoteMainWizardPage.this.show_sup, RemoteMainWizardPage.this, RemoteMainWizardPage.this.getWizard()), RemoteMainWizardPage.getDescriptor(RemoteMainWizardPage.this.tree));
            }
        });
        this.show_sup.setSelection(!CDTPrefUtil.getBool((String)"wizard.show.unsupported.disable"));
    }

    public IWizardPage getNextPage() {
        return this.h_selected == null ? null : this.h_selected.getSpecificPage();
    }

    public URI getProjectLocation() {
        return this.useDefaults() ? null : this.getLocationURI();
    }

    @Override
    protected boolean validatePage() {
        IStatus locationStatus;
        this.setMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        if (this.getProjectName().indexOf(35) >= 0) {
            this.setErrorMessage(UIMessages.getString((String)"RemoteMainWizardPage.0"));
            return false;
        }
        boolean bad = true;
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            IWizardWithMemory w;
            if (this.getWizard() instanceof IWizardWithMemory && (w = (IWizardWithMemory)this.getWizard()).getLastProjectName() != null && w.getLastProjectName().equals(this.getProjectName())) {
                bad = false;
            }
            if (bad) {
                this.setErrorMessage(UIMessages.getString((String)"CMainWizardPage.10"));
                return false;
            }
        }
        if (bad) {
            try {
                IFileStore fs;
                URI p = this.getProjectLocation();
                if (p == null) {
                    fs = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
                    fs = fs.getChild(this.getProjectName());
                } else {
                    fs = EFS.getStore((URI)p);
                }
                IFileInfo f = fs.fetchInfo();
                if (f.exists() && f.isDirectory() && fs.getChild(".project").fetchInfo().exists()) {
                    this.setMessage("Existing project settings will be overridden");
                    return true;
                }
            }
            catch (CoreException e) {
                CUIPlugin.log((IStatus)e.getStatus());
            }
        }
        if (!this.useDefaults() && !(locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocationURI(handle, this.getLocationURI())).isOK()) {
            this.setErrorMessage(locationStatus.getMessage());
            return false;
        }
        if (this.tree.getItemCount() == 0) {
            this.setErrorMessage(UIMessages.getString((String)"CMainWizardPage.3"));
            return false;
        }
        if (this.h_selected == null) {
            this.setErrorMessage(null);
            return false;
        }
        String s = this.h_selected.getErrorMessage();
        if (s != null) {
            this.setErrorMessage(s);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public static CWizardHandler updateData(Tree tree, Composite right, Button show_sup, IWizardItemsListListener ls, IWizard wizard) {
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        TreeItem[] sel = tree.getSelection();
        String savedStr = sel.length > 0 ? sel[0].getText() : null;
        tree.removeAll();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        List<Object> items = new ArrayList<EntryDescriptor>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            iConfigurationElementArray = elements = extensions[i].getConfigurationElements();
            n2 = elements.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                if (element.getName().equals(ELEMENT_NAME)) {
                    CNewWizard w = null;
                    try {
                        w = (CNewWizard)element.createExecutableExtension(CLASS_NAME);
                    }
                    catch (CoreException e) {
                        System.out.println(String.valueOf(UIMessages.getString((String)"CMainWizardPage.5")) + e.getLocalizedMessage());
                        return null;
                    }
                    if (w == null) {
                        return null;
                    }
                    w.setDependentControl(right, ls);
                    EntryDescriptor[] entryDescriptorArray = w.createItems(show_sup.getSelection(), wizard);
                    int n3 = entryDescriptorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        EntryDescriptor ed = entryDescriptorArray[n4];
                        items.add(ed);
                        ++n4;
                    }
                }
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            EntryDescriptor ed = (EntryDescriptor)items.get(i);
            if (ed.isDefaultForCategory()) {
                items.remove(i);
                items.add(0, ed);
                break;
            }
            ++i;
        }
        if (ls != null) {
            items = ls.filterItems(items);
        }
        RemoteMainWizardPage.addItemsToTree(tree, items);
        if (tree.getItemCount() > 0) {
            TreeItem target = null;
            if (savedStr != null) {
                TreeItem[] all = tree.getItems();
                iConfigurationElementArray = all;
                n2 = all.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (savedStr.equals(element.getText())) {
                        target = element;
                        break;
                    }
                    ++n;
                }
            }
            if (target == null && (target = tree.getItem(0)).getItemCount() != 0) {
                target = target.getItem(0);
            }
            tree.setSelection(target);
            return (CWizardHandler)target.getData();
        }
        return null;
    }

    private static void addItemsToTree(Tree tree, List<EntryDescriptor> items) {
        boolean found;
        ArrayList<TreeItem> placedTreeItemsList = new ArrayList<TreeItem>(items.size());
        ArrayList<EntryDescriptor> placedEntryDescriptorsList = new ArrayList<EntryDescriptor>(items.size());
        for (EntryDescriptor wd : items) {
            if (wd.getParentId() != null) continue;
            wd.setPath(wd.getId());
            TreeItem ti = new TreeItem(tree, 0);
            ti.setText(TextProcessor.process((String)wd.getName()));
            ti.setData((Object)wd.getHandler());
            ti.setData(DESC, (Object)wd);
            ti.setImage(RemoteMainWizardPage.calcImage(wd));
            placedTreeItemsList.add(ti);
            placedEntryDescriptorsList.add(wd);
        }
        do {
            found = false;
            block2: for (EntryDescriptor wd1 : items) {
                if (wd1.getParentId() == null) continue;
                int i = 0;
                while (i < placedEntryDescriptorsList.size()) {
                    EntryDescriptor wd2 = (EntryDescriptor)placedEntryDescriptorsList.get(i);
                    if (wd2.getId().equals(wd1.getParentId())) {
                        found = true;
                        wd1.setParentId(null);
                        CWizardHandler h = wd2.getHandler();
                        if (h == null && wd1.getHandler() == null && !wd1.isCategory()) continue block2;
                        wd1.setPath(String.valueOf(wd2.getPath()) + "/" + wd1.getId());
                        wd1.setParent(wd2);
                        if (h != null) {
                            if (wd1.getHandler() == null && !wd1.isCategory()) {
                                wd1.setHandler((CWizardHandler)h.clone());
                            }
                            if (!h.isApplicable(wd1)) continue block2;
                        }
                        TreeItem p = (TreeItem)placedTreeItemsList.get(i);
                        TreeItem ti = new TreeItem(p, 0);
                        ti.setText(wd1.getName());
                        ti.setData((Object)wd1.getHandler());
                        ti.setData(DESC, (Object)wd1);
                        ti.setImage(RemoteMainWizardPage.calcImage(wd1));
                        placedTreeItemsList.add(ti);
                        placedEntryDescriptorsList.add(wd1);
                        continue block2;
                    }
                    ++i;
                }
            }
        } while (found);
    }

    private void switchTo(CWizardHandler h, EntryDescriptor ed) {
        if (h == null) {
            h = ed.getHandler();
        }
        if (ed.isCategory()) {
            h = null;
        }
        try {
            if (h != null) {
                h.initialize(ed);
            }
        }
        catch (CoreException coreException) {
            h = null;
        }
        if (this.h_selected != null) {
            this.h_selected.handleUnSelection();
        }
        this.h_selected = h;
        if (h == null) {
            if (ed.isCategory()) {
                if (this.categorySelectedLabel == null) {
                    this.categorySelectedLabel = new Label(this.right, 64);
                    this.categorySelectedLabel.setText(UIMessages.getString((String)"CDTMainWizardPage.1"));
                    this.right.layout();
                }
                this.categorySelectedLabel.setVisible(true);
            }
            return;
        }
        this.right_label.setText(this.h_selected.getHeader());
        if (this.categorySelectedLabel != null) {
            this.categorySelectedLabel.setVisible(false);
        }
        this.h_selected.handleSelection();
        this.h_selected.setSupportedOnly(this.show_sup.getSelection());
    }

    public static EntryDescriptor getDescriptor(Tree _tree) {
        TreeItem[] sel = _tree.getSelection();
        if (sel == null || sel.length == 0) {
            return null;
        }
        return (EntryDescriptor)sel[0].getData(DESC);
    }

    public void toolChainListChanged(int count) {
        this.setPageComplete(this.validatePage());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }

    private static Image calcImage(EntryDescriptor ed) {
        if (ed.getImage() != null) {
            return ed.getImage();
        }
        if (ed.isCategory()) {
            return IMG_CATEGORY;
        }
        return IMG_ITEM;
    }

    public List filterItems(List items) {
        Iterator iterator = items.iterator();
        LinkedList<EntryDescriptor> filteredList = new LinkedList<EntryDescriptor>();
        while (iterator.hasNext()) {
            EntryDescriptor ed = (EntryDescriptor)iterator.next();
            if (!ed.getId().startsWith("org.eclipse.ptp.rdt")) continue;
            filteredList.add(ed);
        }
        return filteredList;
    }
}

