/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.common;

import org.eclipse.ptp.remotetools.core.IRemoteOperation;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;

public abstract class AbstractRemoteExecution
implements IRemoteOperation {
    private final ExecutionManager executionManager;
    protected boolean cancelled;
    protected boolean finished;

    public AbstractRemoteExecution(ExecutionManager executionManager) throws RemoteConnectionException {
        this.executionManager = executionManager;
        this.cancelled = false;
        this.finished = false;
    }

    public final synchronized void cancel() {
        this.notifyCancel();
    }

    public void close() {
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    protected synchronized void notifyCancel() {
        this.cancelled = true;
        this.notifyAll();
    }

    protected synchronized void notifyFinish() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void waitForEndOfExecution() throws RemoteConnectionException, CancelException {
        while (!this.finished && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.wasCanceled()) {
            throw new CancelException();
        }
    }

    public synchronized boolean wasCanceled() {
        return this.cancelled;
    }

    public synchronized boolean wasFinished() {
        return this.finished;
    }
}

