/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.internal.core.elements.PElementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PElement
extends PlatformObject
implements IPElement,
Comparable<IPElement> {
    private final PElementInfo elementInfo = new PElementInfo(this);
    protected final AttributeManager attributeValues = new AttributeManager();
    protected final String elementId;
    protected final IPElement elementParent;

    protected PElement(String id, IPElement parent, IAttribute<?, ?, ?>[] attrs) {
        this.elementId = id;
        this.elementParent = parent;
        ArrayList attrList = new ArrayList(Arrays.asList(attrs));
        attrList.add(ElementAttributes.getIdAttributeDefinition().create(id));
        this.attributeValues.addAttributes(attrList.toArray(new IAttribute[0]));
    }

    @Override
    public void addAttribute(IAttribute<?, ?, ?> attrib) {
        this.addAttributes(new IAttribute[]{attrib});
    }

    @Override
    public void addAttributes(IAttribute<?, ?, ?>[] attribs) {
        this.attributeValues.addAttributes(attribs);
        this.doAddAttributeHook(new AttributeManager(attribs));
    }

    @Override
    public int compareTo(IPElement obj) {
        return this.getName().compareTo(obj.getName());
    }

    protected abstract void doAddAttributeHook(AttributeManager var1);

    @Override
    public <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> A getAttribute(D attrDef) {
        return this.attributeValues.getAttribute(attrDef);
    }

    @Override
    public IAttribute<?, ?, ?> getAttribute(String attrId) {
        return this.attributeValues.getAttribute(attrId);
    }

    @Override
    public IAttributeDefinition<?, ?, ?>[] getAttributeKeys() {
        return this.attributeValues.getKeys();
    }

    @Override
    public IAttribute<?, ?, ?>[] getAttributes() {
        return this.attributeValues.getAttributes();
    }

    @Override
    public IAttribute<?, ?, ?>[] getDisplayAttributes() {
        return this.attributeValues.getDisplayAttributes();
    }

    protected PElementInfo getElementInfo() {
        return this.elementInfo;
    }

    @Override
    public String getID() {
        return this.elementId;
    }

    @Override
    public String getName() {
        StringAttribute attr = (StringAttribute)this.attributeValues.getAttribute(ElementAttributes.getNameAttributeDefinition());
        if (attr != null) {
            return attr.getValue();
        }
        return this.getID();
    }

    @Override
    public IPElement getParent() {
        return this.elementParent;
    }

    @Override
    public void removeAttribute(IAttribute<?, ?, ?> attrib) {
        this.attributeValues.removeAttribute(attrib);
    }

    @Override
    public int size() {
        return this.getElementInfo().size();
    }

    public String toString() {
        return this.getName();
    }
}

