/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.elements.IPElement;

public class PElementInfo {
    private final Map<String, IPElement> fChildren = Collections.synchronizedMap(new HashMap());
    protected final IPElement element;

    public PElementInfo(IPElement element) {
        this.element = element;
    }

    public void addChild(IPElement member) {
        this.fChildren.put(member.getID(), member);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPElement findChild(String key) {
        Map<String, IPElement> map = this.fChildren;
        synchronized (map) {
            if (this.fChildren.containsKey(key)) {
                return this.fChildren.get(key);
            }
        }
        return null;
    }

    public IPElement[] getChildren() {
        return this.fChildren.values().toArray(new IPElement[this.size()]);
    }

    public IPElement getElement() {
        return this.element;
    }

    public boolean hasChildren() {
        return this.size() > 0;
    }

    public boolean includesChild(IPElement child) {
        return this.fChildren.containsKey(child.getID());
    }

    public void removeChild(IPElement member) {
        this.fChildren.remove(member.getID());
    }

    public void removeChildren() {
        this.fChildren.clear();
    }

    public void setChildren(IPElement[] children) {
        IPElement[] iPElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPElement element = iPElementArray[n2];
            this.fChildren.put(element.getID(), element);
            ++n2;
        }
    }

    public int size() {
        return this.fChildren.size();
    }
}

