/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.actions;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseHandlerBase;
import org.eclipse.ptp.pldt.common.util.ViewActivator;
import org.eclipse.ptp.pldt.mpi.core.MPIArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.mpi.core.MpiPlugin;
import org.eclipse.ptp.pldt.mpi.core.analysis.MpiCASTVisitor;
import org.eclipse.ptp.pldt.mpi.core.analysis.MpiCPPASTVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAnalyseMPIcommandHandler
extends RunAnalyseHandlerBase {
    public RunAnalyseMPIcommandHandler() {
        super("MPI", (ArtifactMarkingVisitor)new MPIArtifactMarkingVisitor("org.eclipse.ptp.pldt.mpi.core.mpiMarker"), "org.eclipse.ptp.pldt.mpi.core.mpiMarker");
    }

    public ScanReturn doArtifactAnalysis(ITranslationUnit tu, List<String> includes) {
        ScanReturn msr = new ScanReturn();
        String fileName = tu.getElementName();
        boolean allowPrefixOnlyMatch = MpiPlugin.getDefault().getPreferenceStore().getBoolean("mpiRecognizeAPIsByPrefixAlone");
        try {
            ILanguage lang = tu.getLanguage();
            IASTTranslationUnit atu = this.getAST(tu);
            String languageID = lang.getId();
            if ((languageID.equals("org.eclipse.cdt.core.gcc") || languageID.equals("org.eclipse.cdt.core.g++")) && atu == null) {
                System.out.println("RunAnalyseMPICommandHandler.doArtifactAnalysis(), atu is null (Fortran testing?)");
                return msr;
            }
            if (languageID.equals("org.eclipse.cdt.core.gcc")) {
                atu.accept((ASTVisitor)new MpiCASTVisitor(includes, fileName, allowPrefixOnlyMatch, msr));
            } else if (languageID.equals("org.eclipse.cdt.core.g++")) {
                atu.accept((ASTVisitor)new MpiCPPASTVisitor(includes, fileName, allowPrefixOnlyMatch, msr));
            } else {
                try {
                    Class<?> c = Class.forName("org.eclipse.ptp.pldt.mpi.core.actions.AnalyseMPIFortranHandler");
                    Method method = c.getMethod("run", String.class, ITranslationUnit.class, String.class, ScanReturn.class);
                    method.invoke(c.newInstance(), languageID, tu, fileName, msr);
                }
                catch (Exception exception) {
                    System.err.println("RunAnalyseMPIcommandHandler.doArtifactAnalysis: Photran not installed");
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            CommonPlugin.log((int)4, (String)("RunAnalyseMPICommandHandler.getAST():Error setting up visitor for project " + tu.getCProject() + " error=" + e.getMessage()));
        }
        return msr;
    }

    protected List<String> getIncludePath() {
        return MpiPlugin.getDefault().getMpiIncludeDirs();
    }

    protected void activateArtifactView() {
        ViewActivator.activateView((String)"org.eclipse.ptp.pldt.mpi.core.views.MPITableView");
    }

    public boolean areIncludePathsNeeded() {
        boolean allowPrefixOnlyMatch = MpiPlugin.getDefault().getPreferenceStore().getBoolean("mpiRecognizeAPIsByPrefixAlone");
        return !allowPrefixOnlyMatch;
    }
}

