/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.pinclone;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.debug.ui.PinElementHandle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.contexts.AbstractDebugContextProvider;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextProvider2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugContextPinProvider
extends AbstractDebugContextProvider
implements IDebugContextProvider2 {
    private ISelection fActiveContext;
    private final Set<IPinProvider.IPinElementHandle> fPinHandles;
    private final IWorkbenchPart fWorkbenchPart;
    private final Map<IPinProvider.IPinElementHandle, IPinProvider> fPinProvider;
    Set<IPinProvider.IPinElementHandle> handles = new HashSet<IPinProvider.IPinElementHandle>();

    public DebugContextPinProvider(IWorkbenchPart part, ISelection activeContext) {
        super(part);
        this.fWorkbenchPart = part;
        this.fPinProvider = new HashMap<IPinProvider.IPinElementHandle, IPinProvider>();
        this.fActiveContext = activeContext;
        this.fPinHandles = this.pin(part, activeContext, new IPinProvider.IPinModelListener(){

            public void modelChanged(ISelection selection) {
                DebugContextPinProvider.this.delegateEvent(new DebugContextEvent((IDebugContextProvider)DebugContextPinProvider.this, (ISelection)(selection == null ? new StructuredSelection() : selection), 1));
            }
        });
    }

    public void dispose() {
        for (Map.Entry<IPinProvider.IPinElementHandle, IPinProvider> entry : this.fPinProvider.entrySet()) {
            entry.getValue().unpin(this.fWorkbenchPart, entry.getKey());
        }
    }

    public boolean isWindowContextProvider() {
        return false;
    }

    public ISelection getActiveContext() {
        return this.fActiveContext;
    }

    public Set<IPinProvider.IPinElementHandle> getPinHandles() {
        return this.fPinHandles;
    }

    public boolean isPinnedTo(Object debugContext) {
        return PinCloneUtils.isPinnedTo(this.fPinHandles, debugContext);
    }

    private Set<IPinProvider.IPinElementHandle> pin(IWorkbenchPart part, ISelection selection, IPinProvider.IPinModelListener listener) {
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                IPinProvider pinProvider = null;
                if (element instanceof IAdaptable) {
                    pinProvider = (IPinProvider)((IAdaptable)element).getAdapter(IPinProvider.class);
                }
                if (pinProvider != null) {
                    IPinProvider.IPinElementHandle handle = pinProvider.pin(this.fWorkbenchPart, element, listener);
                    this.handles.add(handle);
                    this.fPinProvider.put(handle, pinProvider);
                    continue;
                }
                this.handles.add(new PinElementHandle(element, null, PinCloneUtils.getDefaultPinElementColorDescriptor()));
            }
        }
        return this.handles;
    }

    public void delegateEvent(final DebugContextEvent event) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DebugContextPinProvider.this.fActiveContext = event.getContext();
                DebugContextPinProvider.this.fire(event);
            }
        });
    }
}

