/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.preferences;

import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContribution;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContributionUser;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ReadOnlyFieldEditor
extends FieldEditor
implements ICBreakpointsUIContributionUser {
    protected Label textField;
    protected ICBreakpointsUIContribution contribution;

    public ReadOnlyFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.textField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.textField != null) {
            String tryValue;
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            if (this.contribution != null && (tryValue = this.contribution.getLabelForValue(value)) != null) {
                value = tryValue;
            }
            this.textField.setText(value);
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.textField.setText(value);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Label getTextControl() {
        return this.textField;
    }

    public Label getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Label(parent, 64);
            this.textField.setFont(parent.getFont());
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ReadOnlyFieldEditor.this.textField = null;
                }
            });
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public boolean isValid() {
        return true;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
    }

    protected void doStore() {
    }

    public ICBreakpointsUIContribution getContribution() {
        return this.contribution;
    }

    public void setContribution(ICBreakpointsUIContribution contribution) {
        this.contribution = contribution;
    }
}

