/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.AbstractPathOptionBlock;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathLibraryEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathOutputEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathProjectsEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathSourceEntryPage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CPathTabBlock
extends AbstractPathOptionBlock {
    private final int[] pathTypes = new int[]{8, 4, 128, 1, 32};
    private ListDialogField<CPElement> fCPathList;
    private CPathSourceEntryPage fSourcePage;
    private CPathProjectsEntryPage fProjectsPage;
    private CPathOutputEntryPage fOutputPage;
    private CPathContainerEntryPage fContainerPage;
    private CPathLibraryEntryPage fLibrariesPage;

    void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fCPathList) {
            this.updateCPathStatus();
        }
        this.doStatusLineUpdate();
    }

    public CPathTabBlock(IStatusChangeListener context, int pageToShow) {
        super(context, pageToShow);
        String[] stringArray = new String[5];
        stringArray[0] = CPathEntryMessages.CPathsBlock_path_up_button;
        stringArray[1] = CPathEntryMessages.CPathsBlock_path_down_button;
        stringArray[3] = CPathEntryMessages.CPathsBlock_path_checkall_button;
        stringArray[4] = CPathEntryMessages.CPathsBlock_path_uncheckall_button;
        String[] buttonLabels = stringArray;
        BuildPathAdapter adapter = new BuildPathAdapter();
        this.fCPathList = new ListDialogField(null, buttonLabels, null);
        this.fCPathList.setDialogFieldListener(adapter);
    }

    @Override
    protected List<CPElement> getCPaths() {
        return this.fCPathList.getElements();
    }

    @Override
    protected void addTabs() {
        this.fSourcePage = new CPathSourceEntryPage(this.fCPathList);
        this.addPage(this.fSourcePage);
        this.fOutputPage = new CPathOutputEntryPage(this.fCPathList);
        this.addPage(this.fOutputPage);
        this.fProjectsPage = new CPathProjectsEntryPage(this.fCPathList);
        this.addPage(this.fProjectsPage);
        this.fLibrariesPage = new CPathLibraryEntryPage(this.fCPathList);
        this.addPage(this.fLibrariesPage);
        this.fContainerPage = new CPathContainerEntryPage(this.fCPathList);
        this.addPage(this.fContainerPage);
    }

    @Override
    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.getCProject() != null) {
            this.fSourcePage.init(this.getCProject());
            this.fOutputPage.init(this.getCProject());
            this.fProjectsPage.init(this.getCProject());
            this.fContainerPage.init(this.getCProject());
            this.fLibrariesPage.init(this.getCProject());
        }
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    @Override
    protected void initialize(ICElement element, List<CPElement> cPaths) {
        this.fCPathList.setElements(cPaths);
        if (this.fProjectsPage != null) {
            this.fSourcePage.init(this.getCProject());
            this.fOutputPage.init(this.getCProject());
            this.fProjectsPage.init(this.getCProject());
            this.fContainerPage.init(this.getCProject());
            this.fLibrariesPage.init(this.getCProject());
        }
        this.doStatusLineUpdate();
        this.initializeTimeStamps();
    }

    @Override
    protected int[] getFilteredTypes() {
        return this.pathTypes;
    }

    @Override
    protected int[] getAppliedFilteredTypes() {
        return this.pathTypes;
    }

    public void updateCPathStatus() {
        this.getPathStatus().setOK();
        List<CPElement> elements = this.fCPathList.getElements();
        CPElement entryError = null;
        int nErrorEntries = 0;
        IPathEntry[] entries = new IPathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPElement currElement = elements.get(i);
            entries[i] = currElement.getPathEntry();
            if (currElement.getStatus().getSeverity() != 0) {
                ++nErrorEntries;
                if (entryError == null) {
                    entryError = currElement;
                }
            }
            --i;
        }
        if (nErrorEntries > 0) {
            if (nErrorEntries == 1 && entryError != null) {
                this.getPathStatus().setWarning(entryError.getStatus().getMessage());
            } else {
                this.getPathStatus().setWarning(NLS.bind((String)CPathEntryMessages.CPElement_status_multiplePathErrors, (Object)String.valueOf(nErrorEntries)));
            }
        }
        this.updateBuildPathStatus();
    }

    private class BuildPathAdapter
    implements IDialogFieldListener {
        private BuildPathAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            CPathTabBlock.this.buildPathDialogFieldChanged(field);
        }
    }
}

