/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.language.LanguageMappingLinkListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LanguageMappingWidget {
    protected static final int MINIMUM_COLUMN_WIDTH = 150;
    protected Composite fContents;
    protected boolean fIsReadOnly;
    protected Table fTable;
    protected HashMap<String, String> fContentTypeNamesToIDsMap;
    protected Set<IContentType> fAffectedContentTypes;
    protected Font fOverriddenFont = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
    protected LanguageMappingWidget fChild;
    protected IAdaptable fElement;
    protected Set<String> fOverriddenContentTypes = Collections.emptySet();
    private boolean fIsChanged;

    public LanguageMappingWidget() {
        this.fContentTypeNamesToIDsMap = new HashMap();
        String[] contentTypesIDs = LanguageManager.getInstance().getRegisteredContentTypeIds();
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        int i = 0;
        while (i < contentTypesIDs.length) {
            String name = contentTypeManager.getContentType(contentTypesIDs[i]).getName();
            this.fContentTypeNamesToIDsMap.put(name, contentTypesIDs[i]);
            ++i;
        }
        this.fAffectedContentTypes = new HashSet<IContentType>();
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
    }

    public void setOverriddenContentTypes(Set<String> contentTypes) {
        this.fOverriddenContentTypes = contentTypes;
    }

    public IContentType[] getAffectedContentTypes() {
        return this.fAffectedContentTypes.toArray(new IContentType[this.fAffectedContentTypes.size()]);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public void setChild(LanguageMappingWidget child) {
        this.fChild = child;
    }

    public boolean isChanged() {
        return this.fIsChanged;
    }

    public void setChanged(boolean changed) {
        this.fIsChanged = changed;
    }

    protected void createHeader(Composite parent, String description) {
        Link link = new Link(this.fContents, 0);
        link.setText(description);
        link.addListener(13, (Listener)new LanguageMappingLinkListener(this.fContents.getShell(), this.getElement()){

            protected void refresh() {
                LanguageMappingWidget.this.refreshMappings();
            }
        });
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
    }

    public abstract Composite createContents(Composite var1, String var2);

    public abstract void refreshMappings();
}

