/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.ui.refactoring.CCompositeChange;
import org.eclipse.cdt.internal.ui.refactoring.CreateFileChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class ModificationCollector {
    private final Map<IASTTranslationUnit, ASTRewrite> rewriters = new HashMap<IASTTranslationUnit, ASTRewrite>();
    private Collection<CreateFileChange> changes;

    public ASTRewrite rewriterForTranslationUnit(IASTTranslationUnit ast) {
        if (!this.rewriters.containsKey(ast)) {
            this.rewriters.put(ast, ASTRewrite.create((IASTTranslationUnit)ast));
        }
        return this.rewriters.get(ast);
    }

    public void addFileChange(CreateFileChange change) {
        if (this.changes == null) {
            this.changes = new ArrayList<CreateFileChange>();
        }
        this.changes.add(change);
    }

    public CCompositeChange createFinalChange() {
        CCompositeChange result = new CCompositeChange("");
        result.markAsSynthetic();
        if (this.changes != null) {
            for (Change change : this.changes) {
                this.addFlattened(change, result);
            }
        }
        for (ASTRewrite aSTRewrite : this.rewriters.values()) {
            Change change = aSTRewrite.rewriteAST();
            this.addFlattened(change, result);
        }
        return result;
    }

    private void addFlattened(Change change, CompositeChange receiver) {
        if (change instanceof CompositeChange) {
            receiver.merge((CompositeChange)change);
        } else {
            receiver.add(change);
        }
    }
}

