/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;

public class SelectionHelper {
    public static Region getRegion(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection txtSelection = (ITextSelection)selection;
            return new Region(txtSelection.getOffset(), txtSelection.getLength());
        }
        return null;
    }

    public static IASTSimpleDeclaration findFirstSelectedDeclaration(final Region textSelection, IASTTranslationUnit translationUnit) {
        final Container container = new Container();
        translationUnit.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof IASTSimpleDeclaration && SelectionHelper.isSelectionOnExpression(textSelection, (IASTNode)declaration)) {
                    container.setObject((IASTSimpleDeclaration)declaration);
                }
                return super.visit(declaration);
            }
        });
        return (IASTSimpleDeclaration)container.getObject();
    }

    public static boolean isSelectionOnExpression(Region textSelection, IASTNode expression) {
        Region exprPos = SelectionHelper.createExpressionPosition(expression);
        int exprStart = exprPos.getOffset();
        int selStart = textSelection.getOffset();
        int selEnd = selStart + textSelection.getLength();
        return exprStart + exprPos.getLength() >= selStart && exprStart <= selEnd;
    }

    public static boolean isExpressionWhollyInSelection(Region textSelection, IASTNode expression) {
        Region exprPos = SelectionHelper.createExpressionPosition(expression);
        int exprStart = exprPos.getOffset();
        int selStart = textSelection.getOffset();
        int selEnd = selStart + textSelection.getLength();
        return exprStart >= selStart && exprStart + exprPos.getLength() <= selEnd;
    }

    public static boolean isInSameFile(IASTNode node, IFile file) {
        Path path = new Path(node.getContainingFilename());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile locFile = workspaceRoot.getFile(file.getLocation());
        IFile tmpFile = workspaceRoot.getFile((IPath)path);
        return locFile.equals((Object)tmpFile);
    }

    public static boolean isInSameFileSelection(Region textSelection, IASTNode node, IFile file) {
        if (SelectionHelper.isInSameFile(node, file)) {
            return SelectionHelper.isSelectionOnExpression(textSelection, node);
        }
        return false;
    }

    public static boolean isSelectedFile(Region textSelection, IASTNode node, IFile file) {
        if (SelectionHelper.isInSameFile(node, file)) {
            return SelectionHelper.isExpressionWhollyInSelection(textSelection, node);
        }
        return false;
    }

    protected static Region createExpressionPosition(IASTNode expression) {
        int start = Integer.MAX_VALUE;
        int nodeLength = 0;
        IASTNodeLocation[] nodeLocations = expression.getNodeLocations();
        if (nodeLocations.length != 1) {
            IASTNodeLocation[] iASTNodeLocationArray = nodeLocations;
            int n = nodeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeOffset;
                IASTNodeLocation location = iASTNodeLocationArray[n2];
                if (location instanceof IASTMacroExpansionLocation) {
                    IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                    nodeOffset = macroLoc.asFileLocation().getNodeOffset();
                    if (nodeOffset < start) {
                        start = nodeOffset;
                    }
                    nodeLength += macroLoc.asFileLocation().getNodeLength();
                } else {
                    IASTFileLocation loc = expression.getFileLocation();
                    nodeOffset = loc.getNodeOffset();
                    if (nodeOffset < start) {
                        start = nodeOffset;
                    }
                    nodeLength = loc.getNodeLength();
                }
                ++n2;
            }
        } else if (nodeLocations[0] instanceof IASTMacroExpansionLocation) {
            IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)nodeLocations[0];
            start = macroLoc.asFileLocation().getNodeOffset();
            nodeLength = macroLoc.asFileLocation().getNodeLength();
        } else {
            IASTFileLocation loc = expression.getFileLocation();
            start = loc.getNodeOffset();
            nodeLength = loc.getNodeLength();
        }
        return new Region(start, nodeLength);
    }
}

