/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.settingswizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.Messages;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsImportExportException;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.XMLUtils;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IncludePathsSettingsProcessor
extends SettingsProcessor {
    private static final String SECTION_NAME = "org.eclipse.cdt.internal.ui.wizards.settingswizards.IncludePaths";
    private static final String INCLUDE_PATH_ELEMENT = "includepath";
    private static final String WORKSPACE_PATH_ATTR = "workspace_path";

    public Image getIcon() {
        return CUIPlugin.getImageDescriptorRegistry().get(CDTSharedImages.getImageDescriptor("icons/obj16/hfolder_obj.gif"));
    }

    public String getDisplayName() {
        return Messages.ProjectSettingsWizardPage_Processor_Includes;
    }

    public String getSectionName() {
        return SECTION_NAME;
    }

    protected int getSettingsType() {
        return 1;
    }

    protected void writeSettings(ContentHandler content, ICLanguageSettingEntry setting) throws SettingsImportExportException {
        char[] value = setting.getValue().toCharArray();
        try {
            AttributesImpl attrib = null;
            if ((setting.getFlags() & 8) > 0) {
                attrib = new AttributesImpl();
                attrib.addAttribute("", "", WORKSPACE_PATH_ATTR, "", Boolean.TRUE.toString());
            }
            content.startElement("", "", INCLUDE_PATH_ELEMENT, attrib);
            content.characters(value, 0, value.length);
            content.endElement("", "", INCLUDE_PATH_ELEMENT);
            IncludePathsSettingsProcessor.newline(content);
        }
        catch (SAXException e) {
            throw new SettingsImportExportException(e);
        }
    }

    protected void readSettings(ICLanguageSetting setting, Element language) throws SettingsImportExportException {
        ArrayList<CIncludePathEntry> includes = new ArrayList<CIncludePathEntry>();
        List<Element> includeNodes = XMLUtils.extractChildElements(language, INCLUDE_PATH_ELEMENT);
        for (Element includeElement : includeNodes) {
            String include = includeElement.getTextContent();
            int flags = 0;
            if (include == null || include.length() <= 0) continue;
            if (includeElement.getAttribute(WORKSPACE_PATH_ATTR).equalsIgnoreCase(Boolean.TRUE.toString())) {
                flags |= 8;
            }
            includes.add(new CIncludePathEntry(include, flags));
        }
        if (includes.isEmpty()) {
            return;
        }
        includes.addAll(setting.getSettingEntriesList(1));
        setting.setSettingEntries(1, includes);
    }
}

