/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.resources;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.resources.RefreshExclusionContributor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshExclusionContributionManager {
    public static final String EXCLUSION_CONTRIBUTOR = "exclusionContributor";
    public static final String EXTENSION_ID = "RefreshExclusionContributor";
    private static RefreshExclusionContributionManager fInstance;
    private LinkedHashMap<String, RefreshExclusionContributor> fIDtoContributorsMap = new LinkedHashMap();

    public static synchronized RefreshExclusionContributionManager getInstance() {
        if (fInstance == null) {
            fInstance = new RefreshExclusionContributionManager();
        }
        return fInstance;
    }

    private RefreshExclusionContributionManager() {
        this.loadExtensions();
    }

    public RefreshExclusionContributor getContributor(String id) {
        return this.fIDtoContributorsMap.get(id);
    }

    public List<RefreshExclusionContributor> getContributors() {
        return this.getContributors(false);
    }

    public List<RefreshExclusionContributor> getContributors(boolean returnTestContributors) {
        LinkedList<RefreshExclusionContributor> retVal = new LinkedList<RefreshExclusionContributor>();
        if (!returnTestContributors) {
            for (RefreshExclusionContributor contributor : this.fIDtoContributorsMap.values()) {
                if (contributor.isTest()) continue;
                retVal.add(contributor);
            }
            return retVal;
        }
        return new LinkedList<RefreshExclusionContributor>(this.fIDtoContributorsMap.values());
    }

    public synchronized void loadExtensions() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", EXTENSION_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (configElement.getName().equals(EXCLUSION_CONTRIBUTOR)) {
                        String id = configElement.getAttribute("id");
                        String name = configElement.getAttribute("name");
                        String contributorClassName = configElement.getAttribute("class");
                        boolean isTest = false;
                        String isTestString = configElement.getAttribute("isTest");
                        if (isTestString != null) {
                            isTest = Boolean.getBoolean(isTestString);
                        }
                        if (contributorClassName != null) {
                            try {
                                Object execExt = configElement.createExecutableExtension("class");
                                if (execExt instanceof RefreshExclusionContributor && id != null) {
                                    RefreshExclusionContributor exclusionContributor = (RefreshExclusionContributor)execExt;
                                    exclusionContributor.setID(id);
                                    exclusionContributor.setName(name);
                                    exclusionContributor.setIsTest(isTest);
                                    this.fIDtoContributorsMap.put(id, exclusionContributor);
                                }
                            }
                            catch (CoreException e) {
                                CUIPlugin.log(e);
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

