/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.DefaultGnuToolFactory;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.xcoff.AR;
import org.eclipse.cdt.utils.xcoff.XCoff32;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryArchive;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryExecutable;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryObject;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryShared;
import org.eclipse.core.runtime.IPath;

public class XCOFF32Parser
extends AbstractCExtension
implements IBinaryParser {
    private IGnuToolFactory toolFactory;

    public IBinaryParser.IBinaryFile getBinary(byte[] hints, IPath path) throws IOException {
        if (path == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile binary = null;
        try {
            XCoff32.Attribute attribute = null;
            if (hints != null && hints.length > 0) {
                try {
                    attribute = XCoff32.getAttributes(hints);
                }
                catch (EOFException eOFException) {}
            }
            if (attribute == null) {
                attribute = XCoff32.getAttributes(path.toOSString());
            }
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        binary = this.createBinaryExecutable(path);
                        break;
                    }
                    case 2: {
                        binary = this.createBinaryShared(path);
                        break;
                    }
                    case 3: {
                        binary = this.createBinaryObject(path);
                        break;
                    }
                    case 4: {
                        binary = this.createBinaryCore(path);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            binary = this.createBinaryArchive(path);
        }
        return binary;
    }

    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        return this.getBinary(null, path);
    }

    public String getFormat() {
        return "XCOFF32";
    }

    public boolean isBinary(byte[] hints, IPath path) {
        return XCoff32.isXCOFF32Header(hints) || AR.isARHeader(hints);
    }

    public int getHintBufferSize() {
        return 512;
    }

    private IBinaryParser.IBinaryFile createBinaryExecutable(IPath path) {
        return new XCOFFBinaryExecutable(this, path);
    }

    private IBinaryParser.IBinaryShared createBinaryShared(IPath path) {
        return new XCOFFBinaryShared(this, path);
    }

    private IBinaryParser.IBinaryObject createBinaryObject(IPath path) {
        return new XCOFFBinaryObject((IBinaryParser)this, path, 1);
    }

    private IBinaryParser.IBinaryObject createBinaryCore(IPath path) {
        return new XCOFFBinaryObject((IBinaryParser)this, path, 16);
    }

    private IBinaryParser.IBinaryFile createBinaryArchive(IPath path) throws IOException {
        return new XCOFFBinaryArchive(this, path);
    }

    private DefaultGnuToolFactory createGNUToolFactory() {
        return new DefaultGnuToolFactory(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IGnuToolFactory.class)) {
            if (this.toolFactory == null) {
                this.toolFactory = this.createGNUToolFactory();
            }
            return this.toolFactory;
        }
        return super.getAdapter(adapter);
    }
}

