/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.core.DebugJobStorage;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.IPDebugEventListener;
import org.eclipse.ptp.debug.core.PDebugModel;
import org.eclipse.ptp.debug.core.event.IPDebugEvent;
import org.eclipse.ptp.debug.core.messages.Messages;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocation;
import org.eclipse.ptp.debug.core.sourcelookup.PSourceLookupDirector;
import org.eclipse.ptp.debug.internal.core.PDebugConfiguration;
import org.eclipse.ptp.debug.internal.core.sourcelookup.CommonSourceLookupDirector;
import org.eclipse.ptp.debug.internal.core.sourcelookup.SourceUtils;
import org.osgi.framework.BundleContext;

public class PTPDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.debug.core";
    public static final int INTERNAL_ERROR = 1000;
    public static final Object FAMILY_EVENT = new Object();
    public static final String PDEBUGGER_EXTENSION_POINT_ID = "parallelDebuggers";
    public static final String DEBUGGER_ELEMENT = "debugger";
    private static PTPDebugCorePlugin plugin;
    private static PDebugModel debugModel;
    private HashMap<String, PDebugConfiguration> fDebugConfigurations;
    private CommonSourceLookupDirector fCommonSourceLookupDirector;
    private final EventDispatchJob dispatchJob = new EventDispatchJob();
    private final ListenerList fEventListeners = new ListenerList();
    private final List<IPDebugEvent> fEventQueue = new ArrayList<IPDebugEvent>();
    private boolean fShuttingDown = false;
    private int fDispatching = 0;

    static {
        debugModel = null;
    }

    public static PDebugModel getDebugModel() {
        return debugModel;
    }

    public static PTPDebugCorePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (PTPDebugCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPDebugCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        PTPDebugCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        PTPDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, null));
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.PTPDebugCorePlugin_1, top));
    }

    public PTPDebugCorePlugin() {
        plugin = this;
    }

    public void addDebugEventListener(IPDebugEventListener listener) {
        this.fEventListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDebugEvent(IPDebugEvent event) {
        if (this.isShuttingDown() || event == null || this.fEventListeners.isEmpty()) {
            return;
        }
        List<IPDebugEvent> list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(event);
        }
        this.dispatchJob.schedule();
    }

    public int getCommandTimeout() {
        return Preferences.getInt((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_DEBUG_COMM_TIMEOUT);
    }

    public IPSourceLocation[] getCommonSourceLocations() {
        return SourceUtils.getCommonSourceLocationsFromMemento(Preferences.getString((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_SOURCE_LOCATIONS));
    }

    public PSourceLookupDirector getCommonSourceLookupDirector() {
        return this.fCommonSourceLookupDirector;
    }

    public IPDebugConfiguration getDebugConfiguration(String id) throws CoreException {
        IPDebugConfiguration dbgCfg;
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if ((dbgCfg = (IPDebugConfiguration)this.fDebugConfigurations.get(id)) == null) {
            Status status = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 100, Messages.PTPDebugCorePlugin_2, null);
            throw new CoreException((IStatus)status);
        }
        return dbgCfg;
    }

    public IPDebugConfiguration[] getDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        return this.fDebugConfigurations.values().toArray(new IPDebugConfiguration[0]);
    }

    public synchronized boolean isDispatching() {
        return this.fDispatching > 0;
    }

    public boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    public void removeDebugEventListener(IPDebugEventListener listener) {
        this.fEventListeners.remove((Object)listener);
    }

    public void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addSaveParticipant(PTPDebugCorePlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void saving(ISaveContext saveContext) throws CoreException {
                Preferences.savePreferences((String)PTPDebugCorePlugin.getUniqueIdentifier());
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
            }

            public void doneSaving(ISaveContext saveContext) {
            }
        });
        debugModel = new PDebugModel();
        this.initializeCommonSourceLookupDirector();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.setShuttingDown(true);
            debugModel.shutdown();
            this.disposeCommonSourceLookupDirector();
            this.disposeDebugConfigurations();
            DebugJobStorage.removeDebugStorages();
            Preferences.savePreferences((String)PTPDebugCorePlugin.getUniqueIdentifier());
            ResourcesPlugin.getWorkspace().removeSaveParticipant(PTPDebugCorePlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(context);
        }
    }

    private void disposeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector != null) {
            this.fCommonSourceLookupDirector.dispose();
        }
    }

    private void disposeDebugConfigurations() {
        if (this.fDebugConfigurations != null) {
            this.fDebugConfigurations.clear();
            this.fDebugConfigurations = null;
        }
    }

    private Object[] getEventListeners() {
        return this.fEventListeners.getListeners();
    }

    private void initializeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector == null) {
            this.fCommonSourceLookupDirector = new CommonSourceLookupDirector();
            String newMemento = Preferences.getString((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_COMMON_SOURCE_CONTAINERS);
            if (newMemento.length() == 0) {
                this.fCommonSourceLookupDirector.setSourceContainers(SourceUtils.convertSourceLocations(this.getCommonSourceLocations()));
            } else {
                try {
                    this.fCommonSourceLookupDirector.initializeFromMemento(newMemento);
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.log(e.getStatus());
                }
            }
        }
    }

    private void initializeDebugConfiguration() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PTPDebugCorePlugin.getUniqueIdentifier(), PDEBUGGER_EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fDebugConfigurations = new HashMap(infos.length);
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement configurationElement = infos[i];
                PDebugConfiguration configType = new PDebugConfiguration(configurationElement);
                this.fDebugConfigurations.put(configType.getID(), configType);
                ++i;
            }
        }
    }

    private synchronized void setDispatching(boolean dispatching) {
        this.fDispatching = dispatching ? ++this.fDispatching : --this.fDispatching;
    }

    private class EventDispatchJob
    extends Job {
        private final EventNotifier fNotifier;

        public EventDispatchJob() {
            super("EventDispatchJob");
            this.fNotifier = new EventNotifier();
            this.setPriority(10);
            this.setSystem(true);
        }

        public boolean shouldRun() {
            return this.shouldSchedule();
        }

        public boolean shouldSchedule() {
            return !PTPDebugCorePlugin.this.isShuttingDown() && !PTPDebugCorePlugin.this.fEventListeners.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!PTPDebugCorePlugin.this.fEventQueue.isEmpty()) {
                IPDebugEvent event = null;
                List list = PTPDebugCorePlugin.this.fEventQueue;
                synchronized (list) {
                    if (!PTPDebugCorePlugin.this.fEventQueue.isEmpty()) {
                        event = (IPDebugEvent)PTPDebugCorePlugin.this.fEventQueue.remove(0);
                    }
                }
                if (event == null) continue;
                this.fNotifier.dispatch(event);
            }
            return Status.OK_STATUS;
        }
    }

    private class EventNotifier
    implements ISafeRunnable {
        private IPDebugEvent fEvent;
        private IPDebugEventListener fListener;

        private EventNotifier() {
        }

        public void dispatch(IPDebugEvent event) {
            this.fEvent = event;
            try {
                PTPDebugCorePlugin.this.setDispatching(true);
                Object[] listeners = PTPDebugCorePlugin.this.getEventListeners();
                int i = 0;
                while (i < listeners.length) {
                    this.fListener = (IPDebugEventListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)this);
                    ++i;
                }
            }
            finally {
                PTPDebugCorePlugin.this.setDispatching(false);
            }
            this.fEvent = null;
            this.fListener = null;
        }

        public void handleException(Throwable exception) {
            PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, Messages.PTPDebugCorePlugin_0, exception));
        }

        public void run() throws Exception {
            this.fListener.handleDebugEvent(this.fEvent);
        }
    }
}

