/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIInternalEventRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventResultRequest
extends AbstractEventRequest
implements IPDIInternalEventRequest {
    private final Object lock = new Object();
    protected Map<TaskSet, Object> results = new HashMap<TaskSet, Object>();
    protected long DEFAULT_TIMEOUT = 5000L;

    public AbstractEventResultRequest(TaskSet tasks) {
        super(tasks);
    }

    @Override
    public boolean completed(TaskSet cTasks, Object result) {
        if (this.tasks.intersects(cTasks)) {
            this.storeResult(cTasks.copy(), result);
            this.notifyWaiting();
            return super.completed(cTasks, result);
        }
        return false;
    }

    @Override
    public int getResponseAction() {
        return 2;
    }

    @Override
    public Object getResult(TaskSet qTasks) throws PDIException {
        if (this.findResult(qTasks)) {
            return this.results.get(qTasks);
        }
        for (TaskSet sTasks : this.results.keySet()) {
            if (!sTasks.intersects(qTasks)) continue;
            return this.results.get(sTasks);
        }
        throw new PDIException(qTasks, NLS.bind((String)Messages.AbstractEventResultRequest_0, (Object)this.getName()));
    }

    @Override
    public Map<TaskSet, Object> getResultMap(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        return this.results;
    }

    @Override
    public void waitUntilCompleted(TaskSet qTasks) throws PDIException {
        this.waiting();
        if (this.status == 1) {
            throw new PDIException(qTasks, this.getErrorMessage());
        }
    }

    @Override
    public void waitUntilCompleted(TaskSet qTasks, IProgressMonitor monitor) throws PDIException {
        while (!(this.tasks.isEmpty() || this.status != 5 && this.status != 2)) {
            if (monitor.isCanceled()) {
                this.error(Messages.AbstractEventResultRequest_1);
                break;
            }
            this.lockRequest(500L);
            monitor.worked(1);
        }
        if (this.status == 1) {
            throw new PDIException(qTasks, this.getErrorMessage());
        }
        if (this.status == 3) {
            monitor.done();
        }
    }

    private void notifyWaiting() {
        this.releaseRequest();
    }

    @Override
    protected void doFinish() throws PDIException {
        this.notifyWaiting();
    }

    protected boolean findResult(TaskSet qTasks) {
        return this.results.containsKey(qTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockRequest(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseRequest() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    protected abstract void storeResult(TaskSet var1, Object var2);

    protected void storeUnknownResult(TaskSet rTasks, Object result) {
        this.results.put(rTasks, result);
    }

    protected void waiting() {
        while (!(this.tasks.isEmpty() || this.status != 5 && this.status != 2)) {
            this.lockRequest(this.DEFAULT_TIMEOUT);
        }
    }
}

