/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIAddressLocation;
import org.eclipse.ptp.debug.core.pdi.IPDICondition;
import org.eclipse.ptp.debug.core.pdi.IPDIFunctionLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILineLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILocation;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocationBreakpoint;
import org.eclipse.ptp.debug.internal.core.pdi.model.Breakpoint;

public abstract class LocationBreakpoint
extends Breakpoint
implements IPDILocationBreakpoint {
    private IPDILocation location;

    public LocationBreakpoint(IPDISession session, TaskSet tasks, int type, IPDILocation location, IPDICondition condition, boolean enabled) {
        super(session, tasks, type, condition, enabled);
        this.location = location;
    }

    public BigInteger getAddress() {
        if (this.location instanceof IPDIAddressLocation) {
            return ((IPDIAddressLocation)this.location).getAddress();
        }
        return null;
    }

    public String getFile() {
        if (this.location instanceof IPDILineLocation) {
            return ((IPDILineLocation)this.location).getFile();
        }
        if (this.location instanceof IPDIFunctionLocation) {
            return ((IPDIFunctionLocation)this.location).getFile();
        }
        return null;
    }

    public String getFunction() {
        if (this.location instanceof IPDIFunctionLocation) {
            return ((IPDIFunctionLocation)this.location).getFunction();
        }
        return null;
    }

    public int getLineNumber() {
        if (this.location instanceof IPDILineLocation) {
            return ((IPDILineLocation)this.location).getLineNumber();
        }
        return 0;
    }

    public IPDILocator getLocator() {
        return PDILocationFactory.newLocator(this.getFile(), this.getFunction(), this.getLineNumber(), this.getAddress());
    }
}

