/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMemory;

public class Memory
implements IPDIMemory {
    private String addr;
    private long[] data = new long[0];
    private List<Integer> badOffsets = new ArrayList<Integer>();
    private String ascii = "";

    public Memory(String addr, String ascii, String[] values) {
        this.addr = addr;
        this.ascii = ascii;
        this.parse(values);
    }

    public String getAddress() {
        return this.addr;
    }

    public String getAscii() {
        return this.ascii;
    }

    public int[] getBadOffsets() {
        int[] data = new int[this.badOffsets.size()];
        int i = 0;
        while (i < data.length) {
            Integer o = this.badOffsets.get(i);
            data[i] = o;
            ++i;
        }
        return data;
    }

    public long[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(Messages.Memory_1) + this.addr + "\"");
        buffer.append(Messages.Memory_3);
        int i = 0;
        while (i < this.data.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append('\"').append(Long.toHexString(this.data[i])).append('\"');
            ++i;
        }
        buffer.append(']');
        if (this.ascii.length() > 0) {
            buffer.append(String.valueOf(Messages.Memory_4) + this.ascii + "\"");
        }
        return buffer.toString();
    }

    private void parse(String[] values) {
        this.data = new long[values.length];
        int i = 0;
        while (i < values.length) {
            try {
                this.data[i] = Long.decode(values[i].trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.badOffsets.add(new Integer(i));
                this.data[i] = 0L;
            }
            ++i;
        }
    }
}

