/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.ExtFormat;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.SessionObject;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDataReadMemoryInfo;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIExpressionManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIMemoryManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIRegisterManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIVariableManager;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMemory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMemoryBlock;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDataWriteMemoryRequest;

public class MemoryBlock
extends SessionObject
implements IPDIMemoryBlock {
    private IPDIDataReadMemoryInfo mem;
    private int fWordSize;
    private BigInteger pStartAddress;
    private byte[] cBytes;
    private int[] badOffsets;
    private boolean fIsLittleEndian;
    String expression;
    boolean frozen;

    public MemoryBlock(IPDISession session, TaskSet tasks, String exp, int wordSize, boolean isLittle, IPDIDataReadMemoryInfo info) {
        super(session, tasks);
        this.expression = exp;
        this.fWordSize = wordSize;
        this.frozen = true;
        this.fIsLittleEndian = isLittle;
        this.setDataReadMemoryInfo(info);
    }

    public byte[] getBytes() throws PDIException {
        return this.cBytes;
    }

    public IPDIDataReadMemoryInfo getDataReadMemoryInfo() {
        return this.mem;
    }

    public String getExpression() {
        return this.expression;
    }

    public synchronized byte getFlags(int offset) {
        if (offset < 0 || (long)offset >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.badOffsets == null) {
            this.badOffsets = this.getBadOffsets(this.mem);
        }
        if (this.badOffsets != null) {
            int i = 0;
            while (i < this.badOffsets.length) {
                if (this.badOffsets[i] == offset) {
                    return 0;
                }
                ++i;
            }
        }
        return 2;
    }

    public long getLength() {
        try {
            return this.getBytes().length;
        }
        catch (PDIException pDIException) {
            return this.mem.getTotalBytes();
        }
    }

    public BigInteger getStartAddress() {
        return this.pStartAddress;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void refresh() throws PDIException {
        IPDIMemoryManager mgr = this.session.getMemoryManager();
        BigInteger[] addresses = mgr.update(this, null);
        if (addresses.length > 0) {
            IPDIMemoryBlock[] blocks = mgr.getMemoryBlocks(this.getTasks());
            int i = 0;
            while (i < blocks.length) {
                MemoryBlock block = (MemoryBlock)blocks[i];
                if (!block.equals(this) && block.contains(addresses)) {
                    mgr.update(block, null);
                }
                ++i;
            }
        }
    }

    public void setDataReadMemoryInfo(IPDIDataReadMemoryInfo m) {
        this.pStartAddress = ExtFormat.getBigInteger(m.getAddress());
        this.cBytes = this.getBytes(m);
        this.mem = m;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(long offset, byte[] bytes) throws PDIException {
        IPDIVariableManager varMgr;
        IPDIExpressionManager expMgr;
        if (offset >= this.getLength() || offset + (long)bytes.length > this.getLength()) {
            throw new PDIException(this.getTasks(), Messages.MemoryBlock_0);
        }
        int i = 0;
        while (i < bytes.length) {
            long l = new Byte(bytes[i]).longValue() & 0xFFL;
            String value = "0x" + Long.toHexString(l);
            IPDIDataWriteMemoryRequest request = this.session.getRequestFactory().getDataWriteMemoryRequest(this.getTasks(), offset + (long)i, this.expression, 0, 1, value);
            this.session.getEventRequestManager().addEventRequest(request);
            request.waitUntilCompleted(this.getTasks());
            ++i;
        }
        this.refresh();
        IPDIRegisterManager regMgr = this.session.getRegisterManager();
        if (regMgr.isAutoUpdate()) {
            regMgr.update(this.getTasks());
        }
        if ((expMgr = this.session.getExpressionManager()).isAutoUpdate()) {
            expMgr.update(this.getTasks());
        }
        if ((varMgr = this.session.getVariableManager()).isAutoUpdate()) {
            varMgr.update(this.getTasks());
        }
    }

    private boolean contains(BigInteger addr) {
        BigInteger start = this.getStartAddress();
        long length = this.getLength();
        return start.compareTo(addr) <= 0 && addr.compareTo(start.add(BigInteger.valueOf(length))) <= 0;
    }

    private boolean contains(BigInteger[] adds) {
        int i = 0;
        while (i < adds.length) {
            if (this.contains(adds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int[] getBadOffsets(IPDIDataReadMemoryInfo m) {
        int[] offsets = new int[]{};
        if (m == null) {
            return offsets;
        }
        IPDIMemory[] miMem = m.getMemories();
        int i = 0;
        while (i < miMem.length) {
            int[] data = miMem[i].getBadOffsets();
            if (data.length > 0) {
                int olen = offsets.length;
                int[] newOffsets = new int[olen + data.length];
                System.arraycopy(offsets, 0, newOffsets, 0, olen);
                System.arraycopy(data, 0, newOffsets, olen, data.length);
                offsets = newOffsets;
            }
            ++i;
        }
        return offsets;
    }

    private byte[] getBytes(IPDIDataReadMemoryInfo m) {
        byte[] bytes = new byte[]{};
        if (m == null) {
            return bytes;
        }
        IPDIMemory[] miMem = m.getMemories();
        int i = 0;
        while (i < miMem.length) {
            long[] data = miMem[i].getData();
            if (data != null && data.length > 0) {
                int j = 0;
                while (j < data.length) {
                    byte[] bs = this.longToBytes(data[j]);
                    int blen = bytes.length;
                    byte[] newBytes = new byte[blen + bs.length];
                    System.arraycopy(bytes, 0, newBytes, 0, blen);
                    System.arraycopy(bs, 0, newBytes, blen, bs.length);
                    bytes = newBytes;
                    ++j;
                }
            }
            ++i;
        }
        return bytes;
    }

    private byte[] longToBytes(long v) {
        int count = 1;
        long value = v;
        count = 1;
        while ((value /= 256L) > 0L) {
            ++count;
        }
        if (this.fWordSize != count) {
            this.fWordSize = count;
        }
        byte[] bytes = new byte[count];
        if (this.fIsLittleEndian) {
            int i = count - 1;
            while (i >= 0) {
                int shift = i * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                --i;
            }
        } else {
            int i = 0;
            while (i < count) {
                int shift = (count - i - 1) * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                ++i;
            }
        }
        return bytes;
    }
}

